/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.TypeFile;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InfoType {
    public static HashMap<Integer, InfoType> infoTypes = new HashMap();
    public String contentPack;
    public Item item;
    public int colour = 0xFFFFFF;
    public String iconPath;
    public Object[] recipe;
    public String[] recipeLine;
    public int recipeOutput = 1;
    public boolean shapeless;
    public String smeltableFrom = null;
    public String name;
    public String shortName;
    public String texture;
    public String modelString = null;
    public String description;
    public float modelScale = 1.0f;
    public boolean canDrop = true;
    public int dungeonChance = 1;
    private static Random random = new Random();
    public static int totalDungeonChance = 0;

    public InfoType(TypeFile file) {
        this.contentPack = file.contentPack;
    }

    public void read(TypeFile file) {
        this.preRead(file);
        while (true) {
            String[] split;
            String line = null;
            line = file.readLine();
            if (line == null) break;
            if (line.startsWith("//") || (split = line.split(" ")).length < 2) continue;
            this.read(split, file);
        }
        this.postRead(file);
        infoTypes.put(this.shortName.hashCode(), this);
        totalDungeonChance += this.dungeonChance;
    }

    protected void preRead(TypeFile file) {
    }

    protected void postRead(TypeFile file) {
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return null;
    }

    protected void read(String[] split, TypeFile file) {
        try {
            this.shortName = this.Read(split, "ShortName", this.shortName);
            this.name = this.ReadAndConcatenateMultipleStrings(split, "Name", this.name);
            this.description = this.ReadAndConcatenateMultipleStrings(split, "Description", this.description);
            this.modelString = this.Read(split, "Model", this.modelString);
            this.modelScale = this.Read(split, "ModelScale", this.modelScale);
            this.texture = this.Read(split, "Texture", this.texture);
            this.iconPath = this.Read(split, "Icon", this.iconPath);
            this.dungeonChance = this.Read(split, "DungeonProbability", this.dungeonChance);
            this.dungeonChance = this.Read(split, "DungeonLootChance", this.dungeonChance);
            this.recipeOutput = this.Read(split, "RecipeOutput", this.recipeOutput);
            this.smeltableFrom = this.Read(split, "SmeltableFrom", this.smeltableFrom);
            this.canDrop = this.Read(split, "CanDrop", this.canDrop);
            if (split[0].equals("Colour") || split[0].equals("Color")) {
                this.colour = (Integer.parseInt(split[1]) << 16) + (Integer.parseInt(split[2]) << 8) + Integer.parseInt(split[3]);
            }
            if (split[0].equals("Recipe")) {
                this.recipe = new Object[split.length + 2];
                for (int i = 0; i < 3; ++i) {
                    String line = null;
                    line = file.readLine();
                    if (line == null) continue;
                    if (line == null || line.startsWith("//")) {
                        --i;
                        continue;
                    }
                    this.recipe[i] = line;
                }
                this.recipeLine = split;
                this.shapeless = false;
            } else if (split[0].equals("ShapelessRecipe")) {
                this.recipeLine = split;
                this.shapeless = true;
            }
        }
        catch (Exception e) {
            FlansMod.log("Reading file failed : " + this.shortName);
            e.printStackTrace();
        }
    }

    protected boolean KeyMatches(String[] split, String key) {
        return split != null && split.length > 1 && key != null && split[0].toLowerCase().equals(key.toLowerCase());
    }

    protected int Read(String[] split, String key, int currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length == 2) {
                try {
                    currentValue = Integer.parseInt(split[1]);
                }
                catch (Exception e) {
                    InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Passed in value is not an integer");
                }
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <integer value>\"");
            }
        }
        return currentValue;
    }

    protected float Read(String[] split, String key, float currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length == 2) {
                try {
                    currentValue = Float.parseFloat(split[1]);
                }
                catch (Exception e) {
                    InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Passed in value is not an float");
                }
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <float value>\"");
            }
        }
        return currentValue;
    }

    protected double Read(String[] split, String key, double currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length == 2) {
                try {
                    currentValue = Double.parseDouble(split[1]);
                }
                catch (Exception e) {
                    InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Passed in value is not an float");
                }
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <float value>\"");
            }
        }
        return currentValue;
    }

    protected String Read(String[] split, String key, String currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length == 2) {
                currentValue = split[1];
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <singleWord>\"");
            }
        }
        return currentValue;
    }

    protected String ReadAndConcatenateMultipleStrings(String[] split, String key, String currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length > 1) {
                currentValue = split[1];
                for (int i = 0; i < split.length - 2; ++i) {
                    currentValue = currentValue + " " + split[i + 2];
                }
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <long string>\"");
            }
        }
        return currentValue;
    }

    protected boolean Read(String[] split, String key, boolean currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length == 2) {
                try {
                    currentValue = Boolean.parseBoolean(split[1]);
                }
                catch (Exception e) {
                    InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Passed in value is not an boolean");
                }
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <true/false>\"");
            }
        }
        return currentValue;
    }

    protected static void LogError(String shortName, String s) {
        FlansMod.log("[Problem in " + shortName + ".txt]" + s);
    }

    public String toString() {
        return super.getClass().getSimpleName() + ": " + this.shortName;
    }

    public void addRecipe() {
        this.addRecipe(this.getItem());
    }

    public void addRecipe(Item par1Item) {
        if (this.smeltableFrom != null) {
            GameRegistry.addSmelting((ItemStack)InfoType.getRecipeElement(this.smeltableFrom, 0), (ItemStack)new ItemStack(this.item), (float)0.0f);
        }
        if (this.recipeLine == null) {
            return;
        }
        try {
            if (!this.shapeless) {
                Object[] newRecipe1;
                int last;
                int rows = 3;
                if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                    int i;
                    for (i = 0; i < 3; ++i) {
                        this.recipe[i] = ((String)this.recipe[i]).substring(1);
                    }
                    if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(1);
                        }
                    }
                }
                if (((String)this.recipe[0]).charAt(last = ((String)this.recipe[0]).length() - 1) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                    int i;
                    for (i = 0; i < 3; ++i) {
                        this.recipe[i] = ((String)this.recipe[i]).substring(0, last);
                    }
                    if (((String)this.recipe[0]).charAt(--last) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(0, 0);
                        }
                    }
                }
                if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                    Object[] newRecipe = new Object[this.recipe.length - 1];
                    newRecipe[0] = this.recipe[1];
                    newRecipe[1] = this.recipe[2];
                    this.recipe = newRecipe;
                    --rows;
                    if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                        newRecipe1 = new Object[this.recipe.length - 1];
                        newRecipe1[0] = this.recipe[1];
                        this.recipe = newRecipe1;
                        --rows;
                    }
                }
                if (this.recipe[rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                    Object[] newRecipe = new Object[this.recipe.length - 1];
                    newRecipe[0] = this.recipe[0];
                    newRecipe[1] = this.recipe[1];
                    this.recipe = newRecipe;
                    if (this.recipe[--rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                        newRecipe1 = new Object[this.recipe.length - 1];
                        newRecipe1[0] = this.recipe[0];
                        this.recipe = newRecipe1;
                        --rows;
                    }
                }
                for (int i = 0; i < (this.recipeLine.length - 1) / 2; ++i) {
                    this.recipe[i * 2 + rows] = Character.valueOf(this.recipeLine[i * 2 + 1].charAt(0));
                    this.recipe[i * 2 + rows + 1] = InfoType.getRecipeElement(this.recipeLine[i * 2 + 2]);
                }
                GameRegistry.addRecipe((ItemStack)new ItemStack(this.item, this.recipeOutput), (Object[])this.recipe);
            } else {
                this.recipe = new Object[this.recipeLine.length - 1];
                for (int i = 0; i < this.recipeLine.length - 1; ++i) {
                    this.recipe[i] = InfoType.getRecipeElement(this.recipeLine[i + 1]);
                }
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.item, this.recipeOutput), (Object[])this.recipe);
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to add recipe for : " + this.shortName);
            e.printStackTrace();
        }
    }

    protected int getDyeDamageValue(String dyeName) {
        int damage = -1;
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            if (!EnumDyeColor.func_176766_a((int)i).func_176762_d().equals(dyeName)) continue;
            damage = i;
        }
        if (damage == -1) {
            FlansMod.log("Failed to find dye colour : " + dyeName + " while adding " + this.contentPack);
        }
        return damage;
    }

    public Item getItem() {
        return this.item;
    }

    public static ItemStack getNonRecipeElement(String str) {
        if (str.contains(".")) {
            return InfoType.getRecipeElement(str.split("\\.")[0], Integer.valueOf(str.split("\\.")[1]));
        }
        return InfoType.getRecipeElement(str, 0);
    }

    public static ItemStack getRecipeElement(String str) {
        if (str.contains(".")) {
            return InfoType.getRecipeElement(str.split("\\.")[0], Integer.valueOf(str.split("\\.")[1]));
        }
        return InfoType.getRecipeElement(str, Short.MAX_VALUE);
    }

    public static ItemStack getRecipeElement(String s, int damage) {
        return InfoType.getRecipeElement(s, 1, damage);
    }

    public static ItemStack getRecipeElement(String s, int amount, int damage) {
        return InfoType.getRecipeElement(s, amount, damage, "nothing");
    }

    public static ItemStack getRecipeElement(String s, int amount, int damage, String requester) {
        if (s.equals("doorIron")) {
            return new ItemStack(Items.field_151139_aw, amount);
        }
        if (s.equals("clayItem")) {
            return new ItemStack(Items.field_151119_aD, amount);
        }
        for (Object object : Item.field_150901_e) {
            Item item = (Item)object;
            if (item == null || item.func_77658_a() == null || !item.func_77658_a().equals("item." + s) && !item.func_77658_a().equals("tile." + s)) continue;
            return new ItemStack(item, amount, damage);
        }
        for (InfoType type : infoTypes.values()) {
            if (!type.shortName.equals(s)) continue;
            return new ItemStack(type.item, amount, damage);
        }
        if (s.equals("gunpowder")) {
            return new ItemStack(Items.field_151016_H, amount);
        }
        if (s.equals("iron")) {
            return new ItemStack(Items.field_151042_j, amount);
        }
        FlansMod.log("Could not find " + s + " when adding recipe for " + requester);
        return null;
    }

    public void reloadModel() {
    }

    public int hashCode() {
        return this.shortName.hashCode();
    }

    public static InfoType getType(String s) {
        return infoTypes.get(s.hashCode());
    }

    public static InfoType getType(int hash) {
        return infoTypes.get(hash);
    }

    public void onWorldLoad(World world) {
    }

    public static InfoType getType(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFlanItem) {
            return ((IFlanItem)item).getInfoType();
        }
        return null;
    }

    public static PotionEffect getPotionEffect(String[] split) {
        int potionID = Integer.parseInt(split[1]);
        int duration = Integer.parseInt(split[2]);
        int amplifier = Integer.parseInt(split[3]);
        return new PotionEffect(potionID, duration, amplifier, false, false);
    }

    public static Material getMaterial(String mat) {
        return Material.field_151578_c;
    }

    public void addDungeonLoot() {
        if (this.dungeonChance > 0) {
            ItemStack stack = new ItemStack(this.item);
            this.addToRandomChest(stack, (float)(FlansMod.dungeonLootChance * this.dungeonChance) / (float)totalDungeonChance);
        }
    }

    protected void addToRandomChest(ItemStack stack, float rawChance) {
        if (rawChance >= 1.0f || random.nextFloat() < rawChance) {
            int chance = MathHelper.func_76123_f((float)rawChance);
            switch (random.nextInt(10)) {
                case 0: {
                    ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(this.item), 1, 1, chance));
                    break;
                }
                case 1: {
                    ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(this.item), 1, 1, chance));
                    break;
                }
                case 2: {
                    ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(this.item), 1, 1, chance));
                    break;
                }
                case 3: {
                    ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(this.item), 1, 1, chance));
                    break;
                }
                case 4: {
                    ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(this.item), 1, 1, chance));
                    break;
                }
                case 5: {
                    ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(this.item), 1, 1, chance));
                    break;
                }
                case 6: {
                    ChestGenHooks.addItem((String)"strongholdCrossing", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(this.item), 1, 1, chance));
                    break;
                }
                case 7: {
                    ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(this.item), 1, 1, chance));
                    break;
                }
                case 8: {
                    ChestGenHooks.addItem((String)"bonusChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(this.item), 1, 1, chance));
                    break;
                }
                case 9: {
                    ChestGenHooks.addItem((String)"netherFortress", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(this.item), 1, 1, chance));
                }
            }
        }
    }
}

