/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types;

import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.types.IPaintableItem;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public abstract class PaintableType
extends InfoType {
    public ArrayList<Paintjob> paintjobs = new ArrayList();
    public Paintjob defaultPaintjob;
    private int nextPaintjobID = 1;
    private static HashMap<Integer, PaintableType> paintableTypes = new HashMap();

    public static PaintableType GetPaintableType(int iHash) {
        return paintableTypes.get(iHash);
    }

    public static PaintableType GetPaintableType(String name) {
        return paintableTypes.get(name.hashCode());
    }

    public PaintableType(TypeFile file) {
        super(file);
    }

    @Override
    public void postRead(TypeFile file) {
        this.defaultPaintjob = new Paintjob(this, 0, "", this.texture, new ItemStack[0]);
        ArrayList<Paintjob> newPaintjobList = new ArrayList<Paintjob>();
        newPaintjobList.add(this.defaultPaintjob);
        newPaintjobList.addAll(this.paintjobs);
        this.paintjobs = newPaintjobList;
        if (infoTypes.containsKey(this.shortName.hashCode())) {
            FlansMod.Assert(false, "Duplicate info type name " + this.shortName);
        }
        totalDungeonChance += this.dungeonChance * (this.paintjobs.size() - 1);
        paintableTypes.put(this.shortName.hashCode(), this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (this.KeyMatches(split, "Paintjob")) {
                String[] splat;
                ItemStack[] dyeStacks = new ItemStack[(split.length - 3) / 2];
                for (int i = 0; i < (split.length - 3) / 2; ++i) {
                    dyeStacks[i] = new ItemStack(Items.field_151100_aR, Integer.parseInt(split[i * 2 + 4]), this.getDyeDamageValue(split[i * 2 + 3]));
                }
                if (split[1].contains("_") && (splat = split[1].split("_"))[0].equals(this.iconPath)) {
                    split[1] = splat[1];
                }
                this.paintjobs.add(new Paintjob(this, this.nextPaintjobID++, split[1], split[2], dyeStacks));
            }
        }
        catch (Exception e) {
            FlansMod.log("Reading file failed : " + this.shortName);
            e.printStackTrace();
        }
    }

    public Paintjob getPaintjob(String s) {
        for (Paintjob paintjob : this.paintjobs) {
            if (paintjob.textureName.equals(s)) {
                return paintjob;
            }
            if (!paintjob.iconName.equals(s)) continue;
            FlansMod.Assert(false, "Not sure this should be the right way to find a paintjob");
            return paintjob;
        }
        FlansMod.Assert(false, "Could not find paintjob " + s);
        return this.defaultPaintjob;
    }

    public Paintjob getPaintjob(int i) {
        return this.paintjobs.get(i);
    }

    @Override
    public void addDungeonLoot() {
        if (this.dungeonChance > 0) {
            for (int i = 0; i < this.paintjobs.size(); ++i) {
                ItemStack stack = new ItemStack(this.item);
                NBTTagCompound tags = new NBTTagCompound();
                tags.func_74778_a("Paint", this.paintjobs.get((int)i).iconName);
                stack.func_77982_d(tags);
                this.addToRandomChest(stack, (float)(FlansMod.dungeonLootChance * this.dungeonChance) / (float)totalDungeonChance);
            }
        }
    }

    public float GetRecommendedScale() {
        return 50.0f;
    }

    public static boolean HasCustomPaintjob(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof IPaintableItem) {
            return stack.func_77978_p().func_74764_b("CustomPaint");
        }
        return false;
    }

    public static ResourceLocation GetCustomPaintjobSkinResource(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("CustomPaint");
        int customPaintHash = tags.func_74762_e("Hash");
        if (!FlansModResourceHandler.HasResourceForHash(customPaintHash)) {
            FlansModResourceHandler.CreateSkinResourceFromByteArray(tags.func_74770_j("Skin"), tags.func_74762_e("SkinWidth"), tags.func_74762_e("SkinHeight"), customPaintHash);
            FlansModResourceHandler.CreateIconResourceFromByteArray(tags.func_74770_j("Icon"), tags.func_74762_e("IconWidth"), tags.func_74762_e("IconHeight"), customPaintHash);
        }
        return FlansModResourceHandler.GetSkinResourceFromHash(customPaintHash);
    }

    public static ResourceLocation GetCustomPaintjobIconResource(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("CustomPaint");
        int customPaintHash = tags.func_74762_e("Hash");
        if (!FlansModResourceHandler.HasResourceForHash(customPaintHash)) {
            FlansModResourceHandler.CreateSkinResourceFromByteArray(tags.func_74770_j("Skin"), tags.func_74762_e("SkinWidth"), tags.func_74762_e("SkinHeight"), customPaintHash);
            FlansModResourceHandler.CreateIconResourceFromByteArray(tags.func_74770_j("Icon"), tags.func_74762_e("IconWidth"), tags.func_74762_e("IconHeight"), customPaintHash);
        }
        return FlansModResourceHandler.GetIconResourceFromHash(customPaintHash);
    }
}

