/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.client;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.teams.Team;
import java.io.DataInputStream;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiTeamScores
extends GuiScreen {
    public static final ResourceLocation texture = new ResourceLocation("flansmod", "gui/teamsScores.png");
    public static String map;
    public static String gametype;
    public static int numTeams;
    public static TeamData[] teamData;
    public static boolean sortedByTeam;
    public static int numLines;

    public static PlayerData getPlayerData(String username) {
        if (teamData == null) {
            return null;
        }
        for (TeamData team : teamData) {
            if (team == null || team.playerData == null) {
                return null;
            }
            for (PlayerData player : team.playerData) {
                if (player == null || player.username == null || !player.username.equals(username)) continue;
                return player;
            }
        }
        return null;
    }

    public static void interpret(DataInputStream stream) {
        try {
            gametype = stream.readUTF();
            if (gametype.equals("No Gametype")) {
                numTeams = 0;
                teamData = new TeamData[0];
            } else {
                map = stream.readUTF();
                sortedByTeam = stream.readBoolean();
                if (sortedByTeam) {
                    numLines = numTeams = stream.readInt();
                    if (numTeams == 0) {
                        return;
                    }
                    teamData = new TeamData[numTeams];
                    for (int i = 0; i < numTeams; ++i) {
                        GuiTeamScores.teamData[i] = new TeamData();
                        String teamName = stream.readUTF();
                        if (teamName.equals("none")) continue;
                        GuiTeamScores.teamData[i].team = Team.getTeam(teamName);
                        GuiTeamScores.teamData[i].score = stream.readInt();
                        GuiTeamScores.teamData[i].numPlayers = stream.readInt();
                        GuiTeamScores.teamData[i].playerData = new PlayerData[GuiTeamScores.teamData[i].numPlayers];
                        numLines += GuiTeamScores.teamData[i].numPlayers;
                        for (int j = 0; j < GuiTeamScores.teamData[i].numPlayers; ++j) {
                            GuiTeamScores.teamData[i].playerData[j] = new PlayerData();
                            GuiTeamScores.teamData[i].playerData[j].team = teamData[i];
                            GuiTeamScores.teamData[i].playerData[j].username = stream.readUTF();
                            GuiTeamScores.teamData[i].playerData[j].score = stream.readInt();
                            GuiTeamScores.teamData[i].playerData[j].kills = stream.readInt();
                            GuiTeamScores.teamData[i].playerData[j].deaths = stream.readInt();
                        }
                    }
                } else {
                    numLines = 0;
                    teamData = new TeamData[]{new TeamData()};
                    GuiTeamScores.teamData[0].team = null;
                    GuiTeamScores.teamData[0].score = 0;
                    GuiTeamScores.teamData[0].numPlayers = stream.readInt();
                    GuiTeamScores.teamData[0].playerData = new PlayerData[GuiTeamScores.teamData[0].numPlayers];
                    numLines += GuiTeamScores.teamData[0].numPlayers;
                    for (int j = 0; j < GuiTeamScores.teamData[0].numPlayers; ++j) {
                        GuiTeamScores.teamData[0].playerData[j] = new PlayerData();
                        GuiTeamScores.teamData[0].playerData[j].team = teamData[0];
                        GuiTeamScores.teamData[0].playerData[j].username = stream.readUTF();
                        GuiTeamScores.teamData[0].playerData[j].score = stream.readInt();
                        GuiTeamScores.teamData[0].playerData[j].kills = stream.readInt();
                        GuiTeamScores.teamData[0].playerData[j].deaths = stream.readInt();
                    }
                }
            }
            FlansMod.canBreakGlass = stream.readBoolean();
            FlansMod.vehiclesNeedFuel = stream.readBoolean();
            FlansMod.driveablesBreakBlocks = stream.readBoolean();
        }
        catch (Exception e) {
            FlansMod.log("Error reading team info packet");
            e.printStackTrace();
        }
    }

    public void func_73863_a(int i, int j, float f) {
        if (gametype == null || gametype.equals("") || teamData == null || teamData.length < 1) {
            this.field_73882_e.func_71373_a(null);
            return;
        }
        long newTime = this.field_73882_e.field_71441_e.func_72912_H().func_76073_f();
        ScaledResolution scaledresolution = new ScaledResolution(this.field_73882_e.field_71474_y, this.field_73882_e.field_71443_c, this.field_73882_e.field_71440_d);
        int k = scaledresolution.func_78326_a();
        int l = scaledresolution.func_78328_b();
        FontRenderer fontrenderer = this.field_73882_e.field_71466_p;
        this.func_73873_v_();
        GL11.glEnable((int)3042);
        this.field_73882_e.field_71446_o.func_110577_a(texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiHeight = 34 + 9 * numLines;
        int m = k / 2 - 128;
        int n = l / 2 - guiHeight / 2;
        this.func_73729_b(m, n, 0, 45, 256, 24);
        for (int p = 0; p < numLines; ++p) {
            this.func_73729_b(m, n + 24 + 9 * p, 0, 71, 256, 9);
        }
        this.func_73729_b(m, l / 2 + guiHeight / 2 - 10, 0, 87, 256, 10);
        this.func_73732_a(this.field_73886_k, gametype, k / 2, n + 4, 0xFFFFFF);
        this.func_73731_b(this.field_73886_k, "Name", m + 8, n + 14, 0xFFFFFF);
        this.func_73731_b(this.field_73886_k, "Score", m + 100, n + 14, 0xFFFFFF);
        this.func_73731_b(this.field_73886_k, "Kills", m + 150, n + 14, 0xFFFFFF);
        this.func_73731_b(this.field_73886_k, "Deaths", m + 200, n + 14, 0xFFFFFF);
        int line = 0;
        if (sortedByTeam) {
            for (int p = 0; p < numTeams; ++p) {
                if (teamData[p] == null || GuiTeamScores.teamData[p].team == null) continue;
                this.func_73731_b(this.field_73886_k, "\u00a7" + GuiTeamScores.teamData[p].team.textColour + GuiTeamScores.teamData[p].team.name, m + 8, n + 25 + 9 * line, 0xFFFFFF);
                this.func_73731_b(this.field_73886_k, "" + GuiTeamScores.teamData[p].score, m + 100, n + 25 + 9 * line, 0xFFFFFF);
                ++line;
                for (int q = 0; q < GuiTeamScores.teamData[p].numPlayers; ++q) {
                    this.func_73731_b(this.field_73886_k, GuiTeamScores.teamData[p].playerData[q].username, m + 8, n + 25 + 9 * line, 0xFFFFFF);
                    this.func_73731_b(this.field_73886_k, "" + GuiTeamScores.teamData[p].playerData[q].score, m + 100, n + 25 + 9 * line, 0xFFFFFF);
                    this.func_73731_b(this.field_73886_k, "" + GuiTeamScores.teamData[p].playerData[q].kills, m + 150, n + 25 + 9 * line, 0xFFFFFF);
                    this.func_73731_b(this.field_73886_k, "" + GuiTeamScores.teamData[p].playerData[q].deaths, m + 200, n + 25 + 9 * line, 0xFFFFFF);
                    ++line;
                }
            }
        } else {
            for (int q = 0; q < GuiTeamScores.teamData[0].numPlayers; ++q) {
                this.func_73731_b(this.field_73886_k, GuiTeamScores.teamData[0].playerData[q].username, m + 8, n + 25 + 9 * line, 0xFFFFFF);
                this.func_73731_b(this.field_73886_k, "" + GuiTeamScores.teamData[0].playerData[q].score, m + 100, n + 25 + 9 * line, 0xFFFFFF);
                this.func_73731_b(this.field_73886_k, "" + GuiTeamScores.teamData[0].playerData[q].kills, m + 150, n + 25 + 9 * line, 0xFFFFFF);
                this.func_73731_b(this.field_73886_k, "" + GuiTeamScores.teamData[0].playerData[q].deaths, m + 200, n + 25 + 9 * line, 0xFFFFFF);
                ++line;
            }
        }
        GL11.glDisable((int)3042);
    }

    public boolean func_73868_f() {
        return false;
    }

    public static class PlayerData {
        public String username;
        public int score;
        public int kills;
        public int deaths;
        public TeamData team;
    }

    public static class TeamData {
        public Team team;
        public int score;
        public int numPlayers;
        public PlayerData[] playerData;
    }
}

