/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common;

import co.uk.flansmods.common.CommonTickHandler;
import co.uk.flansmods.common.ContainerPlaneInventory;
import co.uk.flansmods.common.ContainerPlaneMenu;
import co.uk.flansmods.common.EnumType;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.GunBoxType;
import co.uk.flansmods.common.ItemPart;
import co.uk.flansmods.common.PartType;
import co.uk.flansmods.common.driveables.DriveablePart;
import co.uk.flansmods.common.driveables.DriveableType;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.driveables.EnumDriveablePart;
import co.uk.flansmods.common.driveables.mechas.ContainerMechaInventory;
import co.uk.flansmods.common.driveables.mechas.EntityMecha;
import co.uk.flansmods.common.guns.ContainerGunModTable;
import co.uk.flansmods.common.network.PacketBreakSound;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;

public class CommonProxy {
    protected static Pattern zipJar = Pattern.compile("(.+).(zip|jar)$");

    public List<File> getContentList(Method method, ClassLoader classloader) {
        ArrayList<File> contentPacks = new ArrayList<File>();
        for (File file : FlansMod.flanDir.listFiles()) {
            if (!file.isDirectory() && !zipJar.matcher(file.getName()).matches()) continue;
            FlansMod.log("Loaded content pack : " + file.getName());
            contentPacks.add(file);
        }
        FlansMod.log("Loaded content pack list server side.");
        return contentPacks;
    }

    public void load() {
    }

    public List<File> getContentList() {
        return null;
    }

    public void registerTileEntityRenderers() {
    }

    public void loadDefaultGraphics() {
    }

    public void loadKeyBindings() {
    }

    public void doTutorialStuff(EntityPlayer player, EntityDriveable entityType) {
    }

    public void changeControlMode(EntityPlayer player) {
    }

    public boolean mouseControlEnabled() {
        return false;
    }

    public void openDriveableMenu(EntityPlayer player, World world, EntityDriveable driveable) {
    }

    public <T> T loadModel(String s, String shortName, Class<T> typeClass) {
        return null;
    }

    public void loadSound(String contentPack, String type, String sound) {
    }

    public boolean isThePlayer(EntityPlayer player) {
        return false;
    }

    public void buyGun(GunBoxType type, int gun) {
    }

    public void buyAmmo(GunBoxType box, int ammo, int type) {
    }

    public Object getClientGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Container getServerGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (ID) {
            case 2: {
                return new ContainerGunModTable(player.field_71071_by, world);
            }
            case 3: {
                return new ContainerPlaneMenu(player.field_71071_by, world);
            }
            case 4: {
                return new ContainerPlaneMenu(player.field_71071_by, world, true, ((EntitySeat)player.field_70154_o).driveable);
            }
            case 6: {
                return new ContainerPlaneInventory(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable, 0);
            }
            case 7: {
                return new ContainerPlaneInventory(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable, 1);
            }
            case 8: {
                return new ContainerPlaneMenu(player.field_71071_by, world, true, ((EntitySeat)player.field_70154_o).driveable);
            }
            case 9: {
                return new ContainerPlaneInventory(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable, 2);
            }
            case 10: {
                return new ContainerMechaInventory(player.field_71071_by, world, (EntityMecha)((EntitySeat)player.field_70154_o).driveable);
            }
        }
        return null;
    }

    public void playBlockBreakSound(int x, int y, int z, int blockID) {
        PacketDispatcher.sendPacketToAllPlayers((Packet)PacketBreakSound.buildBreakSoundPacket(x, y, z, blockID));
    }

    public void doTickStuff() {
        TickRegistry.registerTickHandler((ITickHandler)new CommonTickHandler(), (Side)Side.SERVER);
    }

    public void craftDriveable(EntityPlayer player, DriveableType type) {
        InventoryPlayer temporaryInventory = new InventoryPlayer(null);
        temporaryInventory.func_70455_b(player.field_71071_by);
        boolean canCraft = true;
        for (ItemStack recipeStack : type.recipe) {
            int totalAmountFound = 0;
            for (int n = 0; n < player.field_71071_by.func_70302_i_(); ++n) {
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(n);
                if (stackInSlot == null || stackInSlot.field_77993_c != recipeStack.field_77993_c || stackInSlot.func_77960_j() != recipeStack.func_77960_j()) continue;
                int amountFound = Math.min(stackInSlot.field_77994_a, recipeStack.field_77994_a - totalAmountFound);
                stackInSlot.field_77994_a -= amountFound;
                if (stackInSlot.field_77994_a <= 0) {
                    stackInSlot = null;
                }
                player.field_71071_by.func_70299_a(n, stackInSlot);
                if ((totalAmountFound += amountFound) == recipeStack.field_77994_a) break;
            }
            if (totalAmountFound >= recipeStack.field_77994_a) continue;
            canCraft = false;
            break;
        }
        if (!canCraft) {
            player.field_71071_by.func_70455_b(temporaryInventory);
            return;
        }
        HashMap<PartType, ItemStack> engines = new HashMap<PartType, ItemStack>();
        for (int n = 0; n < temporaryInventory.func_70302_i_(); ++n) {
            ItemStack stackInSlot = temporaryInventory.func_70301_a(n);
            if (stackInSlot == null || !(stackInSlot.func_77973_b() instanceof ItemPart)) continue;
            PartType partType = ((ItemPart)stackInSlot.func_77973_b()).type;
            if (partType.category != 2 || !partType.worksWith.contains((Object)EnumType.getFromObject(type))) continue;
            if (engines.containsKey(partType)) {
                ((ItemStack)engines.get((Object)partType)).field_77994_a += stackInSlot.field_77994_a;
                continue;
            }
            engines.put(partType, stackInSlot);
        }
        float bestEngineSpeed = -1.0f;
        ItemStack bestEngineStack = null;
        for (PartType part : engines.keySet()) {
            if (!(part.engineSpeed > bestEngineSpeed) || ((ItemStack)engines.get((Object)part)).field_77994_a < type.numEngines()) continue;
            bestEngineSpeed = part.engineSpeed;
            bestEngineStack = (ItemStack)engines.get(part);
        }
        if (bestEngineStack == null) {
            player.field_71071_by.func_70455_b(temporaryInventory);
            return;
        }
        int numEnginesAcquired = 0;
        for (int n = 0; n < player.field_71071_by.func_70302_i_(); ++n) {
            ItemStack stackInSlot = player.field_71071_by.func_70301_a(n);
            if (stackInSlot == null || stackInSlot.field_77993_c != bestEngineStack.field_77993_c) continue;
            int amountFound = Math.min(stackInSlot.field_77994_a, type.numEngines() - numEnginesAcquired);
            stackInSlot.field_77994_a -= amountFound;
            if (stackInSlot.field_77994_a <= 0) {
                stackInSlot = null;
            }
            player.field_71071_by.func_70299_a(n, stackInSlot);
            if ((numEnginesAcquired += amountFound) == type.numEngines()) break;
        }
        ItemStack driveableStack = new ItemStack(type.item);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("Engine", ((ItemPart)bestEngineStack.func_77973_b()).type.shortName);
        tags.func_74778_a("Type", type.shortName);
        for (EnumDriveablePart part : EnumDriveablePart.values()) {
            tags.func_74768_a(part.getShortName() + "_Health", type.health.get((Object)part) == null ? 0 : type.health.get((Object)((Object)part)).health);
            tags.func_74757_a(part.getShortName() + "_Fire", false);
        }
        driveableStack.field_77990_d = tags;
        if (!player.field_71071_by.func_70441_a(driveableStack)) {
            player.func_71021_b(driveableStack);
        }
    }

    public void repairDriveable(EntityPlayer driver, EntityDriveable driving, DriveablePart part) {
        for (EnumDriveablePart parent : part.type.getParents()) {
            if (driving.isPartIntact(parent)) continue;
            return;
        }
        InventoryPlayer temporaryInventory = new InventoryPlayer(null);
        temporaryInventory.func_70455_b(driver.field_71071_by);
        boolean canRepair = true;
        ArrayList<ItemStack> stacksNeeded = driving.getDriveableType().getItemsRequired(part, driving.getDriveableData().engine);
        for (ItemStack stackNeeded : stacksNeeded) {
            int totalAmountFound = 0;
            for (int m = 0; m < temporaryInventory.func_70302_i_(); ++m) {
                ItemStack stackInSlot = temporaryInventory.func_70301_a(m);
                if (stackInSlot == null || stackInSlot.field_77993_c != stackNeeded.field_77993_c || stackInSlot.func_77960_j() != stackNeeded.func_77960_j()) continue;
                int amountFound = Math.min(stackInSlot.field_77994_a, stackNeeded.field_77994_a - totalAmountFound);
                stackInSlot.field_77994_a -= amountFound;
                if (stackInSlot.field_77994_a <= 0) {
                    stackInSlot = null;
                }
                temporaryInventory.func_70299_a(m, stackInSlot);
                if ((totalAmountFound += amountFound) == stackNeeded.field_77994_a) break;
            }
            if (totalAmountFound >= stackNeeded.field_77994_a) continue;
            canRepair = false;
        }
        if (canRepair) {
            driver.field_71071_by.func_70455_b(temporaryInventory);
            part.health = Math.max(1, part.maxHealth / 10);
            part.onFire = false;
            part.dead = false;
            driving.checkParts();
        }
    }

    public boolean isScreenOpen() {
        return false;
    }

    public boolean isKeyDown(int key) {
        return false;
    }

    public boolean keyDown(int keycode) {
        return false;
    }
}

