/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.driveables;

import co.uk.flansmods.api.IControllable;
import co.uk.flansmods.api.IExplodeable;
import co.uk.flansmods.client.FlansModClient;
import co.uk.flansmods.client.debug.EntityDebugVector;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.RotatedAxes;
import co.uk.flansmods.common.driveables.CollisionPoint;
import co.uk.flansmods.common.driveables.DriveableData;
import co.uk.flansmods.common.driveables.DriveablePart;
import co.uk.flansmods.common.driveables.DriveableType;
import co.uk.flansmods.common.driveables.EntitySeat;
import co.uk.flansmods.common.driveables.EnumDriveablePart;
import co.uk.flansmods.common.driveables.Seat;
import co.uk.flansmods.common.guns.EntityBullet;
import co.uk.flansmods.common.network.PacketDriveableDamage;
import co.uk.flansmods.common.network.PacketDriveableKeyHeld;
import co.uk.flansmods.common.vector.Vector3f;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.api.RadarRegistry;
import icbm.api.sentry.IAATarget;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.StepSound;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class EntityDriveable
extends Entity
implements IControllable,
IExplodeable,
IEntityAdditionalSpawnData,
IAATarget {
    public boolean syncFromServer = true;
    public int serverPositionTransitionTicker;
    public double field_70118_ct;
    public double field_70117_cu;
    public double field_70116_cv;
    public double serverYaw;
    public double serverPitch;
    public double serverRoll;
    public DriveableData driveableData;
    public String driveableType;
    public float throttle;
    public boolean fuelling;
    public float prevRotationRoll;
    public Vector3f angularVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean leftMouseHeld = false;
    public boolean rightMouseHeld = false;
    public RotatedAxes prevAxes;
    public RotatedAxes axes = new RotatedAxes();
    public EntitySeat[] seats;

    public EntityDriveable(World world) {
        super(world);
        this.prevAxes = new RotatedAxes();
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 1.0f);
        this.field_70129_M = 0.375f;
        this.field_70158_ak = true;
        this.field_70155_l = 200.0;
    }

    public EntityDriveable(World world, DriveableType t, DriveableData d) {
        this(world);
        this.driveableType = t.shortName;
        this.driveableData = d;
    }

    protected void initType(DriveableType type, boolean clientSide) {
        this.seats = new EntitySeat[type.numPassengers + 1];
        for (int i = 0; i < type.numPassengers + 1; ++i) {
            if (clientSide) continue;
            this.seats[i] = new EntitySeat(this.field_70170_p, this, i);
            this.field_70170_p.func_72838_d((Entity)this.seats[i]);
        }
        this.field_70129_M = type.yOffset;
        if (type.onRadar) {
            RadarRegistry.register(this);
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        this.driveableData.writeToNBT(tag);
        tag.func_74778_a("Type", this.driveableType);
        tag.func_74776_a("RotationYaw", this.axes.getYaw());
        tag.func_74776_a("RotationPitch", this.axes.getPitch());
        tag.func_74776_a("RotationRoll", this.axes.getRoll());
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.driveableType = tag.func_74779_i("Type");
        this.driveableData = new DriveableData(tag);
        this.initType(DriveableType.getDriveable(this.driveableType), false);
        this.field_70126_B = tag.func_74760_g("RotationYaw");
        this.field_70127_C = tag.func_74760_g("RotationPitch");
        this.prevRotationRoll = tag.func_74760_g("RotationRoll");
        this.axes = new RotatedAxes(this.field_70126_B, this.field_70127_C, this.prevRotationRoll);
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        try {
            data.writeUTF(this.driveableType);
            NBTTagCompound tag = new NBTTagCompound();
            this.driveableData.writeToNBT(tag);
            NBTBase.func_74731_a((NBTBase)tag, (DataOutput)data);
            data.writeFloat(this.axes.getYaw());
            data.writeFloat(this.axes.getPitch());
            data.writeFloat(this.axes.getRoll());
            for (EnumDriveablePart ep : EnumDriveablePart.values()) {
                DriveablePart part = this.getDriveableData().parts.get((Object)ep);
                data.writeShort((int)((short)part.health));
                data.writeBoolean(part.onFire);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteArrayDataInput inputData) {
        try {
            this.driveableType = inputData.readUTF();
            this.driveableData = new DriveableData((NBTTagCompound)NBTBase.func_74739_b((DataInput)inputData));
            this.initType(this.getDriveableType(), true);
            this.axes.setAngles(inputData.readFloat(), inputData.readFloat(), inputData.readFloat());
            this.field_70126_B = this.axes.getYaw();
            this.field_70127_C = this.axes.getPitch();
            this.prevRotationRoll = this.axes.getRoll();
            for (EnumDriveablePart ep : EnumDriveablePart.values()) {
                DriveablePart part = this.getDriveableData().parts.get((Object)ep);
                part.health = inputData.readShort();
                part.onFire = inputData.readBoolean();
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to retreive plane type from server.");
            super.func_70106_y();
            e.printStackTrace();
        }
    }

    public abstract void writeUpdateData(DataOutputStream var1);

    public abstract void readUpdateData(DataInputStream var1);

    @Override
    public abstract void onMouseMoved(int var1, int var2);

    protected boolean canSit(int seat) {
        return this.getDriveableType().numPassengers >= seat && this.seats[seat].field_70153_n == null;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return -0.3;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        return true;
    }

    public void func_70106_y() {
        super.func_70106_y();
        RadarRegistry.unregister(this);
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.func_70106_y();
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70108_f(Entity entity) {
        if (!this.isPartOfThis(entity)) {
            super.func_70108_f(entity);
        }
    }

    public void func_70056_a(double d, double d1, double d2, float f, float f1, int i) {
        if (this.field_70173_aa > 1) {
            return;
        }
        if (!(this.field_70153_n instanceof EntityPlayer) || !FlansMod.proxy.isThePlayer((EntityPlayer)this.field_70153_n)) {
            if (this.syncFromServer) {
                this.serverPositionTransitionTicker = i + 5;
            } else {
                double var10 = d - this.field_70165_t;
                double var12 = d1 - this.field_70163_u;
                double var14 = d2 - this.field_70161_v;
                double var16 = var10 * var10 + var12 * var12 + var14 * var14;
                if (var16 <= 1.0) {
                    return;
                }
                this.serverPositionTransitionTicker = 3;
            }
            this.field_70118_ct = d;
            this.field_70117_cu = d1;
            this.field_70116_cv = d2;
            this.serverYaw = f;
            this.serverPitch = f1;
        }
    }

    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, float roll, double motX, double motY, double motZ, float velYaw, float velPitch, float velRoll, float throt) {
        if (this.field_70170_p.field_72995_K) {
            this.field_70118_ct = x;
            this.field_70117_cu = y;
            this.field_70116_cv = z;
            this.serverYaw = yaw;
            this.serverPitch = pitch;
            this.serverRoll = roll;
            this.serverPositionTransitionTicker = 5;
        } else {
            this.func_70107_b(x, y, z);
            this.field_70126_B = yaw;
            this.field_70127_C = pitch;
            this.prevRotationRoll = roll;
            this.setRotation(yaw, pitch, roll);
        }
        this.field_70159_w = motX;
        this.field_70181_x = motY;
        this.field_70179_y = motZ;
        this.angularVelocity = new Vector3f(velYaw, velPitch, velRoll);
        this.throttle = throt;
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
    }

    @Override
    public abstract boolean pressKey(int var1, EntityPlayer var2);

    @Override
    public void updateKeyHeldState(int key, boolean held) {
        if (this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendPacketToServer((Packet)PacketDriveableKeyHeld.buildKeyPacket(key, held));
        }
        switch (key) {
            case 9: {
                this.leftMouseHeld = held;
                break;
            }
            case 8: {
                this.rightMouseHeld = held;
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        DriveableType type = this.getDriveableType();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.getDriveableType().numPassengers + 1; ++i) {
                if (this.seats[i] != null && this.seats[i].field_70175_ag) continue;
                this.seats[i] = new EntitySeat(this.field_70170_p, this, i);
                this.field_70170_p.func_72838_d((Entity)this.seats[i]);
            }
        }
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            Vector3f pos;
            if (part.box == null) continue;
            part.update(this);
            if (this.field_70170_p.field_72995_K) {
                if (part.onFire) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.w / 16.0f, (float)part.box.y / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.h / 16.0f, (float)part.box.z / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.d / 16.0f));
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, 0.0, 0.0, 0.0);
                }
                if (part.health > 0 && part.health < part.maxHealth / 2) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.w / 16.0f, (float)part.box.y / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.h / 16.0f, (float)part.box.z / 16.0f + this.field_70146_Z.nextFloat() * (float)part.box.d / 16.0f));
                    this.field_70170_p.func_72869_a(part.health < part.maxHealth / 4 ? "largesmoke" : "smoke", this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, 0.0, 0.0, 0.0);
                }
            }
            if (part.onFire) {
                if (this.field_70170_p.func_72896_J() && this.field_70146_Z.nextInt(40) == 0) {
                    part.onFire = false;
                }
                pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + (float)part.box.w / 32.0f, (float)part.box.y / 16.0f + (float)part.box.h / 32.0f, (float)part.box.z / 16.0f + (float)part.box.d / 32.0f));
                if (this.field_70170_p.func_72803_f(MathHelper.func_76128_c((double)(this.field_70165_t + (double)pos.x)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)pos.y)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)pos.z))) != Material.field_76244_g) continue;
                part.onFire = false;
                continue;
            }
            pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + (float)part.box.w / 32.0f, (float)part.box.y / 16.0f + (float)part.box.h / 32.0f, (float)part.box.z / 16.0f + (float)part.box.d / 32.0f));
            if (this.field_70170_p.func_72803_f(MathHelper.func_76128_c((double)(this.field_70165_t + (double)pos.x)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)pos.y)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)pos.z))) != Material.field_76256_h) continue;
            part.onFire = true;
        }
        this.checkParts();
        this.field_70126_B = this.axes.getYaw();
        this.field_70127_C = this.axes.getPitch();
        this.prevRotationRoll = this.axes.getRoll();
        this.prevAxes = this.axes.clone();
        if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            this.field_70153_n = null;
        }
        if (this.field_70153_n != null && this.field_70128_L) {
            this.field_70153_n.func_70078_a(null);
        }
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70143_R = 0.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.seats[0].field_70153_n == null) {
            this.throttle *= 0.9f;
        }
    }

    protected void func_70069_a(float k) {
        if (k <= 0.0f) {
            return;
        }
        super.func_70069_a(k);
        int i = MathHelper.func_76123_f((float)(k - 3.0f));
        if (i > 0) {
            if (i > 4) {
                this.func_85030_a("damage.fallbig", 1.0f, 1.0f);
            } else {
                this.func_85030_a("damage.fallsmall", 1.0f, 1.0f);
            }
            this.func_70097_a(DamageSource.field_76379_h, i);
            int j = this.field_70170_p.func_72798_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), MathHelper.func_76128_c((double)this.field_70161_v));
            if (j > 0) {
                StepSound stepsound = Block.field_71973_m[j].field_72020_cn;
                this.func_85030_a(stepsound.func_72675_d(), stepsound.func_72677_b() * 0.5f, stepsound.func_72678_c() * 0.75f);
            }
        }
    }

    public Vector3f rotate(Vector3f inVec) {
        return this.axes.findLocalVectorGlobally(inVec);
    }

    public Vector3f rotate(Vec3 inVec) {
        return this.rotate(inVec.field_72450_a, inVec.field_72448_b, inVec.field_72449_c);
    }

    public Vector3f rotate(double x, double y, double z) {
        return this.rotate(new Vector3f((float)x, (float)y, (float)z));
    }

    public void rotateYaw(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalYaw(rotateBy);
        this.updatePrevAngles();
    }

    public void rotatePitch(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalPitch(rotateBy);
        this.updatePrevAngles();
    }

    public void rotateRoll(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalRoll(rotateBy);
        this.updatePrevAngles();
    }

    public void updatePrevAngles() {
        double dRoll;
        double dPitch;
        double dYaw = this.axes.getYaw() - this.field_70126_B;
        if (dYaw > 180.0) {
            this.field_70126_B += 360.0f;
        }
        if (dYaw < -180.0) {
            this.field_70126_B -= 360.0f;
        }
        if ((dPitch = (double)(this.axes.getPitch() - this.field_70127_C)) > 180.0) {
            this.field_70127_C += 360.0f;
        }
        if (dPitch < -180.0) {
            this.field_70127_C -= 360.0f;
        }
        if ((dRoll = (double)(this.axes.getRoll() - this.prevRotationRoll)) > 180.0) {
            this.prevRotationRoll += 360.0f;
        }
        if (dRoll < -180.0) {
            this.prevRotationRoll -= 360.0f;
        }
    }

    public void setRotation(float rotYaw, float rotPitch, float rotRoll) {
        this.axes.setAngles(rotYaw, rotPitch, rotRoll);
    }

    public boolean isPartOfThis(Entity ent) {
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            if (ent == seat) {
                return true;
            }
            if (seat.field_70153_n != ent) continue;
            return true;
        }
        return ent == this;
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public DriveableType getDriveableType() {
        return DriveableType.getDriveable(this.driveableType);
    }

    public DriveableData getDriveableData() {
        return this.driveableData;
    }

    @Override
    public boolean isDead() {
        return this.field_70128_L;
    }

    @Override
    public Entity getControllingEntity() {
        return this.seats[0].getControllingEntity();
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        ItemStack stack = new ItemStack(this.getDriveableType().itemID, 1, 0);
        stack.field_77990_d = new NBTTagCompound();
        this.driveableData.writeToNBT(stack.field_77990_d);
        return stack;
    }

    public boolean hasFuel() {
        if (this.seats == null || this.seats[0] == null || this.seats[0].field_70153_n == null) {
            return false;
        }
        if (this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.driveableData.fuelInTank > 0.0f;
    }

    public boolean hasEnoughFuel() {
        if (this.seats == null || this.seats[0] == null || this.seats[0].field_70153_n == null) {
            return false;
        }
        if (this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.driveableData.fuelInTank > this.driveableData.engine.fuelConsumption * this.throttle;
    }

    public double getSpeedXYZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
    }

    public double getSpeedXZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
    }

    public double getKineticEnergy() {
        return 0.5 * (double)this.getDriveableType().mass * this.getSpeedXYZ();
    }

    public void applyForce(Vector3f forceOrigin, Vector3f forceVector) {
        this.applyTranslationalForce(forceOrigin, forceVector);
        this.applyRotationalForce(forceOrigin, forceVector);
    }

    public void applyRotationalForce(Vector3f forceOrigin, Vector3f forceVector) {
        Vector3f torqueVector = Vector3f.cross((Vector3f)forceVector.scale(1.0f), forceOrigin, null);
        this.applyTorque(torqueVector);
    }

    public void applyTorque(Vector3f torqueVector) {
        float deltaTime = 0.05f;
        float momentOfInertia = this.getDriveableType().momentOfInertia / (float)(this.landVehicle() ? 250 : 100);
        Vector3f.add(this.angularVelocity, (Vector3f)torqueVector.scale(deltaTime * 1.0f / momentOfInertia), this.angularVelocity);
    }

    public void applyTranslationalForce(Vector3f forceOrigin, Vector3f forceVector) {
        float deltaTime = 0.05f;
        Vector3f accelerationVector = (Vector3f)forceVector.scale(1.0f / this.getDriveableType().mass);
        this.field_70159_w += (double)(accelerationVector.x * deltaTime);
        this.field_70181_x += (double)(accelerationVector.y * deltaTime);
        this.field_70179_y += (double)(accelerationVector.z * deltaTime);
    }

    public void moveDriveable() {
        ArrayList aabbs;
        Block block;
        Vector3f newOrigin;
        Vector3f origin;
        Vector3f newPointVec;
        Vector3f pointVec;
        float deltaTime = 0.05f;
        DriveableType type = this.getDriveableType();
        Vector3f position = new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v);
        Vector3f motion = new Vector3f((float)this.field_70159_w, (float)this.field_70181_x, (float)this.field_70179_y);
        if (this.field_70170_p.field_72995_K && FlansMod.DEBUG) {
            this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, position, motion, 2, 0.0f, 0.0f, 1.0f));
            this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, position, (Vector3f)new Vector3f(this.angularVelocity).scale(0.1f), 2, 1.0f, 0.0f, 1.0f));
        }
        RotatedAxes newAxes = this.axes.clone();
        if ((double)Math.abs(this.angularVelocity.lengthSquared()) > 1.0E-8) {
            newAxes.rotateLocal(this.angularVelocity.length() * deltaTime, (Vector3f)new Vector3f(this.angularVelocity).normalise());
        }
        int numHits = 0;
        for (CollisionPoint point : type.points) {
            MovingObjectPosition hit;
            if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
            pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
            newPointVec = newAxes.findLocalVectorGlobally(point.getLocalVector());
            origin = Vector3f.add(position, pointVec, null);
            newOrigin = Vector3f.add(position, newPointVec, null);
            Vector3f rayOrigin = Vector3f.sub(newOrigin, motion, null);
            Vector3f ray = Vector3f.add(newOrigin, motion, null);
            if (this.field_70170_p.field_72995_K && FlansMod.DEBUG) {
                this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, origin, (Vector3f)Vector3f.sub(ray, origin, null).scale(1.0f), 2, 1.0f, 0.0f, 0.0f));
            }
            if ((hit = this.field_70170_p.func_72933_a(rayOrigin.toVec3(), ray.toVec3())) == null) continue;
            ++numHits;
        }
        if (numHits > 0) {
            for (CollisionPoint point : type.points) {
                if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
                pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
                newPointVec = newAxes.findLocalVectorGlobally(point.getLocalVector());
                origin = Vector3f.add(position, pointVec, null);
                newOrigin = Vector3f.add(position, newPointVec, null);
                Vector3f ray = Vector3f.add(newOrigin, motion, null);
                MovingObjectPosition hit = this.field_70170_p.func_72933_a(newOrigin.toVec3(), ray.toVec3());
                if (hit == null || hit.field_72313_a != EnumMovingObjectType.TILE) continue;
                Vector3f hitVec = new Vector3f(hit.field_72307_f);
                Vector3f normal = null;
                int x = 0;
                int y = 0;
                int z = 0;
                switch (hit.field_72310_e) {
                    case 0: {
                        normal = new Vector3f(0.0f, -1.0f, 0.0f);
                        y = -1;
                        break;
                    }
                    case 1: {
                        normal = new Vector3f(0.0f, 1.0f, 0.0f);
                        y = 1;
                        break;
                    }
                    case 2: {
                        normal = new Vector3f(0.0f, 0.0f, -1.0f);
                        z = 1;
                        break;
                    }
                    case 3: {
                        normal = new Vector3f(0.0f, 0.0f, 1.0f);
                        z = -1;
                        break;
                    }
                    case 4: {
                        normal = new Vector3f(-1.0f, 0.0f, 0.0f);
                        x = 1;
                        break;
                    }
                    case 5: {
                        normal = new Vector3f(1.0f, 0.0f, 0.0f);
                        x = -1;
                    }
                }
                if (this.field_70170_p.isBlockSolidOnSide(hit.field_72311_b + x, hit.field_72312_c + y, hit.field_72309_d + z, ForgeDirection.getOrientation((int)hit.field_72310_e).getOpposite())) continue;
                if (this.field_70170_p.field_72995_K && FlansMod.DEBUG) {
                    this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, hitVec, normal, 2, 0.0f, 1.0f, 0.0f));
                }
                float normalReactionMagnitude = Vector3f.dot(normal.negate(null), Vector3f.sub(ray, hitVec, null));
                float forceMagnitude = type.mass * normalReactionMagnitude / ((float)numHits * deltaTime);
                boolean shouldApplyForce = true;
                float damagePoint = 1.0f;
                float damageModifier = 5.0f;
                float blockDamageModifier = 50.0f;
                if (forceMagnitude > damagePoint * type.mass) {
                    float smashyForce = forceMagnitude - damagePoint * type.mass;
                    DriveablePart part = this.getDriveableData().parts.get((Object)point.part);
                    float smashyForceVsBlock = blockDamageModifier * part.smashIntoGround(this, damageModifier * smashyForce);
                    int blockIDHit = this.field_70170_p.func_72798_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                    Block blockHit = Block.field_71973_m[blockIDHit];
                    float blockHardness = blockHit.func_71934_m(this.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                    if (FlansMod.driveablesBreakBlocks && smashyForceVsBlock > blockHardness && blockHardness >= 0.0f) {
                        blockHit.func_71897_c(this.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, this.field_70170_p.func_72805_g(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d), 1);
                        FlansMod.proxy.playBlockBreakSound(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, blockIDHit);
                        this.field_70170_p.func_94571_i(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                        shouldApplyForce = false;
                    }
                }
                if (!shouldApplyForce) continue;
                this.applyForce(pointVec, (Vector3f)normal.scale(forceMagnitude));
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        if ((double)Math.abs(this.angularVelocity.lengthSquared()) > 1.0E-8) {
            this.axes.rotateGlobal(this.angularVelocity.length() * deltaTime, (Vector3f)new Vector3f(this.angularVelocity).normalise());
        }
        numHits = 0;
        for (CollisionPoint point : type.points) {
            int blockZ;
            int blockY;
            if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
            pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
            int blockX = MathHelper.func_76128_c((double)(this.field_70165_t + (double)pointVec.x));
            int blockID = this.field_70170_p.func_72798_a(blockX, blockY = MathHelper.func_76128_c((double)(this.field_70163_u + (double)pointVec.y)), blockZ = MathHelper.func_76128_c((double)(this.field_70161_v + (double)pointVec.z)));
            if (blockID <= 0) continue;
            block = Block.field_71973_m[blockID];
            aabbs = new ArrayList();
            block.func_71871_a(this.field_70170_p, blockX, blockY, blockZ, AxisAlignedBB.func_72330_a((double)(this.field_70165_t + (double)pointVec.x), (double)(this.field_70163_u + (double)pointVec.y), (double)(this.field_70161_v + (double)pointVec.z), (double)(this.field_70165_t + (double)pointVec.x), (double)(this.field_70163_u + (double)pointVec.y), (double)(this.field_70161_v + (double)pointVec.z)), aabbs, (Entity)this);
            if (aabbs.size() <= 0) continue;
            ++numHits;
        }
        for (CollisionPoint point : type.points) {
            int blockZ;
            int blockY;
            if (!this.isPartIntact(point.part) || EnumDriveablePart.isWheel(point.part) && !this.gearDown()) continue;
            pointVec = this.axes.findLocalVectorGlobally(point.getLocalVector());
            int blockX = MathHelper.func_76128_c((double)(this.field_70165_t + (double)pointVec.x));
            int blockID = this.field_70170_p.func_72798_a(blockX, blockY = MathHelper.func_76128_c((double)(this.field_70163_u + (double)pointVec.y)), blockZ = MathHelper.func_76128_c((double)(this.field_70161_v + (double)pointVec.z)));
            if (blockID <= 0) continue;
            block = Block.field_71973_m[blockID];
            aabbs = new ArrayList();
            block.func_71871_a(this.field_70170_p, blockX, blockY, blockZ, AxisAlignedBB.func_72330_a((double)(this.field_70165_t + (double)pointVec.x), (double)(this.field_70163_u + (double)pointVec.y), (double)(this.field_70161_v + (double)pointVec.z), (double)(this.field_70165_t + (double)pointVec.x), (double)(this.field_70163_u + (double)pointVec.y), (double)(this.field_70161_v + (double)pointVec.z)), aabbs, (Entity)this);
            if (aabbs.size() <= 0) continue;
            AxisAlignedBB aabb = (AxisAlignedBB)aabbs.get(0);
            double dminX = Math.abs(this.field_70165_t + (double)pointVec.x - aabb.field_72340_a);
            double dmaxX = Math.abs(this.field_70165_t + (double)pointVec.x - aabb.field_72336_d);
            double dminY = Math.abs(this.field_70163_u + (double)pointVec.y - aabb.field_72338_b);
            double dmaxY = Math.abs(this.field_70163_u + (double)pointVec.y - aabb.field_72337_e);
            double dminZ = Math.abs(this.field_70161_v + (double)pointVec.z - aabb.field_72339_c);
            double dmaxZ = Math.abs(this.field_70161_v + (double)pointVec.z - aabb.field_72334_f);
            double min = Math.min(Math.min(Math.min(dminX, dmaxX), Math.min(dminY, dmaxY)), Math.min(dminZ, dmaxZ));
            float pushiness = 1.0f;
            float bounciness = type.bounciness;
            this.applyForce(pointVec, new Vector3f(0.0f, (float)dmaxY * type.mass / (deltaTime * (float)numHits) * type.bounciness, 0.0f));
        }
        this.checkParts();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean landVehicle() {
        return false;
    }

    public boolean gearDown() {
        return true;
    }

    public boolean onGround() {
        return this.field_70122_E;
    }

    public boolean attackPoint(CollisionPoint point, DamageSource damagesource, float i) {
        return false;
    }

    public boolean attackFromBullet(EntityBullet bullet, Vector3f origin, Vector3f motion) {
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (!part.rayTrace(this, bullet, rotatedPosVector, rotatedMotVector)) continue;
            if (this.field_70170_p.field_72995_K) {
                return true;
            }
            this.checkParts();
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)100.0, (int)this.field_71093_bK, (Packet)PacketDriveableDamage.buildUpdatePacket(this));
            return true;
        }
        return false;
    }

    public DriveablePart raytraceParts(Vector3f origin, Vector3f motion) {
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (!part.rayTrace(this, null, rotatedPosVector, rotatedMotVector)) continue;
            return part;
        }
        return null;
    }

    public boolean canHitPart(EnumDriveablePart part) {
        return true;
    }

    public void checkParts() {
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (part == null || part.dead || part.health > 0 || part.maxHealth <= 0) continue;
            this.killPart(part);
        }
        for (EntitySeat seat : this.seats) {
        }
        if (this.getDriveableData().parts.get((Object)((Object)EnumDriveablePart.core)).dead) {
            this.func_70106_y();
        }
    }

    private void killPart(DriveablePart part) {
        if (part.dead) {
            return;
        }
        part.health = 0;
        part.dead = true;
        DriveableType type = this.getDriveableType();
        if (!this.field_70170_p.field_72995_K) {
            ArrayList<ItemStack> drops;
            Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
            if (part.box != null) {
                pos = this.axes.findLocalVectorGlobally(new Vector3f((float)part.box.x / 16.0f + (float)part.box.w / 32.0f, (float)part.box.y / 16.0f + (float)part.box.h / 32.0f, (float)part.box.z / 16.0f + (float)part.box.d / 32.0f));
            }
            if ((drops = type.getItemsRequired(part, this.getDriveableData().engine)) != null) {
                for (ItemStack stack : drops) {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, stack.func_77946_l()));
                }
            }
            this.dropItemsOnPartDeath(pos, part);
            if (part.type == EnumDriveablePart.core) {
                for (int i = 0; i < this.getDriveableData().func_70302_i_(); ++i) {
                    ItemStack stack;
                    stack = this.getDriveableData().func_70301_a(i);
                    if (stack == null) continue;
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + this.field_70146_Z.nextGaussian(), this.field_70161_v + this.field_70146_Z.nextGaussian(), stack));
                }
            }
        }
        for (EnumDriveablePart child : part.type.getChildren()) {
            this.killPart(this.getDriveableData().parts.get((Object)child));
        }
    }

    protected abstract void dropItemsOnPartDeath(Vector3f var1, DriveablePart var2);

    @Override
    public float getPlayerRoll() {
        return this.axes.getRoll();
    }

    @Override
    public void explode() {
    }

    @Override
    public float getCameraDistance() {
        return this.getDriveableType().cameraDistance;
    }

    public boolean isPartIntact(EnumDriveablePart part) {
        return this.getDriveableData().parts.get((Object)((Object)part)).maxHealth == 0 || this.getDriveableData().parts.get((Object)((Object)part)).health > 0;
    }

    public abstract boolean hasMouseControlMode();

    public abstract String getBombInventoryName();

    public boolean rotateWithTurret(Seat seat) {
        return seat.part == EnumDriveablePart.turret;
    }

    public String func_70023_ak() {
        return this.getDriveableType().name;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showInventory(int seat) {
        return seat == 0 ? !FlansModClient.controlModeMouse : true;
    }

    @Override
    public void destroyCraft() {
    }

    @Override
    public int doDamage(int damage) {
        DriveableType type = this.getDriveableType();
        damage *= 5;
        damage = (int)((float)damage / type.mass);
        DriveablePart core = this.getDriveableData().parts.get((Object)EnumDriveablePart.core);
        if (this.field_70170_p.field_72995_K) {
            return core.health;
        }
        DriveablePart randomPart = null;
        DriveablePart[] parts = this.getDriveableData().parts.values().toArray(new DriveablePart[0]);
        while (randomPart == null) {
            int random = this.field_70170_p.field_73012_v.nextInt(this.getDriveableData().parts.size());
            randomPart = parts[random];
            if (!randomPart.dead) continue;
            randomPart = null;
        }
        int coreDamage = damage / 8;
        core.health -= coreDamage;
        randomPart.health -= damage - coreDamage;
        this.checkParts();
        PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)100.0, (int)this.field_71093_bK, (Packet)PacketDriveableDamage.buildUpdatePacket(this));
        return core.health;
    }

    @Override
    public boolean canBeTargeted(Object entity) {
        DriveableType type = this.getDriveableType();
        if (type.onRadar && FlansMod.isICBMSentryLoaded) {
            try {
                Class<?> auto = Class.forName("icbm.sentry.turret.TileEntityTurret");
                Class<?> terminal = Class.forName("icbm.sentry.terminal.TileEntityTerminal");
                if (auto.isInstance(entity)) {
                    Method m = auto.getMethod("getPlatform", new Class[0]);
                    Method ac = terminal.getMethod("canUserAccess", String.class);
                    Object plat = m.invoke(entity, new Object[0]);
                    boolean allNull = true;
                    for (int i = 0; i < this.seats.length; ++i) {
                        if (this.seats[i].field_70153_n == null || !(this.seats[i].field_70153_n instanceof EntityPlayerMP)) continue;
                        allNull = false;
                        Boolean access = (Boolean)ac.invoke(plat, ((EntityPlayerMP)this.seats[i].field_70153_n).field_71092_bJ);
                        if (!access.booleanValue()) continue;
                        return false;
                    }
                    if (allNull) {
                        return false;
                    }
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }
}

