/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.driveables.mechas;

import co.uk.flansmods.client.model.ModelMechaTool;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.InfoType;
import co.uk.flansmods.common.TypeFile;
import co.uk.flansmods.common.driveables.mechas.EnumMechaItemType;
import co.uk.flansmods.common.driveables.mechas.EnumMechaToolType;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;

public class MechaItemType
extends InfoType {
    public static ArrayList<MechaItemType> types = new ArrayList();
    public EnumMechaItemType type;
    public EnumMechaToolType function = EnumMechaToolType.sword;
    public float speed = 1.0f;
    public float toolHardness = 1.0f;
    public float reach = 1.0f;
    public boolean floater = false;
    public boolean stopMechaFallDamage = false;
    public boolean forceBlockFallDamage = false;
    public boolean vacuumItems = false;
    @SideOnly(value=Side.CLIENT)
    public ModelMechaTool model;

    public MechaItemType(TypeFile file) {
        super(file);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelMechaTool.class);
            }
            if (split[0].equals("Texture")) {
                this.texture = split[1];
            }
            if (split[0].equals("Type")) {
                this.type = EnumMechaItemType.getToolType(split[1]);
            }
            if (split[0].equals("ToolType")) {
                this.function = EnumMechaToolType.getToolType(split[1]);
            }
            if (split[0].equals("Speed")) {
                this.speed = Float.parseFloat(split[1]);
            }
            if (split[0].equals("ToolHardness")) {
                this.toolHardness = Float.parseFloat(split[1]);
            }
            if (split[0].equals("Reach")) {
                this.reach = Float.parseFloat(split[1]);
            }
            if (split[0].equals("StopMechaFallDamage")) {
                this.stopMechaFallDamage = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("ForceBlockFallDamage")) {
                this.forceBlockFallDamage = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("ItemVacuum")) {
                this.vacuumItems = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("Floatation")) {
                this.floater = Boolean.parseBoolean(split[1].toLowerCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static MechaItemType getTool(String find) {
        for (MechaItemType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        if (this.modelString != null) {
            this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelMechaTool.class);
        }
    }
}

