/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.network;

import co.uk.flansmods.client.GuiTeamSelect;
import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.network.FlanPacketCommon;
import co.uk.flansmods.common.teams.PlayerClass;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class PacketTeamSelect
extends FlanPacketCommon {
    public static final byte packetID = 6;

    public static Packet buildTeamChoicesPacket(Team[] teams) {
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = channelFlan;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(6);
            data.writeBoolean(false);
            data.writeByte(teams.length);
            for (int i = 0; i < teams.length; ++i) {
                data.writeUTF(teams[i] == null ? Team.spectators.shortName : teams[i].shortName);
            }
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            data.close();
            bytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packet;
    }

    public static Packet buildClassChoicesPacket(PlayerClass[] classes) {
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = channelFlan;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(6);
            data.writeBoolean(true);
            data.writeByte(classes.length);
            for (int i = 0; i < classes.length; ++i) {
                data.writeUTF(classes[i].shortName);
            }
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            data.close();
            bytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packet;
    }

    public static Packet buildSelectionPacket(String shortName, boolean classPacket) {
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = channelFlan;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(6);
            data.writeBoolean(classPacket);
            data.writeUTF(shortName);
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            data.close();
            bytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packet;
    }

    @Override
    public void interpret(DataInputStream stream, Object[] extradata, Side side) {
        if (side.equals((Object)Side.CLIENT)) {
            this.interpretClient(stream, extradata);
        }
        if (side.equals((Object)Side.SERVER)) {
            this.interpretServer(stream, extradata);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void interpretClient(DataInputStream stream, Object[] extradata) {
        try {
            boolean classPacket = stream.readBoolean();
            if (classPacket) {
                int numClasses = stream.readByte();
                PlayerClass[] classes = new PlayerClass[numClasses];
                for (int i = 0; i < numClasses; ++i) {
                    classes[i] = PlayerClass.getClass(stream.readUTF());
                }
                Minecraft.func_71410_x().func_71373_a((GuiScreen)new GuiTeamSelect(classes));
            } else {
                int numTeams = stream.readByte();
                Team[] teams = new Team[numTeams];
                for (int i = 0; i < numTeams; ++i) {
                    teams[i] = Team.getTeam(stream.readUTF());
                }
                Minecraft.func_71410_x().func_71373_a((GuiScreen)new GuiTeamSelect(teams));
            }
        }
        catch (Exception e) {
            FlansMod.log("Error reading packet or opening team gui");
            e.printStackTrace();
        }
    }

    public void interpretServer(DataInputStream stream, Object[] extradata) {
        try {
            EntityPlayerMP player = (EntityPlayerMP)extradata[0];
            boolean classPacket = stream.readBoolean();
            String choice = stream.readUTF();
            if (classPacket) {
                TeamsManager.getInstance().playerSelectedClass(player, choice);
            } else {
                TeamsManager.getInstance().playerSelectedTeam(player, choice);
            }
        }
        catch (Exception e) {
            FlansMod.log("Error reading packet or selecting team / class");
            e.printStackTrace();
        }
    }
}

