/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.network;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.driveables.EntityDriveable;
import co.uk.flansmods.common.network.FlanPacketCommon;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class PacketVehicleControl
extends FlanPacketCommon {
    public static final byte packetID = 3;

    public static Packet buildUpdatePacket(EntityDriveable driveable) {
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = channelFlan;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(3);
            data.writeInt(driveable.field_70157_k);
            data.writeDouble(driveable.field_70165_t);
            data.writeDouble(driveable.field_70163_u);
            data.writeDouble(driveable.field_70161_v);
            data.writeFloat(driveable.axes.getYaw());
            data.writeFloat(driveable.axes.getPitch());
            data.writeFloat(driveable.axes.getRoll());
            data.writeDouble(driveable.field_70159_w);
            data.writeDouble(driveable.field_70181_x);
            data.writeDouble(driveable.field_70179_y);
            data.writeFloat(driveable.angularVelocity.x);
            data.writeFloat(driveable.angularVelocity.y);
            data.writeFloat(driveable.angularVelocity.z);
            data.writeFloat(driveable.throttle);
            data.writeFloat(driveable.driveableData.fuelInTank);
            driveable.writeUpdateData(data);
            packet.field_73629_c = bytes.toByteArray();
            packet.field_73628_b = packet.field_73629_c.length;
            data.close();
            bytes.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packet;
    }

    @Override
    public void interpret(DataInputStream stream, Object[] extradata, Side side) {
        try {
            EntityPlayer player = (EntityPlayer)extradata[0];
            int entityId = stream.readInt();
            EntityDriveable driveable = null;
            for (Object obj : player.field_70170_p.field_72996_f) {
                if (!(obj instanceof EntityDriveable) || ((Entity)obj).field_70157_k != entityId) continue;
                driveable = (EntityDriveable)obj;
                if (!side.isClient() || driveable.seats[0] == null || driveable.seats[0].field_70153_n != player) break;
                return;
            }
            if (driveable != null) {
                driveable.setPositionRotationAndMotion(stream.readDouble(), stream.readDouble(), stream.readDouble(), stream.readFloat(), stream.readFloat(), stream.readFloat(), stream.readDouble(), stream.readDouble(), stream.readDouble(), stream.readFloat(), stream.readFloat(), stream.readFloat(), stream.readFloat());
                driveable.driveableData.fuelInTank = stream.readFloat();
                driveable.readUpdateData(stream);
            }
        }
        catch (Exception e) {
            FlansMod.log("error parsing control packet");
            e.printStackTrace();
        }
    }

    @Override
    public byte getPacketID() {
        return 3;
    }
}

