/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansMod;
import co.uk.flansmods.common.FlansModPlayerData;
import co.uk.flansmods.common.FlansModPlayerHandler;
import co.uk.flansmods.common.teams.Gametype;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TeamsManager;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.EnumChatFormatting;

public class CommandTeams
extends CommandBase {
    public static TeamsManager teamsManager = TeamsManager.getInstance();

    public String func_71517_b() {
        return "teams";
    }

    public void func_71515_b(ICommandSender sender, String[] split) {
        if (teamsManager == null) {
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"Teams mod is broken. You will need to look at the server side logs to see what's wrong"));
            return;
        }
        if (split == null || split.length == 0 || split[0].equals("help") || split[0].equals("?")) {
            if (split.length == 2) {
                this.sendHelpInformation(sender, Integer.parseInt(split[1]));
            } else {
                this.sendHelpInformation(sender, 1);
            }
            return;
        }
        if (split[0].equals("off")) {
            CommandTeams.teamsManager.currentGametype = null;
            TeamsManager.messageAll("Flan's Teams Mod disabled");
            return;
        }
        if (split[0].equals("survival")) {
            FlansMod.explosions = true;
            FlansMod.driveablesBreakBlocks = true;
            FlansMod.bombsEnabled = true;
            FlansMod.bulletsEnabled = true;
            FlansMod.forceAdventureMode = false;
            FlansMod.canBreakGuns = true;
            FlansMod.canBreakGlass = true;
            FlansMod.armourDrops = true;
            FlansMod.weaponDrops = 1;
            FlansMod.vehiclesNeedFuel = true;
            FlansMod.mechaLove = 0;
            FlansMod.aaLife = 0;
            FlansMod.vehicleLife = 0;
            FlansMod.planeLife = 0;
            FlansMod.mgLife = 0;
            TeamsManager.messageAll("Flan's Mod switching to survival presets");
            return;
        }
        if (split[0].equals("arena")) {
            FlansMod.explosions = false;
            FlansMod.driveablesBreakBlocks = false;
            FlansMod.bombsEnabled = true;
            FlansMod.bulletsEnabled = true;
            FlansMod.forceAdventureMode = true;
            FlansMod.canBreakGuns = true;
            FlansMod.canBreakGlass = false;
            FlansMod.armourDrops = false;
            FlansMod.weaponDrops = 2;
            FlansMod.vehiclesNeedFuel = false;
            FlansMod.mechaLove = 120;
            FlansMod.aaLife = 120;
            FlansMod.vehicleLife = 120;
            FlansMod.planeLife = 120;
            FlansMod.mgLife = 120;
            TeamsManager.messageAll("Flan's Mod switching to arena mode presets");
            return;
        }
        if (split[0].equals("listGametypes")) {
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a72Showing all avaliable gametypes"));
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a72To pick a gametype, use \"/teams setGametype <gametype>\" with the name in brackets"));
            for (Gametype gametype : Gametype.gametypes) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("\u00a7f" + gametype.name + " (" + gametype.shortName + ")")));
            }
            return;
        }
        if (split[0].equals("setGametype")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a74To set the gametype, use \"/teams setGametype <gametype>\" with a valid gametype."));
                return;
            }
            if (split[1].toLowerCase().equals("none")) {
                if (CommandTeams.teamsManager.currentGametype != null) {
                    CommandTeams.teamsManager.currentGametype.stopGametype();
                }
                CommandTeams.teamsManager.currentGametype = null;
                for (FlansModPlayerData data : FlansModPlayerHandler.serverSideData.values()) {
                    if (data == null) continue;
                    data.team = null;
                }
                return;
            }
            Gametype gametype = Gametype.getGametype(split[1]);
            if (gametype == null) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a74Invalid gametype. To see gametypes available type \"/teams listGametypes\""));
                return;
            }
            if (CommandTeams.teamsManager.currentGametype != null) {
                CommandTeams.teamsManager.currentGametype.stopGametype();
            }
            CommandTeams.teamsManager.currentGametype = gametype;
            TeamsManager.messageAll("\u00a72" + sender.func_70005_c_() + "\u00a7f changed the gametype to \u00a72" + gametype.name);
            if (CommandTeams.teamsManager.teams != null && gametype.numTeamsRequired == CommandTeams.teamsManager.teams.length) {
                TeamsManager.messageAll("\u00a7fTeams will remain the same unless altered by an op.");
            } else {
                CommandTeams.teamsManager.teams = new Team[gametype.numTeamsRequired];
                TeamsManager.messageAll("\u00a7fTeams must be reassigned for this gametype. Please wait for an op to do so.");
            }
            gametype.initGametype();
            return;
        }
        if (split[0].equals("listMaps")) {
            if (CommandTeams.teamsManager.maps == null) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"The map list is null"));
                return;
            }
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a72Listing maps and corresponding IDs"));
            for (int i = 0; i < CommandTeams.teamsManager.maps.size(); ++i) {
                TeamsManager.TeamsMap map = CommandTeams.teamsManager.maps.get(i);
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)((map == CommandTeams.teamsManager.currentMap ? "\u00a74" : "") + i + ". " + map.name + " (" + map.shortName + ")")));
            }
            return;
        }
        if (split[0].equals("addMap")) {
            if (split.length < 3) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"You need to specify a map name"));
                return;
            }
            String shortName = split[1];
            String name = split[2];
            for (int i = 3; i < split.length; ++i) {
                name = name + " " + split[i];
            }
            CommandTeams.teamsManager.maps.add(new TeamsManager.TeamsMap(shortName, name));
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Added new map : " + name + " (" + shortName + ")")));
            return;
        }
        if (split[0].equals("removeMap")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"You need to specify a map's short name"));
                return;
            }
            TeamsManager.TeamsMap map = teamsManager.getTeamsMap(split[1]);
            if (map != null) {
                CommandTeams.teamsManager.maps.remove(map);
            }
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Removed map " + split[1])));
            return;
        }
        if (split[0].equals("setMap")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"You need to specify a map's short name"));
                return;
            }
            TeamsManager.TeamsMap map = teamsManager.getTeamsMap(split[1]);
            if (map != null) {
                TeamsManager.messageAll("\u00a72Map changed to " + map.name + ".");
                CommandTeams.teamsManager.currentMap = map;
                if (CommandTeams.teamsManager.currentGametype != null) {
                    CommandTeams.teamsManager.currentGametype.startNewRound();
                }
            }
            return;
        }
        if (split[0].equals("listTeams")) {
            if (CommandTeams.teamsManager.currentGametype == null || CommandTeams.teamsManager.teams == null) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a74The gametype is not yet set. Set it by \"/teams setGametype <gametype>\""));
                return;
            }
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a72Showing currently in use teams"));
            for (int i = 0; i < CommandTeams.teamsManager.teams.length; ++i) {
                Team team = CommandTeams.teamsManager.teams[i];
                if (team == null) {
                    sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("\u00a7f" + i + " : No team")));
                    continue;
                }
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("\u00a7" + team.textColour + i + " : " + team.name + " (" + team.shortName + ")")));
            }
            return;
        }
        if (split[0].equals("listAllTeams")) {
            if (Team.teams.size() == 0) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a74No teams available. You need a content pack that has some teams with it"));
                return;
            }
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a72Showing all avaliable teams"));
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a72To pick these teams, use /teams setTeams <team1> <team2> with the names in brackets"));
            for (Team team : Team.teams) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("\u00a7" + team.textColour + team.name + " (" + team.shortName + ")")));
            }
            return;
        }
        if (split[0].equals("setTeams")) {
            if (CommandTeams.teamsManager.currentGametype == null || CommandTeams.teamsManager.teams == null) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a74No gametype selected. Please select the gametype with the setGametype command"));
                return;
            }
            if (split.length - 1 != CommandTeams.teamsManager.teams.length) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("\u00a74Wrong number of teams given. This gametype requires " + CommandTeams.teamsManager.teams.length + " teams to work")));
                return;
            }
            Team[] teams = new Team[CommandTeams.teamsManager.teams.length];
            String teamList = "";
            for (int i = 0; i < split.length - 1; ++i) {
                Team team = Team.getTeam(split[i + 1]);
                if (team == null) {
                    sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("\u00a74" + split[i + 1] + " is not a valid team")));
                    return;
                }
                for (int j = 0; j < i; ++j) {
                    if (team != teams[j]) continue;
                    sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("\u00a74You may not add " + split[i + 1] + " twice")));
                    return;
                }
                teams[i] = team;
                teamList = teamList + (i == 0 ? "" : (i == split.length - 2 ? " and " : ", ")) + "\u00a7" + team.textColour + team.name + "\u00a7f";
            }
            CommandTeams.teamsManager.teams = teams;
            CommandTeams.teamsManager.currentGametype.teamsSet();
            TeamsManager.messageAll("\u00a72" + sender.func_70005_c_() + "\u00a7f changed the teams to be " + teamList);
            return;
        }
        if (split[0].equals("getSticks") || split[0].equals("getOpSticks") || split[0].equals("getOpKit")) {
            EntityPlayerMP player = this.getPlayer(sender.func_70005_c_());
            if (player != null) {
                player.field_71071_by.func_70441_a(new ItemStack(FlansMod.opStick, 1, 0));
                player.field_71071_by.func_70441_a(new ItemStack(FlansMod.opStick, 1, 1));
                player.field_71071_by.func_70441_a(new ItemStack(FlansMod.opStick, 1, 2));
                player.field_71071_by.func_70441_a(new ItemStack(FlansMod.opStick, 1, 3));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a72Enjoy your op sticks."));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a77The Stick of Connecting connects objects (spawners, banners etc) to bases (flagpoles etc)"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a77The Stick of Ownership sets the team that currently owns a base"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a77The Stick of Mapping sets the map that a base is currently associated with"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a77The Stick of Destruction deletes bases and team objects"));
            }
            return;
        }
        if (split[0].equals("useRotation")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <true/false>")));
                return;
            }
            FlansMod.useRotation = Boolean.parseBoolean(split[1]);
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Map rotation is now " + (FlansMod.useRotation ? "enabled" : "disabled"))));
            return;
        }
        if (split[0].equals("listRotation")) {
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"\u00a72Current Map Rotation"));
            for (int i = 0; i < TeamsManager.getInstance().rotation.size(); ++i) {
                TeamsManager.RotationEntry entry = TeamsManager.getInstance().rotation.get(i);
                String s = i + ". " + entry.map.shortName + ", " + entry.gametype.shortName;
                if (i == TeamsManager.getInstance().currentRotationEntry) {
                    s = "\u00a74" + s;
                }
                for (int j = 0; j < entry.teams.length; ++j) {
                    s = s + ", " + entry.teams[j].shortName;
                }
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)s));
            }
            return;
        }
        if (split[0].equals("removeMapFromRotation") || split[0].equals("removeFromRotation") || split[0].equals("removeRotation")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <ID>")));
                return;
            }
            int map = Integer.parseInt(split[1]);
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Removed map " + map + " (" + TeamsManager.getInstance().rotation.get((int)map).map.shortName + ") from rotation")));
            TeamsManager.getInstance().rotation.remove(map);
            return;
        }
        if (split[0].equals("addMapToRotation") || split[0].equals("addToRotation") || split[0].equals("addRotation")) {
            if (split.length < 5) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <Map> <Gametype> <Team1> <Team2> ...")));
                return;
            }
            TeamsManager.TeamsMap map = TeamsManager.getInstance().getTeamsMap(split[1]);
            Gametype gametype = Gametype.getGametype(split[2]);
            if (split.length != 3 + gametype.numTeamsRequired) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <Map> <Gametype> <Team1> <Team2> ...")));
                return;
            }
            Team[] teams = new Team[gametype.numTeamsRequired];
            for (int i = 0; i < teams.length; ++i) {
                teams[i] = Team.getTeam(split[3 + i]);
            }
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Added map (" + map.shortName + ") to rotation")));
            TeamsManager.getInstance().rotation.add(new TeamsManager.RotationEntry(map, gametype, teams));
            return;
        }
        if (split[0].equals("nextMap")) {
            teamsManager.switchToNextGametype();
            return;
        }
        if (split[0].equals("goToMap")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <ID>")));
                return;
            }
            int prevRotation = Integer.parseInt(split[1]) - 1;
            if (prevRotation == -1) {
                prevRotation = CommandTeams.teamsManager.rotation.size() - 1;
            }
            CommandTeams.teamsManager.currentRotationEntry = prevRotation;
            teamsManager.switchToNextGametype();
            return;
        }
        if (split[0].equals("forceAdventure") || split[0].equals("forceAdventureMode")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <true/false>")));
                return;
            }
            FlansMod.forceAdventureMode = Boolean.parseBoolean(split[1]);
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Adventure mode will " + (FlansMod.forceAdventureMode ? "now" : "no longer") + " be forced")));
            return;
        }
        if (split[0].equals("explosions")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <true/false>")));
                return;
            }
            FlansMod.explosions = Boolean.parseBoolean(split[1]);
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Expolsions are now " + (FlansMod.explosions ? "enabled" : "disabled"))));
            return;
        }
        if (split[0].equals("bombs") || split[0].equals("allowBombs")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <true/false>")));
                return;
            }
            FlansMod.bombsEnabled = Boolean.parseBoolean(split[1]);
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Bombs are now " + (FlansMod.bombsEnabled ? "enabled" : "disabled"))));
            return;
        }
        if (split[0].equals("bullets") || split[0].equals("bulletsEnabled")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <true/false>")));
                return;
            }
            FlansMod.bulletsEnabled = Boolean.parseBoolean(split[1]);
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Bullets are now " + (FlansMod.bulletsEnabled ? "enabled" : "disabled"))));
            return;
        }
        if (split[0].equals("canBreakGuns")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <true/false>")));
                return;
            }
            FlansMod.canBreakGuns = Boolean.parseBoolean(split[1]);
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("AAGuns and MGs can " + (FlansMod.canBreakGuns ? "now" : "no longer") + " be broken")));
            return;
        }
        if (split[0].equals("canBreakGlass")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <true/false>")));
                return;
            }
            FlansMod.canBreakGlass = Boolean.parseBoolean(split[1]);
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Glass and glowstone can " + (FlansMod.canBreakGlass ? "now" : "no longer") + " be broken")));
            return;
        }
        if (split[0].equals("armourDrops") || split[0].equals("armorDrops")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <true/false>")));
                return;
            }
            FlansMod.armourDrops = Boolean.parseBoolean(split[1]);
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Armour will " + (FlansMod.armourDrops ? "now" : "no longer") + " be dropped")));
            return;
        }
        if (split[0].equals("weaponDrops")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <on/off/smart>")));
                return;
            }
            if (split[1].toLowerCase().equals("on")) {
                FlansMod.weaponDrops = 1;
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"Weapons will be dropped normally"));
            } else if (split[1].toLowerCase().equals("off")) {
                FlansMod.weaponDrops = 0;
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"Weapons will be not be dropped"));
            } else if (split[1].toLowerCase().equals("smart")) {
                FlansMod.weaponDrops = 2;
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"Smart drops enabled"));
            }
            return;
        }
        if (split[0].equals("fuelNeeded")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <true/false>")));
                return;
            }
            FlansMod.vehiclesNeedFuel = Boolean.parseBoolean(split[1]);
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Vehicles will " + (FlansMod.vehiclesNeedFuel ? "now" : "no longer") + " require fuel")));
            return;
        }
        if (split[0].equals("mgLife")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <time>")));
                return;
            }
            FlansMod.mgLife = Integer.parseInt(split[1]);
            if (FlansMod.mgLife > 0) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("MGs will despawn after " + FlansMod.mgLife + " seconds")));
            } else {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"MGs will not despawn"));
            }
            return;
        }
        if (split[0].equals("planeLife")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <time>")));
                return;
            }
            FlansMod.planeLife = Integer.parseInt(split[1]);
            if (FlansMod.planeLife > 0) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Planes will despawn after " + FlansMod.planeLife + " seconds")));
            } else {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"Planes will not despawn"));
            }
            return;
        }
        if (split[0].equals("vehicleLife")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <time>")));
                return;
            }
            FlansMod.vehicleLife = Integer.parseInt(split[1]);
            if (FlansMod.vehicleLife > 0) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Vehicles will despawn after " + FlansMod.vehicleLife + " seconds")));
            } else {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"Vehicles will not despawn"));
            }
            return;
        }
        if (split[0].equals("mechaLife")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <time>")));
                return;
            }
            FlansMod.mechaLove = Integer.parseInt(split[1]);
            if (FlansMod.mechaLove > 0) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Mechas will despawn after " + FlansMod.mechaLove + " seconds")));
            } else {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"Mechas will not despawn"));
            }
            return;
        }
        if (split[0].equals("aaLife")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <time>")));
                return;
            }
            FlansMod.aaLife = Integer.parseInt(split[1]);
            if (FlansMod.aaLife > 0) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("AA Guns will despawn after " + FlansMod.aaLife + " seconds")));
            } else {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"AA Guns will not despawn"));
            }
            return;
        }
        if (split[0].equals("vehiclesBreakBlocks")) {
            if (split.length != 2) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Incorrect Usage : Should be /teams " + split[0] + " <true/false>")));
                return;
            }
            FlansMod.driveablesBreakBlocks = Boolean.parseBoolean(split[1]);
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Vehicles will " + (FlansMod.driveablesBreakBlocks ? "now" : "no longer") + " break blocks")));
            return;
        }
        if (split[0].equals("setVariable")) {
            if (TeamsManager.getInstance().currentGametype == null) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"There is no gametype to set variables for"));
                return;
            }
            if (split.length != 3) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"Incorrect Usage : Should be /teams setVariable <variable> <value>"));
                return;
            }
            if (TeamsManager.getInstance().currentGametype.setVariable(split[1], split[2])) {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Set variable " + split[1] + " in gametype " + TeamsManager.getInstance().currentGametype.shortName + " to " + split[2])));
            } else {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("Variable " + split[1] + " did not exist in gametype " + TeamsManager.getInstance().currentGametype.shortName)));
            }
            return;
        }
        sender.func_70006_a(ChatMessageComponent.func_111066_d((String)(split[0] + " is not a valid teams command. Try /teams help")));
    }

    public void sendHelpInformation(ICommandSender sender, int page) {
        if (page > 3 || page < 1) {
            sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"Invalid help page, should be in the range (1-3)").func_111059_a(EnumChatFormatting.RED));
            return;
        }
        sender.func_70006_a(ChatMessageComponent.func_111066_d((String)("\u00a72Listing teams commands \u00a7f[Page " + page + " of 3]")));
        switch (page) {
            case 1: {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams help [page]"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams off"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams arena"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams survival"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams getSticks"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams listGametypes"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams setGametype <name>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams listAllTeams"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams listTeams"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams setTeams <teamName1> <teamName2>"));
                break;
            }
            case 2: {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams addMap <shortName> <longName>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams listMaps"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams removeMap <shortName>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams setMap <shortName>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams useRotation <true / false>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams addRotation <map> <gametype> <team1> <team2> ..."));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams listRotation"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams removeRotation <ID>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams nextMap"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams goToMap <ID>"));
                break;
            }
            case 3: {
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams setVariable <variable> <value>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams forceAdventure <true / false>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams explosions <true / false>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams canBreakGuns <true / false>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams canBreakGlass <true / false>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams armourDrops <true / false>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams weaponDrops <off / on / smart>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams fuelNeeded <true / false>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams mgLife <time>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams planeLife <time>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams vehicleLife <time>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams aaLife <time>"));
                sender.func_70006_a(ChatMessageComponent.func_111066_d((String)"/teams vehiclesBreakBlocks <true / false>"));
            }
        }
    }

    public EntityPlayerMP getPlayer(String name) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(name);
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "Try \"/teams help\"";
    }
}

