/*
 * Decompiled with CFR 0.152.
 */
package co.uk.flansmods.common.teams;

import co.uk.flansmods.common.FlansModPlayerHandler;
import co.uk.flansmods.common.teams.Team;
import co.uk.flansmods.common.teams.TileEntitySpawner;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class EntityTeamItem
extends EntityItem
implements IEntityAdditionalSpawnData {
    public TileEntitySpawner spawner;
    public double angle;
    public int xCoord;
    public int yCoord;
    public int zCoord;

    public EntityTeamItem(TileEntitySpawner te, int i) {
        super(te.field_70331_k, (double)((float)te.field_70329_l + 0.5f), (double)((float)te.field_70330_m + 0.5f), (double)((float)te.field_70327_n + 0.5f), te.stacksToSpawn.get(i).func_77946_l());
        te.itemEntities.add(this);
        this.angle = (double)i * Math.PI * 2.0 / (double)te.stacksToSpawn.size();
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.lifespan = 1000000000;
        this.spawner = te;
    }

    public EntityTeamItem(World world) {
        super(world);
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int i) {
    }

    public void func_70071_h_() {
        ++this.field_70173_aa;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70126_B = this.field_70177_z;
        ++this.field_70292_b;
        if (this.field_70170_p.field_72995_K) {
            this.angle += 0.05;
            this.func_70107_b((double)((float)this.xCoord + 0.5f) + Math.cos(this.angle) * (double)0.3f, (float)this.yCoord + 0.5f, (double)((float)this.zCoord + 0.5f) + Math.sin(this.angle) * (double)0.3f);
        }
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        return false;
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.field_70170_p.field_72995_K) {
            EntityItemPickupEvent event = new EntityItemPickupEvent(par1EntityPlayer, (EntityItem)this);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            Team spawnerTeam = this.spawner.getTeam();
            Team playerTeam = FlansModPlayerHandler.getPlayerData((EntityPlayer)par1EntityPlayer).team;
            if (spawnerTeam != null && playerTeam != spawnerTeam) {
                return;
            }
            int var2 = this.func_92059_d().field_77994_a;
            if (event.getResult() == Event.Result.ALLOW || var2 <= 0 || par1EntityPlayer.field_71071_by.func_70441_a(this.func_92059_d())) {
                GameRegistry.onPickupNotification((EntityPlayer)par1EntityPlayer, (EntityItem)this);
                this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                par1EntityPlayer.func_71001_a((Entity)this, var2);
                if (this.func_92059_d().field_77994_a <= 0) {
                    this.spawner.itemEntities.remove((Object)this);
                    this.func_70106_y();
                }
            }
        }
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        try {
            data.writeInt(this.spawner.field_70329_l);
            data.writeInt(this.spawner.field_70330_m);
            data.writeInt(this.spawner.field_70327_n);
            data.writeDouble(this.angle);
            NBTTagCompound tags = new NBTTagCompound();
            this.func_92059_d().func_77955_b(tags);
            NBTBase.func_74731_a((NBTBase)tags, (DataOutput)data);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.func_70106_y();
        }
    }

    public void readSpawnData(ByteArrayDataInput data) {
        try {
            this.xCoord = data.readInt();
            this.yCoord = data.readInt();
            this.zCoord = data.readInt();
            this.angle = data.readDouble();
            this.func_92058_a(ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)NBTBase.func_74739_b((DataInput)data))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_70037_a(NBTTagCompound tags) {
        this.func_70106_y();
    }
}

