/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.relauncher.CoreModManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModDiscoverer {
    private static Pattern zipJar = Pattern.compile("(.+).(zip|jar)$");
    private List<ModCandidate> candidates = Lists.newArrayList();
    private ASMDataTable dataTable = new ASMDataTable();
    private List<File> nonModLibs = Lists.newArrayList();

    public void findClasspathMods(ModClassLoader modClassLoader) {
        ImmutableList knownLibraries = ImmutableList.builder().addAll((Iterable)modClassLoader.getDefaultLibraries()).addAll((Iterable)CoreModManager.getLoadedCoremods()).addAll((Iterable)CoreModManager.getReparseableCoremods()).build();
        File[] minecraftSources = modClassLoader.getParentSources();
        if (minecraftSources.length == 1 && minecraftSources[0].isFile()) {
            FMLLog.fine((String)"Minecraft is a file at %s, loading", (Object[])new Object[]{minecraftSources[0].getAbsolutePath()});
            this.candidates.add(new ModCandidate(minecraftSources[0], minecraftSources[0], ContainerType.JAR, true, true));
        } else {
            for (int i = 0; i < minecraftSources.length; ++i) {
                if (minecraftSources[i].isFile()) {
                    if (knownLibraries.contains(minecraftSources[i].getName())) {
                        FMLLog.finer((String)"Skipping known library file %s", (Object[])new Object[]{minecraftSources[i].getAbsolutePath()});
                        continue;
                    }
                    FMLLog.fine((String)"Found a minecraft related file at %s, examining for mod candidates", (Object[])new Object[]{minecraftSources[i].getAbsolutePath()});
                    this.candidates.add(new ModCandidate(minecraftSources[i], minecraftSources[i], ContainerType.JAR, i == 0, true));
                    continue;
                }
                if (!minecraftSources[i].isDirectory()) continue;
                FMLLog.fine((String)"Found a minecraft related directory at %s, examining for mod candidates", (Object[])new Object[]{minecraftSources[i].getAbsolutePath()});
                this.candidates.add(new ModCandidate(minecraftSources[i], minecraftSources[i], ContainerType.DIR, i == 0, true));
            }
        }
    }

    public void findModDirMods(File modsDir) {
        Object[] modList = modsDir.listFiles();
        Arrays.sort(modList);
        for (Object modFile : modList) {
            if (CoreModManager.getLoadedCoremods().contains(((File)modFile).getName())) {
                FMLLog.finer((String)"Skipping already parsed coremod or tweaker %s", (Object[])new Object[]{((File)modFile).getName()});
                continue;
            }
            if (((File)modFile).isDirectory()) {
                FMLLog.fine((String)"Found a candidate mod directory %s", (Object[])new Object[]{((File)modFile).getName()});
                this.candidates.add(new ModCandidate((File)modFile, (File)modFile, ContainerType.DIR));
                continue;
            }
            Matcher matcher = zipJar.matcher(((File)modFile).getName());
            if (matcher.matches()) {
                FMLLog.fine((String)"Found a candidate zip or jar file %s", (Object[])new Object[]{matcher.group(0)});
                this.candidates.add(new ModCandidate((File)modFile, (File)modFile, ContainerType.JAR));
                continue;
            }
            FMLLog.fine((String)"Ignoring unknown file %s in mods directory", (Object[])new Object[]{((File)modFile).getName()});
        }
    }

    public List<ModContainer> identifyMods() {
        ArrayList modList = Lists.newArrayList();
        for (ModCandidate candidate : this.candidates) {
            try {
                List mods = candidate.explore(this.dataTable);
                if (mods.isEmpty() && !candidate.isClasspath()) {
                    this.nonModLibs.add(candidate.getModContainer());
                    continue;
                }
                modList.addAll(mods);
            }
            catch (LoaderException le) {
                FMLLog.log((Level)Level.WARNING, (Throwable)le, (String)"Identified a problem with the mod candidate %s, ignoring this source", (Object[])new Object[]{candidate.getModContainer()});
            }
            catch (Throwable t) {
                Throwables.propagate((Throwable)t);
            }
        }
        return modList;
    }

    public ASMDataTable getASMTable() {
        return this.dataTable;
    }

    public List<File> getNonModLibs() {
        return this.nonModLibs;
    }
}

