/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.world.ChunkEvent;

public class Chunk {
    public static boolean field_76640_a;
    private ExtendedBlockStorage[] field_76652_q = new ExtendedBlockStorage[16];
    private byte[] field_76651_r = new byte[256];
    public int[] field_76638_b = new int[256];
    public boolean[] field_76639_c = new boolean[256];
    public boolean field_76636_d;
    public World field_76637_e;
    public int[] field_76634_f;
    public final int field_76635_g;
    public final int field_76647_h;
    private boolean field_76650_s;
    public Map field_76648_i = new HashMap();
    public List[] field_76645_j = new List[16];
    public boolean field_76646_k;
    public boolean field_76643_l;
    public boolean field_76644_m;
    public long field_76641_n;
    public boolean field_76642_o;
    public int field_82912_p;
    public long field_111204_q;
    private int field_76649_t = 4096;

    public Chunk(World par1World, int par2, int par3) {
        this.field_76637_e = par1World;
        this.field_76635_g = par2;
        this.field_76647_h = par3;
        this.field_76634_f = new int[256];
        for (int k = 0; k < this.field_76645_j.length; ++k) {
            this.field_76645_j[k] = new ArrayList();
        }
        Arrays.fill(this.field_76638_b, -999);
        Arrays.fill(this.field_76651_r, (byte)-1);
    }

    public Chunk(World par1World, byte[] par2ArrayOfByte, int par3, int par4) {
        this(par1World, par3, par4);
        int k = par2ArrayOfByte.length / 256;
        for (int l = 0; l < 16; ++l) {
            for (int i1 = 0; i1 < 16; ++i1) {
                for (int j1 = 0; j1 < k; ++j1) {
                    int b0 = par2ArrayOfByte[l << 11 | i1 << 7 | j1] & 0xFF;
                    if (b0 == 0) continue;
                    int k1 = j1 >> 4;
                    if (this.field_76652_q[k1] == null) {
                        this.field_76652_q[k1] = new ExtendedBlockStorage(k1 << 4, !par1World.field_73011_w.field_76576_e);
                    }
                    this.field_76652_q[k1].func_76655_a(l, j1 & 0xF, i1, b0);
                }
            }
        }
    }

    public Chunk(World world, byte[] ids, byte[] metadata, int chunkX, int chunkZ) {
        this(world, chunkX, chunkZ);
        int k = ids.length / 256;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < k; ++y) {
                    int idx = x << 11 | z << 7 | y;
                    int id = ids[idx] & 0xFF;
                    byte meta = metadata[idx];
                    if (id == 0) continue;
                    int l = y >> 4;
                    if (this.field_76652_q[l] == null) {
                        this.field_76652_q[l] = new ExtendedBlockStorage(l << 4, !world.field_73011_w.field_76576_e);
                    }
                    this.field_76652_q[l].func_76655_a(x, y & 0xF, z, id);
                    this.field_76652_q[l].func_76654_b(x, y & 0xF, z, (int)meta);
                }
            }
        }
    }

    public Chunk(World world, short[] ids, byte[] metadata, int chunkX, int chunkZ) {
        this(world, chunkX, chunkZ);
        int max = ids.length / 256;
        for (int y = 0; y < max; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int idx = y << 8 | z << 4 | x;
                    int id = ids[idx] & 0xFFFFFF;
                    byte meta = metadata[idx];
                    if (id == 0) continue;
                    int storageBlock = y >> 4;
                    if (this.field_76652_q[storageBlock] == null) {
                        this.field_76652_q[storageBlock] = new ExtendedBlockStorage(storageBlock << 4, !world.field_73011_w.field_76576_e);
                    }
                    this.field_76652_q[storageBlock].func_76655_a(x, y & 0xF, z, id);
                    this.field_76652_q[storageBlock].func_76654_b(x, y & 0xF, z, (int)meta);
                }
            }
        }
    }

    public boolean func_76600_a(int par1, int par2) {
        return par1 == this.field_76635_g && par2 == this.field_76647_h;
    }

    public int func_76611_b(int par1, int par2) {
        return this.field_76634_f[par2 << 4 | par1];
    }

    public int func_76625_h() {
        for (int i = this.field_76652_q.length - 1; i >= 0; --i) {
            if (this.field_76652_q[i] == null) continue;
            return this.field_76652_q[i].func_76662_d();
        }
        return 0;
    }

    public ExtendedBlockStorage[] func_76587_i() {
        return this.field_76652_q;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_76590_a() {
        int i = this.func_76625_h();
        for (int j = 0; j < 16; ++j) {
            block1: for (int k = 0; k < 16; ++k) {
                this.field_76638_b[j + (k << 4)] = -999;
                for (int l = i + 16 - 1; l > 0; --l) {
                    int i1 = this.func_76610_a(j, l - 1, k);
                    if (this.func_76596_b(j, l - 1, k) == 0) {
                        continue;
                    }
                    this.field_76634_f[k << 4 | j] = l;
                    continue block1;
                }
            }
        }
        this.field_76643_l = true;
    }

    public void func_76603_b() {
        int k;
        int j;
        int i = this.func_76625_h();
        this.field_82912_p = Integer.MAX_VALUE;
        for (j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                int l;
                this.field_76638_b[j + (k << 4)] = -999;
                for (l = i + 16 - 1; l > 0; --l) {
                    if (this.func_76596_b(j, l - 1, k) == 0) {
                        continue;
                    }
                    this.field_76634_f[k << 4 | j] = l;
                    if (l >= this.field_82912_p) break;
                    this.field_82912_p = l;
                    break;
                }
                if (this.field_76637_e.field_73011_w.field_76576_e) continue;
                l = 15;
                int i1 = i + 16 - 1;
                do {
                    ExtendedBlockStorage extendedblockstorage;
                    if ((l -= this.func_76596_b(j, i1, k)) <= 0 || (extendedblockstorage = this.field_76652_q[i1 >> 4]) == null) continue;
                    extendedblockstorage.func_76657_c(j, i1 & 0xF, k, l);
                    this.field_76637_e.func_72902_n((this.field_76635_g << 4) + j, i1, (this.field_76647_h << 4) + k);
                } while (--i1 > 0 && l > 0);
            }
        }
        this.field_76643_l = true;
        for (j = 0; j < 16; ++j) {
            for (k = 0; k < 16; ++k) {
                this.func_76595_e(j, k);
            }
        }
    }

    private void func_76595_e(int par1, int par2) {
        this.field_76639_c[par1 + par2 * 16] = true;
        this.field_76650_s = true;
    }

    private void func_76593_q() {
        this.field_76637_e.field_72984_F.func_76320_a("recheckGaps");
        if (this.field_76637_e.func_72873_a(this.field_76635_g * 16 + 8, 0, this.field_76647_h * 16 + 8, 16)) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (!this.field_76639_c[i + j * 16]) continue;
                    this.field_76639_c[i + j * 16] = false;
                    int k = this.func_76611_b(i, j);
                    int l = this.field_76635_g * 16 + i;
                    int i1 = this.field_76647_h * 16 + j;
                    int j1 = this.field_76637_e.func_82734_g(l - 1, i1);
                    int k1 = this.field_76637_e.func_82734_g(l + 1, i1);
                    int l1 = this.field_76637_e.func_82734_g(l, i1 - 1);
                    int i2 = this.field_76637_e.func_82734_g(l, i1 + 1);
                    if (k1 < j1) {
                        j1 = k1;
                    }
                    if (l1 < j1) {
                        j1 = l1;
                    }
                    if (i2 < j1) {
                        j1 = i2;
                    }
                    this.func_76599_g(l, i1, j1);
                    this.func_76599_g(l - 1, i1, k);
                    this.func_76599_g(l + 1, i1, k);
                    this.func_76599_g(l, i1 - 1, k);
                    this.func_76599_g(l, i1 + 1, k);
                }
            }
            this.field_76650_s = false;
        }
        this.field_76637_e.field_72984_F.func_76319_b();
    }

    private void func_76599_g(int par1, int par2, int par3) {
        int l = this.field_76637_e.func_72976_f(par1, par2);
        if (l > par3) {
            this.func_76609_d(par1, par2, par3, l + 1);
        } else if (l < par3) {
            this.func_76609_d(par1, par2, l, par3 + 1);
        }
    }

    private void func_76609_d(int par1, int par2, int par3, int par4) {
        if (par4 > par3 && this.field_76637_e.func_72873_a(par1, 0, par2, 16)) {
            for (int i1 = par3; i1 < par4; ++i1) {
                this.field_76637_e.func_72936_c(EnumSkyBlock.Sky, par1, i1, par2);
            }
            this.field_76643_l = true;
        }
    }

    private void func_76615_h(int par1, int par2, int par3) {
        int l;
        int i1 = l = this.field_76634_f[par3 << 4 | par1] & 0xFF;
        if (par2 > l) {
            i1 = par2;
        }
        while (i1 > 0 && this.func_76596_b(par1, i1 - 1, par3) == 0) {
            --i1;
        }
        if (i1 != l) {
            int i2;
            int l1;
            this.field_76637_e.func_72975_g(par1 + this.field_76635_g * 16, par3 + this.field_76647_h * 16, i1, l);
            this.field_76634_f[par3 << 4 | par1] = i1;
            int j1 = this.field_76635_g * 16 + par1;
            int k1 = this.field_76647_h * 16 + par3;
            if (!this.field_76637_e.field_73011_w.field_76576_e) {
                ExtendedBlockStorage extendedblockstorage;
                if (i1 < l) {
                    for (l1 = i1; l1 < l; ++l1) {
                        extendedblockstorage = this.field_76652_q[l1 >> 4];
                        if (extendedblockstorage == null) continue;
                        extendedblockstorage.func_76657_c(par1, l1 & 0xF, par3, 15);
                        this.field_76637_e.func_72902_n((this.field_76635_g << 4) + par1, l1, (this.field_76647_h << 4) + par3);
                    }
                } else {
                    for (l1 = l; l1 < i1; ++l1) {
                        extendedblockstorage = this.field_76652_q[l1 >> 4];
                        if (extendedblockstorage == null) continue;
                        extendedblockstorage.func_76657_c(par1, l1 & 0xF, par3, 0);
                        this.field_76637_e.func_72902_n((this.field_76635_g << 4) + par1, l1, (this.field_76647_h << 4) + par3);
                    }
                }
                l1 = 15;
                while (i1 > 0 && l1 > 0) {
                    ExtendedBlockStorage extendedblockstorage1;
                    if ((i2 = this.func_76596_b(par1, --i1, par3)) == 0) {
                        i2 = 1;
                    }
                    if ((l1 -= i2) < 0) {
                        l1 = 0;
                    }
                    if ((extendedblockstorage1 = this.field_76652_q[i1 >> 4]) == null) continue;
                    extendedblockstorage1.func_76657_c(par1, i1 & 0xF, par3, l1);
                }
            }
            l1 = this.field_76634_f[par3 << 4 | par1];
            i2 = l;
            int j2 = l1;
            if (l1 < l) {
                i2 = l1;
                j2 = l;
            }
            if (l1 < this.field_82912_p) {
                this.field_82912_p = l1;
            }
            if (!this.field_76637_e.field_73011_w.field_76576_e) {
                this.func_76609_d(j1 - 1, k1, i2, j2);
                this.func_76609_d(j1 + 1, k1, i2, j2);
                this.func_76609_d(j1, k1 - 1, i2, j2);
                this.func_76609_d(j1, k1 + 1, i2, j2);
                this.func_76609_d(j1, k1, i2, j2);
            }
            this.field_76643_l = true;
        }
    }

    public int func_76596_b(int par1, int par2, int par3) {
        int x = (this.field_76635_g << 4) + par1;
        int z = (this.field_76647_h << 4) + par3;
        Block block = Block.field_71973_m[this.func_76610_a(par1, par2, par3)];
        return block == null ? 0 : block.getLightOpacity(this.field_76637_e, x, par2, z);
    }

    public int func_76610_a(int par1, int par2, int par3) {
        if (par2 >> 4 >= this.field_76652_q.length) {
            return 0;
        }
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[par2 >> 4];
        return extendedblockstorage != null ? extendedblockstorage.func_76656_a(par1, par2 & 0xF, par3) : 0;
    }

    public int func_76628_c(int par1, int par2, int par3) {
        if (par2 >> 4 >= this.field_76652_q.length) {
            return 0;
        }
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[par2 >> 4];
        return extendedblockstorage != null ? extendedblockstorage.func_76665_b(par1, par2 & 0xF, par3) : 0;
    }

    public boolean func_76592_a(int par1, int par2, int par3, int par4, int par5) {
        int j1 = par3 << 4 | par1;
        if (par2 >= this.field_76638_b[j1] - 1) {
            this.field_76638_b[j1] = -999;
        }
        int k1 = this.field_76634_f[j1];
        int l1 = this.func_76610_a(par1, par2, par3);
        int i2 = this.func_76628_c(par1, par2, par3);
        if (l1 == par4 && i2 == par5) {
            return false;
        }
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[par2 >> 4];
        boolean flag = false;
        if (extendedblockstorage == null) {
            if (par4 == 0) {
                return false;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(par2 >> 4 << 4, !this.field_76637_e.field_73011_w.field_76576_e);
            this.field_76652_q[par2 >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
            flag = par2 >= k1;
        }
        int j2 = this.field_76635_g * 16 + par1;
        int k2 = this.field_76647_h * 16 + par3;
        if (l1 != 0 && !this.field_76637_e.field_72995_K) {
            Block.field_71973_m[l1].func_71927_h(this.field_76637_e, j2, par2, k2, i2);
        }
        extendedblockstorage.func_76655_a(par1, par2 & 0xF, par3, par4);
        if (l1 != 0) {
            TileEntity te;
            if (!this.field_76637_e.field_72995_K) {
                Block.field_71973_m[l1].func_71852_a(this.field_76637_e, j2, par2, k2, l1, i2);
            } else if (Block.field_71973_m[l1] != null && Block.field_71973_m[l1].hasTileEntity(i2) && (te = this.field_76637_e.func_72796_p(j2, par2, k2)) != null && te.shouldRefresh(l1, par4, i2, par5, this.field_76637_e, j2, par2, k2)) {
                this.field_76637_e.func_72932_q(j2, par2, k2);
            }
        }
        if (extendedblockstorage.func_76656_a(par1, par2 & 0xF, par3) != par4) {
            return false;
        }
        extendedblockstorage.func_76654_b(par1, par2 & 0xF, par3, par5);
        if (flag) {
            this.func_76603_b();
        } else {
            if (this.func_76596_b(par1, par2, par3) > 0) {
                if (par2 >= k1) {
                    this.func_76615_h(par1, par2 + 1, par3);
                }
            } else if (par2 == k1 - 1) {
                this.func_76615_h(par1, par2, par3);
            }
            this.func_76595_e(par1, par3);
        }
        if (par4 != 0) {
            if (!this.field_76637_e.field_72995_K) {
                Block.field_71973_m[par4].func_71861_g(this.field_76637_e, j2, par2, k2);
            }
            if (Block.field_71973_m[par4] != null && Block.field_71973_m[par4].hasTileEntity(par5)) {
                TileEntity tileentity = this.func_76597_e(par1, par2, par3);
                if (tileentity == null) {
                    tileentity = Block.field_71973_m[par4].createTileEntity(this.field_76637_e, par5);
                    this.field_76637_e.func_72837_a(j2, par2, k2, tileentity);
                }
                if (tileentity != null) {
                    tileentity.func_70321_h();
                    tileentity.field_70325_p = par5;
                }
            }
        }
        this.field_76643_l = true;
        return true;
    }

    public boolean func_76589_b(int par1, int par2, int par3, int par4) {
        TileEntity tileentity;
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[par2 >> 4];
        if (extendedblockstorage == null) {
            return false;
        }
        int i1 = extendedblockstorage.func_76665_b(par1, par2 & 0xF, par3);
        if (i1 == par4) {
            return false;
        }
        this.field_76643_l = true;
        extendedblockstorage.func_76654_b(par1, par2 & 0xF, par3, par4);
        int j1 = extendedblockstorage.func_76656_a(par1, par2 & 0xF, par3);
        if (j1 > 0 && Block.field_71973_m[j1] != null && Block.field_71973_m[j1].hasTileEntity(par4) && (tileentity = this.func_76597_e(par1, par2, par3)) != null) {
            tileentity.func_70321_h();
            tileentity.field_70325_p = par4;
        }
        return true;
    }

    public int func_76614_a(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[par3 >> 4];
        return extendedblockstorage == null ? (this.func_76619_d(par2, par3, par4) ? par1EnumSkyBlock.field_77198_c : 0) : (par1EnumSkyBlock == EnumSkyBlock.Sky ? (this.field_76637_e.field_73011_w.field_76576_e ? 0 : extendedblockstorage.func_76670_c(par2, par3 & 0xF, par4)) : (par1EnumSkyBlock == EnumSkyBlock.Block ? extendedblockstorage.func_76674_d(par2, par3 & 0xF, par4) : par1EnumSkyBlock.field_77198_c));
    }

    public void func_76633_a(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4, int par5) {
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[par3 >> 4];
        if (extendedblockstorage == null) {
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(par3 >> 4 << 4, !this.field_76637_e.field_73011_w.field_76576_e);
            this.field_76652_q[par3 >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
            this.func_76603_b();
        }
        this.field_76643_l = true;
        if (par1EnumSkyBlock == EnumSkyBlock.Sky) {
            if (!this.field_76637_e.field_73011_w.field_76576_e) {
                extendedblockstorage.func_76657_c(par2, par3 & 0xF, par4, par5);
            }
        } else if (par1EnumSkyBlock == EnumSkyBlock.Block) {
            extendedblockstorage.func_76677_d(par2, par3 & 0xF, par4, par5);
        }
    }

    public int func_76629_c(int par1, int par2, int par3, int par4) {
        int j1;
        int i1;
        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[par2 >> 4];
        if (extendedblockstorage == null) {
            return !this.field_76637_e.field_73011_w.field_76576_e && par4 < EnumSkyBlock.Sky.field_77198_c ? EnumSkyBlock.Sky.field_77198_c - par4 : 0;
        }
        int n = i1 = this.field_76637_e.field_73011_w.field_76576_e ? 0 : extendedblockstorage.func_76670_c(par1, par2 & 0xF, par3);
        if (i1 > 0) {
            field_76640_a = true;
        }
        if ((j1 = extendedblockstorage.func_76674_d(par1, par2 & 0xF, par3)) > (i1 -= par4)) {
            i1 = j1;
        }
        return i1;
    }

    public void func_76612_a(Entity par1Entity) {
        int k;
        this.field_76644_m = true;
        int i = MathHelper.func_76128_c((double)(par1Entity.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(par1Entity.field_70161_v / 16.0));
        if (i != this.field_76635_g || j != this.field_76647_h) {
            this.field_76637_e.func_98180_V().func_98232_c("Wrong location! " + par1Entity);
            Thread.dumpStack();
        }
        if ((k = MathHelper.func_76128_c((double)(par1Entity.field_70163_u / 16.0))) < 0) {
            k = 0;
        }
        if (k >= this.field_76645_j.length) {
            k = this.field_76645_j.length - 1;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.EnteringChunk(par1Entity, this.field_76635_g, this.field_76647_h, par1Entity.field_70176_ah, par1Entity.field_70164_aj));
        par1Entity.field_70175_ag = true;
        par1Entity.field_70176_ah = this.field_76635_g;
        par1Entity.field_70162_ai = k;
        par1Entity.field_70164_aj = this.field_76647_h;
        this.field_76645_j[k].add(par1Entity);
    }

    public void func_76622_b(Entity par1Entity) {
        this.func_76608_a(par1Entity, par1Entity.field_70162_ai);
    }

    public void func_76608_a(Entity par1Entity, int par2) {
        if (par2 < 0) {
            par2 = 0;
        }
        if (par2 >= this.field_76645_j.length) {
            par2 = this.field_76645_j.length - 1;
        }
        this.field_76645_j[par2].remove(par1Entity);
    }

    public boolean func_76619_d(int par1, int par2, int par3) {
        return par2 >= this.field_76634_f[par3 << 4 | par1];
    }

    public TileEntity func_76597_e(int par1, int par2, int par3) {
        ChunkPosition chunkposition = new ChunkPosition(par1, par2, par3);
        TileEntity tileentity = (TileEntity)this.field_76648_i.get(chunkposition);
        if (tileentity != null && tileentity.func_70320_p()) {
            this.field_76648_i.remove(chunkposition);
            tileentity = null;
        }
        if (tileentity == null) {
            int l = this.func_76610_a(par1, par2, par3);
            int meta = this.func_76628_c(par1, par2, par3);
            if (l <= 0 || !Block.field_71973_m[l].hasTileEntity(meta)) {
                return null;
            }
            if (tileentity == null) {
                tileentity = Block.field_71973_m[l].createTileEntity(this.field_76637_e, meta);
                this.field_76637_e.func_72837_a(this.field_76635_g * 16 + par1, par2, this.field_76647_h * 16 + par3, tileentity);
            }
            tileentity = (TileEntity)this.field_76648_i.get(chunkposition);
        }
        return tileentity;
    }

    public void func_76620_a(TileEntity par1TileEntity) {
        int i = par1TileEntity.field_70329_l - this.field_76635_g * 16;
        int j = par1TileEntity.field_70330_m;
        int k = par1TileEntity.field_70327_n - this.field_76647_h * 16;
        this.func_76604_a(i, j, k, par1TileEntity);
        if (this.field_76636_d) {
            this.field_76637_e.addTileEntity(par1TileEntity);
        }
    }

    public void func_76604_a(int par1, int par2, int par3, TileEntity par4TileEntity) {
        ChunkPosition chunkposition = new ChunkPosition(par1, par2, par3);
        par4TileEntity.func_70308_a(this.field_76637_e);
        par4TileEntity.field_70329_l = this.field_76635_g * 16 + par1;
        par4TileEntity.field_70330_m = par2;
        par4TileEntity.field_70327_n = this.field_76647_h * 16 + par3;
        Block block = Block.field_71973_m[this.func_76610_a(par1, par2, par3)];
        if (block != null && block.hasTileEntity(this.func_76628_c(par1, par2, par3))) {
            if (this.field_76648_i.containsKey(chunkposition)) {
                ((TileEntity)this.field_76648_i.get(chunkposition)).func_70313_j();
            }
            par4TileEntity.func_70312_q();
            this.field_76648_i.put(chunkposition, par4TileEntity);
        }
    }

    public void func_76627_f(int par1, int par2, int par3) {
        TileEntity tileentity;
        ChunkPosition chunkposition = new ChunkPosition(par1, par2, par3);
        if (this.field_76636_d && (tileentity = (TileEntity)this.field_76648_i.remove(chunkposition)) != null) {
            tileentity.func_70313_j();
        }
    }

    public void func_76631_c() {
        this.field_76636_d = true;
        this.field_76637_e.func_72852_a(this.field_76648_i.values());
        for (int i = 0; i < this.field_76645_j.length; ++i) {
            for (Entity entity : this.field_76645_j[i]) {
                entity.func_110123_P();
            }
            this.field_76637_e.func_72868_a(this.field_76645_j[i]);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load(this));
    }

    public void func_76623_d() {
        this.field_76636_d = false;
        for (TileEntity tileentity : this.field_76648_i.values()) {
            this.field_76637_e.func_72928_a(tileentity);
        }
        for (int i = 0; i < this.field_76645_j.length; ++i) {
            this.field_76637_e.func_72828_b(this.field_76645_j[i]);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload(this));
    }

    public void func_76630_e() {
        this.field_76643_l = true;
    }

    public void func_76588_a(Entity par1Entity, AxisAlignedBB par2AxisAlignedBB, List par3List, IEntitySelector par4IEntitySelector) {
        int i = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72338_b - World.MAX_ENTITY_RADIUS) / 16.0));
        int j = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72337_e + World.MAX_ENTITY_RADIUS) / 16.0));
        if (i < 0) {
            i = 0;
            j = Math.max(i, j);
        }
        if (j >= this.field_76645_j.length) {
            j = this.field_76645_j.length - 1;
            i = Math.min(i, j);
        }
        for (int k = i; k <= j; ++k) {
            List list1 = this.field_76645_j[k];
            for (int l = 0; l < list1.size(); ++l) {
                Entity entity1 = (Entity)list1.get(l);
                if (entity1 == par1Entity || !entity1.field_70121_D.func_72326_a(par2AxisAlignedBB) || par4IEntitySelector != null && !par4IEntitySelector.func_82704_a(entity1)) continue;
                par3List.add(entity1);
                Entity[] aentity = entity1.func_70021_al();
                if (aentity == null) continue;
                for (int i1 = 0; i1 < aentity.length; ++i1) {
                    entity1 = aentity[i1];
                    if (entity1 == par1Entity || !entity1.field_70121_D.func_72326_a(par2AxisAlignedBB) || par4IEntitySelector != null && !par4IEntitySelector.func_82704_a(entity1)) continue;
                    par3List.add(entity1);
                }
            }
        }
    }

    public void func_76618_a(Class par1Class, AxisAlignedBB par2AxisAlignedBB, List par3List, IEntitySelector par4IEntitySelector) {
        int i = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72338_b - World.MAX_ENTITY_RADIUS) / 16.0));
        int j = MathHelper.func_76128_c((double)((par2AxisAlignedBB.field_72337_e + World.MAX_ENTITY_RADIUS) / 16.0));
        if (i < 0) {
            i = 0;
        } else if (i >= this.field_76645_j.length) {
            i = this.field_76645_j.length - 1;
        }
        if (j >= this.field_76645_j.length) {
            j = this.field_76645_j.length - 1;
        } else if (j < 0) {
            j = 0;
        }
        for (int k = i; k <= j; ++k) {
            List list1 = this.field_76645_j[k];
            for (int l = 0; l < list1.size(); ++l) {
                Entity entity = (Entity)list1.get(l);
                if (!par1Class.isAssignableFrom(entity.getClass()) || !entity.field_70121_D.func_72326_a(par2AxisAlignedBB) || par4IEntitySelector != null && !par4IEntitySelector.func_82704_a(entity)) continue;
                par3List.add(entity);
            }
        }
    }

    public boolean func_76601_a(boolean par1) {
        if (par1 ? this.field_76644_m && this.field_76637_e.func_82737_E() != this.field_76641_n || this.field_76643_l : this.field_76644_m && this.field_76637_e.func_82737_E() >= this.field_76641_n + 600L) {
            return true;
        }
        return this.field_76643_l;
    }

    public Random func_76617_a(long par1) {
        return new Random(this.field_76637_e.func_72905_C() + (long)(this.field_76635_g * this.field_76635_g * 4987142) + (long)(this.field_76635_g * 5947611) + (long)(this.field_76647_h * this.field_76647_h) * 4392871L + (long)(this.field_76647_h * 389711) ^ par1);
    }

    public boolean func_76621_g() {
        return false;
    }

    public void func_76624_a(IChunkProvider par1IChunkProvider, IChunkProvider par2IChunkProvider, int par3, int par4) {
        if (!this.field_76646_k && par1IChunkProvider.func_73149_a(par3 + 1, par4 + 1) && par1IChunkProvider.func_73149_a(par3, par4 + 1) && par1IChunkProvider.func_73149_a(par3 + 1, par4)) {
            par1IChunkProvider.func_73153_a(par2IChunkProvider, par3, par4);
        }
        if (par1IChunkProvider.func_73149_a(par3 - 1, par4) && !par1IChunkProvider.func_73154_d((int)(par3 - 1), (int)par4).field_76646_k && par1IChunkProvider.func_73149_a(par3 - 1, par4 + 1) && par1IChunkProvider.func_73149_a(par3, par4 + 1) && par1IChunkProvider.func_73149_a(par3 - 1, par4 + 1)) {
            par1IChunkProvider.func_73153_a(par2IChunkProvider, par3 - 1, par4);
        }
        if (par1IChunkProvider.func_73149_a(par3, par4 - 1) && !par1IChunkProvider.func_73154_d((int)par3, (int)(par4 - 1)).field_76646_k && par1IChunkProvider.func_73149_a(par3 + 1, par4 - 1) && par1IChunkProvider.func_73149_a(par3 + 1, par4 - 1) && par1IChunkProvider.func_73149_a(par3 + 1, par4)) {
            par1IChunkProvider.func_73153_a(par2IChunkProvider, par3, par4 - 1);
        }
        if (par1IChunkProvider.func_73149_a(par3 - 1, par4 - 1) && !par1IChunkProvider.func_73154_d((int)(par3 - 1), (int)(par4 - 1)).field_76646_k && par1IChunkProvider.func_73149_a(par3, par4 - 1) && par1IChunkProvider.func_73149_a(par3 - 1, par4)) {
            par1IChunkProvider.func_73153_a(par2IChunkProvider, par3 - 1, par4 - 1);
        }
    }

    public int func_76626_d(int par1, int par2) {
        int k = par1 | par2 << 4;
        int l = this.field_76638_b[k];
        if (l == -999) {
            int i1 = this.func_76625_h() + 15;
            l = -1;
            while (i1 > 0 && l == -1) {
                Material material;
                int j1 = this.func_76610_a(par1, i1, par2);
                Material material2 = material = j1 == 0 ? Material.field_76249_a : Block.field_71973_m[j1].field_72018_cp;
                if (!material.func_76230_c() && !material.func_76224_d()) {
                    --i1;
                    continue;
                }
                l = i1 + 1;
            }
            this.field_76638_b[k] = l;
        }
        return l;
    }

    public void func_76586_k() {
        if (this.field_76650_s && !this.field_76637_e.field_73011_w.field_76576_e) {
            this.func_76593_q();
        }
    }

    public ChunkCoordIntPair func_76632_l() {
        return new ChunkCoordIntPair(this.field_76635_g, this.field_76647_h);
    }

    public boolean func_76606_c(int par1, int par2) {
        if (par1 < 0) {
            par1 = 0;
        }
        if (par2 >= 256) {
            par2 = 255;
        }
        for (int k = par1; k <= par2; k += 16) {
            ExtendedBlockStorage extendedblockstorage = this.field_76652_q[k >> 4];
            if (extendedblockstorage == null || extendedblockstorage.func_76663_a()) continue;
            return false;
        }
        return true;
    }

    public void func_76602_a(ExtendedBlockStorage[] par1ArrayOfExtendedBlockStorage) {
        this.field_76652_q = par1ArrayOfExtendedBlockStorage;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_76607_a(byte[] par1ArrayOfByte, int par2, int par3, boolean par4) {
        NibbleArray nibblearray;
        int l;
        for (TileEntity tileEntity : this.field_76648_i.values()) {
            tileEntity.func_70321_h();
            tileEntity.func_70322_n();
            tileEntity.func_70311_o();
        }
        int k = 0;
        boolean flag1 = !this.field_76637_e.field_73011_w.field_76576_e;
        for (l = 0; l < this.field_76652_q.length; ++l) {
            if ((par2 & 1 << l) != 0) {
                if (this.field_76652_q[l] == null) {
                    this.field_76652_q[l] = new ExtendedBlockStorage(l << 4, flag1);
                }
                byte[] abyte1 = this.field_76652_q[l].func_76658_g();
                System.arraycopy(par1ArrayOfByte, k, abyte1, 0, abyte1.length);
                k += abyte1.length;
                continue;
            }
            if (!par4 || this.field_76652_q[l] == null) continue;
            this.field_76652_q[l] = null;
        }
        for (l = 0; l < this.field_76652_q.length; ++l) {
            if ((par2 & 1 << l) == 0 || this.field_76652_q[l] == null) continue;
            nibblearray = this.field_76652_q[l].func_76669_j();
            System.arraycopy(par1ArrayOfByte, k, nibblearray.field_76585_a, 0, nibblearray.field_76585_a.length);
            k += nibblearray.field_76585_a.length;
        }
        for (l = 0; l < this.field_76652_q.length; ++l) {
            if ((par2 & 1 << l) == 0 || this.field_76652_q[l] == null) continue;
            nibblearray = this.field_76652_q[l].func_76661_k();
            System.arraycopy(par1ArrayOfByte, k, nibblearray.field_76585_a, 0, nibblearray.field_76585_a.length);
            k += nibblearray.field_76585_a.length;
        }
        if (flag1) {
            for (l = 0; l < this.field_76652_q.length; ++l) {
                if ((par2 & 1 << l) == 0 || this.field_76652_q[l] == null) continue;
                nibblearray = this.field_76652_q[l].func_76671_l();
                System.arraycopy(par1ArrayOfByte, k, nibblearray.field_76585_a, 0, nibblearray.field_76585_a.length);
                k += nibblearray.field_76585_a.length;
            }
        }
        for (l = 0; l < this.field_76652_q.length; ++l) {
            if ((par3 & 1 << l) != 0) {
                if (this.field_76652_q[l] == null) {
                    k += 2048;
                    continue;
                }
                nibblearray = this.field_76652_q[l].func_76660_i();
                if (nibblearray == null) {
                    nibblearray = this.field_76652_q[l].func_76667_m();
                }
                System.arraycopy(par1ArrayOfByte, k, nibblearray.field_76585_a, 0, nibblearray.field_76585_a.length);
                k += nibblearray.field_76585_a.length;
                continue;
            }
            if (!par4 || this.field_76652_q[l] == null || this.field_76652_q[l].func_76660_i() == null) continue;
            this.field_76652_q[l].func_76676_h();
        }
        if (par4) {
            System.arraycopy(par1ArrayOfByte, k, this.field_76651_r, 0, this.field_76651_r.length);
            int i1 = k + this.field_76651_r.length;
        }
        for (l = 0; l < this.field_76652_q.length; ++l) {
            if (this.field_76652_q[l] == null || (par2 & 1 << l) == 0) continue;
            this.field_76652_q[l].func_76672_e();
        }
        this.func_76590_a();
        ArrayList<TileEntity> invalidList = new ArrayList<TileEntity>();
        for (TileEntity tileEntity : this.field_76648_i.values()) {
            int x = tileEntity.field_70329_l & 0xF;
            int y = tileEntity.field_70330_m;
            int z = tileEntity.field_70327_n & 0xF;
            Block block = tileEntity.func_70311_o();
            if (block == null || block.field_71990_ca != this.func_76610_a(x, y, z) || tileEntity.func_70322_n() != this.func_76628_c(x, y, z)) {
                invalidList.add(tileEntity);
            }
            tileEntity.func_70321_h();
        }
        for (TileEntity tileEntity : invalidList) {
            tileEntity.func_70313_j();
        }
    }

    public BiomeGenBase func_76591_a(int par1, int par2, WorldChunkManager par3WorldChunkManager) {
        int k = this.field_76651_r[par2 << 4 | par1] & 0xFF;
        if (k == 255) {
            BiomeGenBase biomegenbase = par3WorldChunkManager.func_76935_a((this.field_76635_g << 4) + par1, (this.field_76647_h << 4) + par2);
            k = biomegenbase.field_76756_M;
            this.field_76651_r[par2 << 4 | par1] = (byte)(k & 0xFF);
        }
        return BiomeGenBase.field_76773_a[k] == null ? BiomeGenBase.field_76772_c : BiomeGenBase.field_76773_a[k];
    }

    public byte[] func_76605_m() {
        return this.field_76651_r;
    }

    public void func_76616_a(byte[] par1ArrayOfByte) {
        this.field_76651_r = par1ArrayOfByte;
    }

    public void func_76613_n() {
        this.field_76649_t = 0;
    }

    public void func_76594_o() {
        for (int i = 0; i < 8; ++i) {
            if (this.field_76649_t >= 4096) {
                return;
            }
            int j = this.field_76649_t % 16;
            int k = this.field_76649_t / 16 % 16;
            int l = this.field_76649_t / 256;
            ++this.field_76649_t;
            int i1 = (this.field_76635_g << 4) + k;
            int j1 = (this.field_76647_h << 4) + l;
            for (int k1 = 0; k1 < 16; ++k1) {
                int l1 = (j << 4) + k1;
                if ((this.field_76652_q[j] != null || k1 != 0 && k1 != 15 && k != 0 && k != 15 && l != 0 && l != 15) && (this.field_76652_q[j] == null || this.field_76652_q[j].func_76656_a(k, k1, l) != 0)) continue;
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(i1, l1 - 1, j1)] > 0) {
                    this.field_76637_e.func_72969_x(i1, l1 - 1, j1);
                }
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(i1, l1 + 1, j1)] > 0) {
                    this.field_76637_e.func_72969_x(i1, l1 + 1, j1);
                }
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(i1 - 1, l1, j1)] > 0) {
                    this.field_76637_e.func_72969_x(i1 - 1, l1, j1);
                }
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(i1 + 1, l1, j1)] > 0) {
                    this.field_76637_e.func_72969_x(i1 + 1, l1, j1);
                }
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(i1, l1, j1 - 1)] > 0) {
                    this.field_76637_e.func_72969_x(i1, l1, j1 - 1);
                }
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(i1, l1, j1 + 1)] > 0) {
                    this.field_76637_e.func_72969_x(i1, l1, j1 + 1);
                }
                this.field_76637_e.func_72969_x(i1, l1, j1);
            }
        }
    }

    public void cleanChunkBlockTileEntity(int x, int y, int z) {
        TileEntity entity;
        ChunkPosition position = new ChunkPosition(x, y, z);
        if (this.field_76636_d && (entity = (TileEntity)this.field_76648_i.get(position)) != null && entity.func_70320_p()) {
            this.field_76648_i.remove(position);
        }
    }
}

