/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.render;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.render.world.RenderGlobalProxy;
import me.ichun.mods.ichunutil.common.core.util.ResourceHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RendererHelper {
    private static boolean canUseStencils;
    private static Random lightningRand;
    public static HashSet<Framebuffer> frameBuffers;
    public static HashSet<RenderGlobalProxy> renderGlobalProxies;

    public static void init() {
        canUseStencils = Minecraft.func_71410_x().func_147110_a().isStencilEnabled();
        if (iChunUtil.config.enableStencils == 1 && !canUseStencils) {
            canUseStencils = Minecraft.func_71410_x().func_147110_a().enableStencil();
        }
        lightningRand = new Random();
    }

    public static boolean canUseStencils() {
        return canUseStencils;
    }

    public static void spawnParticle(Particle particle) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static Vec3d getCameraPosition(Entity viewer, float partialTicks) {
        Vec3d position = new Vec3d(viewer.field_70165_t, viewer.field_70163_u + (double)viewer.func_70047_e(), viewer.field_70161_v);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O > 0) {
            double d3 = mc.field_71460_t.field_78491_C + (4.0f - mc.field_71460_t.field_78491_C) * partialTicks;
            if (!mc.field_71474_y.field_74325_U) {
                double d0 = viewer.field_70169_q + (viewer.field_70165_t - viewer.field_70169_q) * (double)partialTicks;
                double d1 = viewer.field_70167_r + (viewer.field_70163_u - viewer.field_70167_r) * (double)partialTicks;
                double d2 = viewer.field_70166_s + (viewer.field_70161_v - viewer.field_70166_s) * (double)partialTicks;
                float f1 = viewer.field_70177_z;
                float f2 = viewer.field_70125_A;
                if (mc.field_71474_y.field_74320_O == 2) {
                    f2 += 180.0f;
                }
                double d4 = (double)(-MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
                double d5 = (double)(MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
                double d6 = (double)(-MathHelper.func_76126_a((float)(f2 * ((float)Math.PI / 180)))) * d3;
                for (int i = 0; i < 8; ++i) {
                    double d7;
                    RayTraceResult raytraceresult;
                    float f3 = (i & 1) * 2 - 1;
                    float f4 = (i >> 1 & 1) * 2 - 1;
                    float f5 = (i >> 2 & 1) * 2 - 1;
                    if ((raytraceresult = mc.field_71441_e.func_72933_a(new Vec3d(d0 + (double)(f3 *= 0.1f), d1 + (double)(f4 *= 0.1f), d2 + (double)(f5 *= 0.1f)), new Vec3d(d0 - d4 + (double)f3 + (double)f5, d1 - d6 + (double)f4, d2 - d5 + (double)f5))) == null || !((d7 = raytraceresult.field_72307_f.func_72438_d(new Vec3d(d0, d1, d2))) < d3)) continue;
                    d3 = d7;
                }
                if (mc.field_71474_y.field_74320_O == 2) {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                position = position.func_72441_c(-d4, -d6, -d5);
            }
        }
        return position;
    }

    public static void renderBakedModel(IBakedModel model, int color, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (model.func_188618_c() && stack != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            TileEntityItemStackRenderer.field_147719_a.func_179022_a(stack);
        } else {
            RendererHelper.renderModel(model, color, stack);
            if (stack != null && stack.func_77973_b() != null && stack.func_77962_s()) {
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179143_c((int)514);
                GlStateManager.func_179140_f();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                mc.func_110434_K().func_110577_a(ResourceHelper.texGlint);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
                float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
                GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RendererHelper.renderModel(model, -8372020, null);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
                float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
                GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RendererHelper.renderModel(model, -8372020, null);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179145_e();
                GlStateManager.func_179143_c((int)515);
                GlStateManager.func_179132_a((boolean)true);
                mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private static void renderModel(IBakedModel model, int color, @Nullable ItemStack stack) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            RendererHelper.renderQuads(vertexbuffer, model.func_188616_a((IBlockState)null, enumfacing, 0L), color, stack);
        }
        RendererHelper.renderQuads(vertexbuffer, model.func_188616_a((IBlockState)null, (EnumFacing)null, 0L), color, stack);
        tessellator.func_78381_a();
    }

    private static void renderQuads(VertexBuffer renderer, List<BakedQuad> quads, int color, @Nullable ItemStack stack) {
        boolean flag = color == -1 && stack != null;
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((VertexBuffer)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    public static void renderSinLight(double distance, double size, double startAngle, double angleFactor, boolean droppingIntensity, int clr) {
        float r = (float)(clr >> 16 & 0xFF) / 255.0f;
        float g = (float)(clr >> 8 & 0xFF) / 255.0f;
        float b = (float)(clr & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        vertexbuffer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        float max = (float)distance * 10.0f;
        double halfSize = size / 2.0;
        for (float f = 0.0f; f < max; f += 1.0f) {
            vertexbuffer.func_181662_b(-halfSize, distance * (double)(f / max), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(halfSize, distance * (double)(f / max), 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
    }

    public static void renderLighting(double x, double y, double z, int randSeed, int bends, int spread, double heightOfBend, int layerCount, double layerSize, float intensity, int clr) {
        float r = (float)(clr >> 16 & 0xFF) / 255.0f;
        float g = (float)(clr >> 8 & 0xFF) / 255.0f;
        float b = (float)(clr & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        double[] adouble = new double[bends];
        double[] adouble1 = new double[bends];
        double d3 = 0.0;
        double d4 = 0.0;
        lightningRand.setSeed(randSeed);
        for (int i = bends - 1; i >= 0; --i) {
            adouble[i] = d3;
            adouble1[i] = d4;
            d3 += (double)(lightningRand.nextInt(spread * 2 + 1) - spread);
            d4 += (double)(lightningRand.nextInt(spread * 2 + 1) - spread);
        }
        for (int layers = 0; layers < layerCount; ++layers) {
            Random random1 = new Random(randSeed);
            int k = bends - 1;
            int l = 0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (int i1 = k; i1 >= l; --i1) {
                double d7 = d5;
                double d8 = d6;
                d5 += (double)(random1.nextInt(spread * 2 + 1) - spread);
                d6 += (double)(random1.nextInt(spread * 2 + 1) - spread);
                if (i1 == l) {
                    d5 = 0.0;
                    d6 = 0.0;
                }
                vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
                double d9 = 0.1 + (double)layers * layerSize;
                d9 *= (double)i1 * 0.1 + 0.5;
                double d10 = 0.1 + (double)layers * layerSize;
                d10 *= (double)(i1 - 1) * 0.1 + 0.5;
                for (int j1 = 0; j1 < 5; ++j1) {
                    double d11 = x + 0.5 - d9;
                    double d12 = z + 0.5 - d9;
                    if (j1 == 1 || j1 == 2) {
                        d11 += d9 * 2.0;
                    }
                    if (j1 == 2 || j1 == 3) {
                        d12 += d9 * 2.0;
                    }
                    double d13 = x + 0.5 - d10;
                    double d14 = z + 0.5 - d10;
                    if (j1 == 1 || j1 == 2) {
                        d13 += d10 * 2.0;
                    }
                    if (j1 == 2 || j1 == 3) {
                        d14 += d10 * 2.0;
                    }
                    vertexbuffer.func_181662_b(d13 + d5, y + (double)i1 * heightOfBend, d14 + d6).func_181666_a(r * intensity, g * intensity, b * intensity, 0.3f).func_181675_d();
                    vertexbuffer.func_181662_b(d11 + d7, y + (double)(i1 + 1) * heightOfBend, d12 + d8).func_181666_a(r * intensity, g * intensity, b * intensity, 0.3f).func_181675_d();
                }
                tessellator.func_78381_a();
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
    }

    public static void setColorFromInt(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void setColorFromInt(int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)alpha);
    }

    public static void drawTextureOnScreen(ResourceLocation resource, double posX, double posY, double width, double height, double zLevel) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        RendererHelper.drawOnScreen(posX, posY, width, height, zLevel);
    }

    public static void drawOnScreen(double posX, double posY, double width, double height, double zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(posX, posY + height, zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b(posX + width, posY + height, zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b(posX + width, posY, zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b(posX, posY, zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawColourOnScreen(int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        RendererHelper.drawColourOnScreen(r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColourOnScreen(int r, int g, int b, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b(posX, posY + height, zLevel).func_181669_b(r, g, b, alpha).func_181675_d();
        vertexbuffer.func_181662_b(posX + width, posY + height, zLevel).func_181669_b(r, g, b, alpha).func_181675_d();
        vertexbuffer.func_181662_b(posX + width, posY, zLevel).func_181669_b(r, g, b, alpha).func_181675_d();
        vertexbuffer.func_181662_b(posX, posY, zLevel).func_181669_b(r, g, b, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static void drawGradientOnScreen(int downLeft, int downRight, int upLeft, int upRight, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int alpha = downLeft >> 24 & 0xFF;
        int r = downLeft >> 16 & 0xFF;
        int g = downLeft >> 8 & 0xFF;
        int b = downLeft & 0xFF;
        vertexbuffer.func_181662_b(posX, posY + height, zLevel).func_181669_b(r, g, b, alpha).func_181675_d();
        alpha = downRight >> 24 & 0xFF;
        r = downRight >> 16 & 0xFF;
        g = downRight >> 8 & 0xFF;
        b = downRight & 0xFF;
        vertexbuffer.func_181662_b(posX + width, posY + height, zLevel).func_181669_b(r, g, b, alpha).func_181675_d();
        alpha = upRight >> 24 & 0xFF;
        r = upRight >> 16 & 0xFF;
        g = upRight >> 8 & 0xFF;
        b = upRight & 0xFF;
        vertexbuffer.func_181662_b(posX + width, posY, zLevel).func_181669_b(r, g, b, alpha).func_181675_d();
        alpha = upLeft >> 24 & 0xFF;
        r = upLeft >> 16 & 0xFF;
        g = upLeft >> 8 & 0xFF;
        b = upLeft & 0xFF;
        vertexbuffer.func_181662_b(posX, posY, zLevel).func_181669_b(r, g, b, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawHueStripOnScreen(int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        double sHeight = height / 6.0;
        int[][] colourArray = new int[][]{{255, 0, 0}, {255, 0, 255}, {0, 0, 255}, {0, 255, 255}, {0, 255, 0}, {255, 255, 0}, {255, 0, 0}};
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        for (int i = 0; i < 6; ++i) {
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            vertexbuffer.func_181662_b(posX, posY + sHeight * (double)(i + 1), zLevel).func_181669_b(colourArray[i + 1][0], colourArray[i + 1][1], colourArray[i + 1][2], alpha).func_181675_d();
            vertexbuffer.func_181662_b(posX + width, posY + sHeight * (double)(i + 1), zLevel).func_181669_b(colourArray[i + 1][0], colourArray[i + 1][1], colourArray[i + 1][2], alpha).func_181675_d();
            vertexbuffer.func_181662_b(posX + width, posY + sHeight * (double)i, zLevel).func_181669_b(colourArray[i][0], colourArray[i][1], colourArray[i][2], alpha).func_181675_d();
            vertexbuffer.func_181662_b(posX, posY + sHeight * (double)i, zLevel).func_181669_b(colourArray[i][0], colourArray[i][1], colourArray[i][2], alpha).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso = new ScaledResolution(mc);
        double scaleW = (double)mc.field_71443_c / reso.func_78327_c();
        double scaleH = (double)mc.field_71440_d / reso.func_78324_d();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.field_71440_d - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.field_71440_d - (double)y * scaleH) - (int)Math.floor((double)mc.field_71440_d - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        GL11.glDisable((int)3089);
    }

    public static void renderTestStencil() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso = new ScaledResolution(mc);
        GL11.glEnable((int)2960);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179132_a((boolean)false);
        GL11.glStencilFunc((int)512, (int)1, (int)255);
        GL11.glStencilOp((int)7681, (int)7680, (int)7680);
        GL11.glStencilMask((int)255);
        GlStateManager.func_179086_m((int)1024);
        RendererHelper.drawColourOnScreen(0xFFFFFF, 255, 0.0, 0.0, 60.0, 60.0, 0.0);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179132_a((boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)0, (int)255);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        RendererHelper.drawColourOnScreen(0xFFFFFF, 255, 0.0, 0.0, reso.func_78327_c(), reso.func_78324_d(), 0.0);
        GL11.glDisable((int)2960);
    }

    public static void renderTestScissor() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso1 = new ScaledResolution(mc);
        RendererHelper.startGlScissor(reso1.func_78326_a() / 2 - 50, reso1.func_78328_b() / 2 - 50, 100, 100);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-15.0f, (float)15.0f, (float)0.0f);
        RendererHelper.drawColourOnScreen(0xFFFFFF, 255, 0.0, 0.0, reso1.func_78327_c(), reso1.func_78324_d(), 0.0);
        GlStateManager.func_179121_F();
        RendererHelper.endGlScissor();
    }

    public static Framebuffer createFrameBuffer(boolean useDepth, boolean useStencil) {
        Framebuffer render = new Framebuffer(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d, useDepth);
        if (useStencil && RendererHelper.canUseStencils()) {
            render.enableStencil();
        }
        frameBuffers.add(render);
        return render;
    }

    public static void deleteFrameBuffer(Framebuffer buffer) {
        if (buffer.field_147616_f >= 0) {
            buffer.func_147608_a();
        }
        frameBuffers.remove(buffer);
    }

    public static RenderGlobalProxy requestRenderGlobalProxy() {
        RenderGlobalProxy proxy = null;
        for (RenderGlobalProxy pooledProxy : renderGlobalProxies) {
            if (!pooledProxy.released) continue;
            proxy = pooledProxy;
            proxy.released = false;
            break;
        }
        if (proxy == null) {
            proxy = new RenderGlobalProxy(Minecraft.func_71410_x());
            renderGlobalProxies.add(proxy);
        }
        if (iChunUtil.eventHandlerClient.getRenderGlobalWorldInstance() != null) {
            proxy.func_72732_a(iChunUtil.eventHandlerClient.getRenderGlobalWorldInstance());
        }
        return proxy;
    }

    public static void releaseRenderGlobalProxy(RenderGlobalProxy proxy) {
        proxy.released = true;
        proxy.func_72732_a(null);
    }

    static {
        frameBuffers = new HashSet();
        renderGlobalProxies = new HashSet();
    }
}

