/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.item;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.common.item.DualHandedItemCallback;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;

public class ItemHandler {
    public static HashMap<Class<? extends Item>, DualHandedItemCallback> dualHandedItems = new HashMap();

    public static void registerDualHandedItem(@Nonnull Class<? extends Item> clz, DualHandedItemCallback itemCallback) {
        dualHandedItems.put(clz, itemCallback != null ? itemCallback : DualHandedItemCallback.DEFAULT);
    }

    public static void registerDualHandedItem(@Nonnull Class<? extends Item> clz) {
        ItemHandler.registerDualHandedItem(clz, null);
    }

    public static DualHandedItemCallback getDualHandedItemCallback(ItemStack is) {
        for (Map.Entry<Class<? extends Item>, DualHandedItemCallback> e : dualHandedItems.entrySet()) {
            if (!e.getKey().isInstance(is.func_77973_b())) continue;
            return e.getValue();
        }
        return DualHandedItemCallback.DEFAULT;
    }

    public static boolean isItemDualHanded(ItemStack is) {
        for (Map.Entry<Class<? extends Item>, DualHandedItemCallback> e : dualHandedItems.entrySet()) {
            if (!e.getKey().isInstance(is.func_77973_b())) continue;
            return e.getValue().isItemDualHanded(is);
        }
        return false;
    }

    public static boolean canItemBeUsed(EntityLivingBase living, ItemStack is) {
        return is != null && (!ItemHandler.isItemDualHanded(is) || ItemHandler.getDualHandedItemCallback(is).canItemBeUsed(is, living) && (living.func_184586_b(EnumHand.MAIN_HAND) == is && living.func_184586_b(EnumHand.OFF_HAND) == null || living.func_184586_b(EnumHand.OFF_HAND) == is && living.func_184586_b(EnumHand.MAIN_HAND) == null));
    }

    public static ItemStack getUsableDualHandedItem(EntityLivingBase living) {
        ItemStack is = living.func_184586_b(EnumHand.MAIN_HAND);
        if (is != null && ItemHandler.isItemDualHanded(is) && ItemHandler.canItemBeUsed(living, is)) {
            return is;
        }
        is = living.func_184586_b(EnumHand.OFF_HAND);
        if (is != null && ItemHandler.isItemDualHanded(is) && ItemHandler.canItemBeUsed(living, is)) {
            return is;
        }
        return null;
    }

    public static EnumHandSide getHandSide(EntityLivingBase living, ItemStack is) {
        return living.func_184586_b(EnumHand.OFF_HAND) == is ? living.func_184591_cq().func_188468_a() : living.func_184591_cq();
    }
}

