/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.module.worldportals.common.core;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import me.ichun.mods.ichunutil.common.module.worldportals.common.portal.WorldPortal;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EventHandlerWorldPortal {
    public EnumMap<Side, HashMap<Entity, HashSet<WorldPortal>>> monitoredEntities = new EnumMap<Side, HashMap<Entity, HashSet<WorldPortal>>>(Side.class){
        {
            this.put(Side.SERVER, new HashMap());
            this.put(Side.CLIENT, new HashMap());
        }
    };

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getSource() == DamageSource.field_76368_d && this.isInPortal(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        Iterator<Map.Entry<Entity, HashSet<WorldPortal>>> monitored = this.monitoredEntities.get(event.getWorld().field_72995_K ? Side.CLIENT : Side.SERVER).entrySet().iterator();
        while (monitored.hasNext()) {
            Map.Entry<Entity, HashSet<WorldPortal>> e = monitored.next();
            if (e.getKey().func_130014_f_() != event.getWorld()) continue;
            monitored.remove();
        }
    }

    @SubscribeEvent
    public void onGetCollisionBoxesEvent(GetCollisionBoxesEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        HashMap<Entity, HashSet<WorldPortal>> sideMap = this.monitoredEntities.get(event.getEntity().field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
        if (sideMap.containsKey(event.getEntity())) {
            HashSet<WorldPortal> portals = sideMap.get(event.getEntity());
            HashSet<WorldPortal> invalid = new HashSet<WorldPortal>();
            for (WorldPortal portal : portals) {
                if (!portal.isValid()) {
                    invalid.add(portal);
                    continue;
                }
                AxisAlignedBB check = portal.getCollisionRemovalAabbForEntity(event.getEntity());
                if (!check.func_72326_a(event.getAabb())) continue;
                if (event.getAabb().equals((Object)event.getEntity().func_174813_aQ())) {
                    event.getCollisionBoxesList().clear();
                    continue;
                }
                for (int i = event.getCollisionBoxesList().size() - 1; i >= 0; --i) {
                    AxisAlignedBB aabb = (AxisAlignedBB)event.getCollisionBoxesList().get(i);
                    boolean flag = false;
                    for (AxisAlignedBB portalBorder : portal.getCollisionBoundaries()) {
                        if (!portalBorder.equals((Object)aabb)) continue;
                        flag = true;
                        break;
                    }
                    if (flag || !aabb.func_72326_a(check)) continue;
                    event.getCollisionBoxesList().remove(i);
                }
            }
            portals.removeAll(invalid);
        }
    }

    public void addMonitoredEntity(Entity ent, WorldPortal portal) {
        HashMap<Entity, HashSet<WorldPortal>> sideMap = this.monitoredEntities.get(ent.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
        HashSet<WorldPortal> portals = sideMap.get(ent);
        if (portals == null) {
            portals = new HashSet();
            sideMap.put(ent, portals);
        }
        portals.add(portal);
    }

    public void removeMonitoredEntity(Entity ent, WorldPortal portal) {
        HashMap<Entity, HashSet<WorldPortal>> sideMap = this.monitoredEntities.get(ent.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
        HashSet<WorldPortal> portals = sideMap.get(ent);
        if (portals != null) {
            portals.remove(portal);
            if (portals.isEmpty()) {
                sideMap.remove(ent);
            }
        }
    }

    public boolean isInPortal(Entity ent) {
        HashMap<Entity, HashSet<WorldPortal>> sideMap = this.monitoredEntities.get(ent.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
        if (sideMap.containsKey(ent)) {
            HashSet<WorldPortal> portals = sideMap.get(ent);
            for (WorldPortal portal : portals) {
                AxisAlignedBB check;
                if (!portal.isValid() || !(check = portal.getCollisionRemovalAabbForEntity(ent)).func_72326_a(ent.func_174813_aQ())) continue;
                return true;
            }
        }
        return false;
    }
}

