/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import us.ichun.mods.ichunutil.client.gui.ISlider;

@SideOnly(value=Side.CLIENT)
public class GuiSlider
extends GuiButton {
    public double sliderValue = 1.0;
    public String dispString = "";
    public boolean dragging = false;
    public boolean showDecimal = true;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    public ISlider parent = null;
    public String suffix = "";
    public boolean drawString = true;

    public GuiSlider(int id, int xPos, int yPos, int length, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, ISlider par) {
        super(id, xPos, yPos, length, 20, prefix);
        String val;
        this.minValue = minVal;
        this.maxValue = maxVal;
        if (currentVal < this.minValue) {
            currentVal = this.minValue;
        } else if (currentVal > this.maxValue) {
            currentVal = this.maxValue;
        }
        this.sliderValue = (currentVal - this.minValue) / (this.maxValue - this.minValue);
        this.dispString = prefix;
        this.parent = par;
        this.suffix = suf;
        this.showDecimal = showDec;
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            if (val.length() > 4) {
                if ((val = val.substring(0, 4)).endsWith(".")) {
                    val = val.substring(0, 3);
                }
            } else {
                while (val.length() < 4) {
                    val = val + "0";
                }
            }
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
        }
        this.field_146126_j = this.dispString + val + this.suffix;
        this.drawString = drawStr;
        if (!this.drawString) {
            this.field_146126_j = "";
        }
    }

    public GuiSlider(int id, int xPos, int yPos, String displayStr, double minVal, double maxVal, double currentVal, ISlider par) {
        this(id, xPos, yPos, 150, displayStr, "", minVal, maxVal, currentVal, true, true, par);
    }

    public int func_146114_a(boolean par1) {
        return 0;
    }

    protected void func_146119_b(Minecraft par1Minecraft, int par2, int par3) {
        if (this.field_146125_m) {
            if (this.dragging) {
                this.sliderValue = (float)(par2 - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.updateSlider();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        if (super.func_146116_c(par1Minecraft, par2, par3)) {
            this.sliderValue = (float)(par2 - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            this.updateSlider();
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void updateSlider() {
        String val;
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            if (val.length() > 4) {
                if ((val = val.substring(0, 4)).endsWith(".")) {
                    val = val.substring(0, 3);
                }
            } else {
                while (val.length() < 4) {
                    val = val + "0";
                }
            }
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
        }
        if (this.drawString) {
            this.field_146126_j = this.dispString + val + this.suffix;
        }
        this.parent.onChangeSliderValue(this);
    }

    public void func_146118_a(int par1, int par2) {
        this.dragging = false;
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public double getValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int k = this.func_146114_a(this.field_146123_n);
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)this.field_146128_h, (int)this.field_146129_i, (int)0, (int)(46 + k * 20), (int)this.field_146120_f, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            this.func_146119_b(mc, mouseX, mouseY);
            int color = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                color = this.packedFGColour;
            } else if (!this.field_146124_l) {
                color = 0xA0A0A0;
            } else if (this.field_146123_n) {
                color = 0xFFFFA0;
            }
            String buttonText = this.field_146126_j;
            int strWidth = mc.field_71466_p.func_78256_a(buttonText);
            int ellipsisWidth = mc.field_71466_p.func_78256_a("...");
            if (strWidth > this.field_146120_f - 6 && strWidth > ellipsisWidth) {
                buttonText = mc.field_71466_p.func_78269_a(buttonText, this.field_146120_f - 6 - ellipsisWidth).trim() + "...";
            }
            this.func_73732_a(mc.field_71466_p, buttonText, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, color);
        }
    }
}

