/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.client.gui.window;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import us.ichun.mods.ichunutil.client.gui.Theme;
import us.ichun.mods.ichunutil.client.gui.window.Window;
import us.ichun.mods.ichunutil.client.gui.window.WindowTabs;
import us.ichun.mods.ichunutil.client.gui.window.element.Element;
import us.ichun.mods.ichunutil.client.gui.window.element.ElementWindow;
import us.ichun.mods.ichunutil.client.gui.window.element.ITextInput;
import us.ichun.mods.ichunutil.client.render.RendererHelper;

public abstract class IWorkspace
extends GuiScreen {
    public int oldWidth;
    public int oldHeight;
    public int liveTime;
    public boolean resize;
    public Element elementHovered;
    public int hoverTime;
    public boolean hovering;
    public int tooltipTime = 20;
    public Element elementDragged;
    public int elementDragX;
    public int elementDragY;
    public Element elementSelected;
    public int selectedMouseX;
    public int selectedMouseY;
    public Window windowDragged;
    public int dragType;
    public boolean mouseLeftDown;
    public boolean mouseRightDown;
    public boolean mouseMiddleDown;
    public int VARIABLE_LEVEL = 4;
    public int TOP_DOCK_HEIGHT = 19;
    public Theme currentTheme = Theme.copyInstance();
    public ArrayList<ArrayList<Window>> levels = new ArrayList();

    public abstract boolean canClickOnElement(Window var1, Element var2);

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.resize = true;
        this.screenResize();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_73876_c() {
        if (this.resize) {
            this.resize = false;
            this.screenResize();
        }
        if (this.elementHovered != null) {
            ++this.hoverTime;
        }
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            if (this.levels.get(i).isEmpty() && i >= this.VARIABLE_LEVEL) {
                this.levels.remove(i);
                continue;
            }
            for (int j = this.levels.get(i).size() - 1; j >= 0; --j) {
                this.levels.get(i).get(j).update();
            }
        }
        ++this.liveTime;
    }

    public boolean drawWindows(int mouseX, int mouseY) {
        this.hovering = false;
        boolean hasClicked = false;
        boolean onWindow = false;
        Element prevElementSelected = this.elementSelected;
        this.elementSelected = null;
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            for (int j = this.levels.get(i).size() - 1; j >= 0; --j) {
                Window window = this.levels.get(i).get(j);
                if (mouseX >= window.posX && mouseX <= window.posX + window.getWidth() && mouseY >= window.posY && mouseY <= window.posY + window.getHeight()) {
                    onWindow = true;
                    if (!hasClicked && this.liveTime > 5) {
                        if (Mouse.isButtonDown((int)0) && !this.mouseLeftDown) {
                            this.windowDragged = window;
                            this.dragType = window.onClick(mouseX - window.posX, mouseY - window.posY, 0);
                            hasClicked = true;
                        }
                        if (Mouse.isButtonDown((int)1) && !this.mouseRightDown) {
                            this.windowDragged = window;
                            this.dragType = window.onClick(mouseX - window.posX, mouseY - window.posY, 1);
                            hasClicked = true;
                        }
                        if (Mouse.isButtonDown((int)2) && !this.mouseMiddleDown) {
                            this.windowDragged = window;
                            this.dragType = window.onClick(mouseX - window.posX, mouseY - window.posY, 2);
                            hasClicked = true;
                        }
                    }
                }
                window.draw(mouseX - window.posX, mouseY - window.posY);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
        }
        RendererHelper.endGlScissor();
        if (!hasClicked) {
            if ((Mouse.isButtonDown((int)0) && !this.mouseLeftDown || Mouse.isButtonDown((int)1) && !this.mouseRightDown || Mouse.isButtonDown((int)2) && !this.mouseMiddleDown) && prevElementSelected != null && (mouseX < prevElementSelected.getPosX() || mouseX > prevElementSelected.getPosX() + prevElementSelected.width || mouseY < prevElementSelected.getPosY() || mouseY > prevElementSelected.getPosY() + prevElementSelected.height)) {
                prevElementSelected.deselected();
            } else {
                this.elementSelected = prevElementSelected;
            }
        } else if (this.elementSelected != prevElementSelected) {
            if (this.elementSelected != null) {
                this.elementSelected.selected();
                if (this.elementSelected instanceof ITextInput) {
                    this.elementSelected.onClick(this.selectedMouseX, this.selectedMouseY, 0);
                }
            }
            if (prevElementSelected != null) {
                prevElementSelected.deselected();
            }
        } else {
            this.elementSelected = prevElementSelected;
        }
        return onWindow;
    }

    public void updateElementHovered(int mouseX, int mouseY, int scroll) {
        if (!this.hovering) {
            this.elementHovered = null;
            this.hoverTime = 0;
        } else if (this.elementHovered != null) {
            boolean activated = false;
            if (scroll != 0) {
                activated = this.elementHovered.mouseScroll(mouseX - this.elementHovered.parent.posX, mouseY - this.elementHovered.parent.posY, Math.round(scroll / 120));
            }
            if (activated) {
                if (this.elementSelected != null) {
                    this.elementSelected.deselected();
                }
                this.elementHovered.onClick(mouseX - this.elementHovered.parent.posX, mouseY - this.elementHovered.parent.posY, 2);
                this.elementSelected = this.elementHovered;
            }
            String tooltip = this.elementHovered.tooltip();
            if (this.hoverTime > this.tooltipTime && tooltip != null) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(20.0f * (float)this.levels.size()));
                ArrayList<String> tips = Splitter.on((String)"\n").splitToList((CharSequence)tooltip);
                List<Object> tipss = Splitter.on((String)"\\n").splitToList((CharSequence)tooltip);
                tips = new ArrayList<String>(tipss.size() > tips.size() ? tipss : tips);
                if (tips.size() == 1) {
                    tips.add(StatCollector.func_74838_a((String)((String)tips.get(0))));
                    tips.remove(0);
                }
                int xOffset = 5;
                int yOffset = 20;
                int longest = 0;
                for (String tip : tips) {
                    int length = this.field_146289_q.func_78256_a(tip);
                    if (length <= longest) continue;
                    longest = length;
                }
                int size = longest + 4;
                int ySize = 1 + tips.size() * (this.field_146289_q.field_78288_b + 1);
                if (this.field_146294_l - mouseX < size) {
                    xOffset -= size - (this.field_146294_l - mouseX) + 20;
                }
                if (this.field_146295_m - (mouseY + ySize + yOffset) < 0) {
                    yOffset = -20;
                }
                RendererHelper.drawColourOnScreen(this.currentTheme.windowBorder[0], this.currentTheme.windowBorder[1], this.currentTheme.windowBorder[2], 255, mouseX + xOffset, mouseY + yOffset, longest + 4, ySize, 0.0);
                RendererHelper.drawColourOnScreen(this.currentTheme.windowBackground[0], this.currentTheme.windowBackground[1], this.currentTheme.windowBackground[2], 255, mouseX + xOffset + 1, mouseY + yOffset + 1, longest + 4 - 2, ySize - 2, 0.0);
                for (int i = 0; i < tips.size(); ++i) {
                    this.field_146289_q.func_175065_a((String)tips.get(i), (float)(mouseX + xOffset + 2), (float)(mouseY + yOffset + 2 + i * (this.field_146289_q.field_78288_b + 1)), Theme.getAsHex(this.currentTheme.font), false);
                }
            }
        }
    }

    public void updateWindowDragged(int mouseX, int mouseY) {
        if (this.windowDragged != null) {
            if (this.windowDragged.clickId == 0 && !this.mouseLeftDown || this.windowDragged.clickId == 1 && !this.mouseRightDown || this.windowDragged.clickId == 2 && !this.mouseMiddleDown) {
                this.windowDragged = null;
            } else {
                this.bringWindowToFront(this.windowDragged);
                if (this.dragType == 1) {
                    if (this.windowDragged.canBeDragged()) {
                        int moveX = this.windowDragged.clickX - (mouseX - this.windowDragged.posX);
                        int moveY = this.windowDragged.clickY - (mouseY - this.windowDragged.posY);
                        if (this.windowDragged.docked < 0) {
                            this.windowDragged.posX -= moveX;
                            this.windowDragged.posY -= moveY;
                        } else if (Math.sqrt(moveX * moveX + moveY + moveY) > 5.0) {
                            this.removeFromDock(this.windowDragged);
                            this.windowDragged.posX -= moveX;
                            this.windowDragged.posY -= moveY;
                        }
                        boolean tabbed = false;
                        for (int i = this.levels.size() - 1; i >= 0; --i) {
                            for (int j = this.levels.get(i).size() - 1; j >= 0; --j) {
                                Window window = this.levels.get(i).get(j);
                                if (tabbed || !window.canBeDragged() || window == this.windowDragged || mouseX - window.posX < 0 || mouseX - window.posX > window.getWidth() || mouseY - window.posY < 0 || mouseY - window.posY > 12) continue;
                                WindowTabs tabs = window instanceof WindowTabs ? (WindowTabs)window : new WindowTabs(this, window);
                                if (this.windowDragged.minimized) {
                                    this.windowDragged.toggleMinimize();
                                }
                                tabs.addWindow(this.windowDragged, true);
                                this.levels.get(i).remove(j);
                                this.levels.get(i).add(j, tabs);
                                if (i < this.VARIABLE_LEVEL) {
                                    this.redock(i, null);
                                }
                                this.removeWindow(this.windowDragged);
                                this.windowDragged = null;
                                tabbed = true;
                            }
                        }
                        if (mouseX <= 10) {
                            this.addToDock(0, this.windowDragged);
                            this.windowDragged = null;
                        }
                        if (mouseX >= this.field_146294_l - 10) {
                            this.addToDock(1, this.windowDragged);
                            this.windowDragged = null;
                        }
                    }
                    if (this.windowDragged != null) {
                        this.windowDragged.resized();
                    }
                }
                if (this.dragType >= 2) {
                    int resize;
                    int bordersClicked = this.dragType - 3;
                    if ((bordersClicked & 1) == 1 && (this.windowDragged.docked != 0 && this.windowDragged.docked != 1 || this.levels.get(this.windowDragged.docked).isEmpty() || this.levels.get(this.windowDragged.docked).get(0) != this.windowDragged)) {
                        this.windowDragged.height += this.windowDragged.clickY - (mouseY - this.windowDragged.posY);
                        this.windowDragged.posY -= this.windowDragged.clickY - (mouseY - this.windowDragged.posY);
                        if (this.windowDragged.getHeight() < this.windowDragged.minHeight) {
                            resize = this.windowDragged.getHeight() - this.windowDragged.minHeight;
                            this.windowDragged.posY += resize;
                            this.windowDragged.height -= resize;
                        } else {
                            this.windowDragged.clickY = mouseY - this.windowDragged.posY;
                        }
                    }
                    if ((bordersClicked >> 1 & 1) == 1 && this.windowDragged.docked != 0) {
                        this.windowDragged.width += this.windowDragged.clickX - (mouseX - this.windowDragged.posX);
                        this.windowDragged.posX -= this.windowDragged.clickX - (mouseX - this.windowDragged.posX);
                        if (this.windowDragged.getWidth() < this.windowDragged.minWidth) {
                            resize = this.windowDragged.getWidth() - this.windowDragged.minWidth;
                            this.windowDragged.posX += resize;
                            this.windowDragged.width -= resize;
                        } else {
                            this.windowDragged.clickX = mouseX - this.windowDragged.posX;
                        }
                    }
                    if ((bordersClicked >> 2 & 1) == 1) {
                        this.windowDragged.height -= this.windowDragged.clickY - (mouseY - this.windowDragged.posY);
                        if (this.windowDragged.getHeight() < this.windowDragged.minHeight) {
                            this.windowDragged.height = this.windowDragged.minHeight;
                        } else {
                            this.windowDragged.clickY = mouseY - this.windowDragged.posY;
                        }
                    }
                    if ((bordersClicked >> 3 & 1) == 1 && this.windowDragged.docked != 1) {
                        this.windowDragged.width -= this.windowDragged.clickX - (mouseX - this.windowDragged.posX);
                        if (this.windowDragged.getWidth() < this.windowDragged.minWidth) {
                            this.windowDragged.width = this.windowDragged.minWidth;
                        } else {
                            this.windowDragged.clickX = mouseX - this.windowDragged.posX;
                        }
                    }
                    this.windowDragged.resized();
                    if (this.windowDragged.docked >= 0) {
                        this.redock(this.windowDragged.docked, this.windowDragged);
                    }
                }
            }
        }
    }

    public void updateElementDragged(int mouseX, int mouseY) {
        if (this.elementDragged != null) {
            if (!this.mouseLeftDown) {
                this.elementDragged = null;
            } else if ((mouseX - this.elementDragged.parent.posX < 0 || mouseX - this.elementDragged.parent.posX > this.elementDragged.parent.getWidth() || mouseY - this.elementDragged.parent.posY < 0 || mouseY - this.elementDragged.parent.posY > 12) && this.elementDragged instanceof ElementWindow) {
                WindowTabs cfr_ignored_0 = (WindowTabs)((ElementWindow)this.elementDragged).parent;
                WindowTabs.detach((ElementWindow)this.elementDragged);
                ElementWindow element = (ElementWindow)this.elementDragged;
                this.windowDragged = element.mountedWindow;
                this.windowDragged.docked = -1;
                this.dragType = 1;
                this.windowDragged.width = element.oriWidth;
                this.windowDragged.height = element.oriHeight;
                this.windowDragged.posX = mouseX - this.windowDragged.getWidth() / 2;
                this.windowDragged.posY = mouseY - 6;
                this.windowDragged.resized();
                this.elementDragged = null;
            }
        }
    }

    public void updateKeyStates() {
        this.mouseLeftDown = Mouse.isButtonDown((int)0);
        this.mouseRightDown = Mouse.isButtonDown((int)1);
        this.mouseMiddleDown = Mouse.isButtonDown((int)2);
    }

    public boolean canUseDocks() {
        return true;
    }

    public void addToDock(int dock, Window window) {
        if (this.canUseDocks() && window != null && window.docked < 0) {
            if (window.minimized) {
                window.toggleMinimize();
            }
            ArrayList<Window> docked = this.levels.get(dock);
            window.docked = dock;
            window.oriHeight = window.height;
            window.oriWidth = window.width;
            docked.add(window);
            for (int i = this.VARIABLE_LEVEL; i < this.levels.size(); ++i) {
                this.levels.get(i).remove(window);
            }
            this.redock(dock, null);
        }
    }

    public void redock(int dock, Window pref) {
        int j;
        ArrayList<Window> docked = this.levels.get(dock);
        int prefInt = -2;
        if (pref != null) {
            for (j = 0; j < docked.size(); ++j) {
                if (docked.get(j) != pref) continue;
                prefInt = j;
            }
        }
        for (j = 0; j < docked.size(); ++j) {
            Window window = docked.get(j);
            if (dock == 0) {
                window.posX = -1;
            } else if (dock == 1) {
                window.posX = this.field_146294_l - window.getWidth() + 1;
            }
            if (dock <= 1) {
                if (prefInt != -2) {
                    docked.get((int)0).width = docked.get((int)prefInt).width;
                } else if (j == 0) {
                    window.posY = this.TOP_DOCK_HEIGHT;
                } else {
                    window.width = docked.get((int)0).width;
                    window.posY = docked.get((int)(j - 1)).posY + (docked.get((int)(j - 1)).minimized ? 12 : (docked.get((int)(j - 1)).height + docked.get((int)(j - 1)).posY + 2 >= this.field_146295_m ? docked.get((int)(j - 1)).oriHeight : docked.get((int)(j - 1)).height));
                    docked.get((int)(j - 1)).height = window.posY - docked.get((int)(j - 1)).posY + 2;
                }
                if (j - 1 == prefInt) {
                    window.height += window.posY - (docked.get((int)(j - 1)).posY + docked.get((int)(j - 1)).height) + 2;
                    window.posY -= window.posY - (docked.get((int)(j - 1)).posY + docked.get((int)(j - 1)).height) + 2;
                }
                if (j + 1 == prefInt) {
                    window.height = docked.get((int)(j + 1)).posY - window.posY + 2;
                    if (window.height < window.minHeight + 2) {
                        window.height = window.minHeight + 2;
                        docked.get((int)prefInt).posY = window.posY + window.height - 2;
                        this.windowDragged = null;
                        this.dragType = 0;
                    }
                }
                window.width = docked.get((int)0).width;
                this.redock(2, null);
            } else if (dock == 2) {
                int pX1 = -1;
                int pX2 = this.field_146294_l + 1;
                if (!this.levels.get(0).isEmpty()) {
                    pX1 = this.levels.get((int)0).get((int)0).width - 2;
                }
                if (!this.levels.get(1).isEmpty()) {
                    pX2 = this.levels.get((int)1).get((int)0).posX + 1;
                }
                window.posX = pX1;
                window.width = pX2 - pX1;
                window.posY = this.field_146295_m - window.getHeight() + 1;
            }
            window.resized();
        }
        this.screenResize();
    }

    public void removeFromDock(Window window) {
        block0: for (int i = 2; i >= 0; --i) {
            ArrayList<Window> docked = this.levels.get(i);
            for (int j = docked.size() - 1; j >= 0; --j) {
                Window window1 = docked.get(j);
                if (window1 != window) continue;
                docked.remove(j);
                this.redock(i, null);
                continue block0;
            }
        }
        window.docked = -1;
        window.height = window.oriHeight;
        window.width = window.oriWidth;
        this.addWindowOnTop(window);
        window.resized();
        this.redock(2, null);
    }

    public void removeWindow(Window window) {
        this.removeWindow(window, false);
    }

    public void removeWindow(Window window, boolean checkTab) {
        block0: for (int i = this.levels.size() - 1; i >= 0; --i) {
            for (int j = this.levels.get(i).size() - 1; j >= 0; --j) {
                Window window1 = this.levels.get(i).get(j);
                if (window1 instanceof WindowTabs && !(window instanceof WindowTabs) && checkTab) {
                    WindowTabs tabs = (WindowTabs)window1;
                    for (ElementWindow tab : tabs.tabs) {
                        if (tab.mountedWindow != window) continue;
                        Window win = WindowTabs.detach(tab);
                        win.docked = -1;
                        win.width = tab.oriWidth;
                        win.height = tab.oriHeight;
                        win.posX = this.field_146294_l / 2 - win.width / 2;
                        win.posY = this.field_146295_m / 2 - win.height / 2;
                        win.resized();
                        this.removeWindow(win);
                        return;
                    }
                }
                if (window1 != window) continue;
                if (i < this.VARIABLE_LEVEL) {
                    this.removeFromDock(window1);
                    this.removeWindow(window1, checkTab);
                    continue block0;
                }
                this.levels.get(i).remove(j);
                if (!this.levels.get(i).isEmpty()) continue block0;
                this.levels.remove(i);
                continue block0;
            }
        }
    }

    public void addWindowOnTop(Window window) {
        if (!window.allowMultipleInstances() && window.getClass() != Window.class) {
            for (int i = this.levels.size() - 1; i >= 0; --i) {
                for (int j = this.levels.get(i).size() - 1; j >= 0; --j) {
                    Window window1 = this.levels.get(i).get(j);
                    if (window == window1) continue;
                    if (window1 instanceof WindowTabs) {
                        WindowTabs tabs = (WindowTabs)window1;
                        for (ElementWindow tab : tabs.tabs) {
                            if (tab.mountedWindow.getClass() != window.getClass()) continue;
                            Window win = WindowTabs.detach(tab);
                            win.docked = -1;
                            win.width = tab.oriWidth;
                            win.height = tab.oriHeight;
                            win.posX = this.field_146294_l / 2 - win.width / 2;
                            win.posY = this.field_146295_m / 2 - win.height / 2;
                            win.resized();
                            this.bringWindowToFront(win);
                            return;
                        }
                        continue;
                    }
                    if (window1.getClass() != window.getClass()) continue;
                    if (window1.docked >= 0) {
                        this.removeFromDock(window1);
                    }
                    window1.docked = -1;
                    if (window1.height > this.field_146295_m) {
                        window1.height = window1.minHeight;
                    }
                    if (window1.width > this.field_146294_l) {
                        window1.width = window1.minWidth;
                    }
                    window1.posX = this.field_146294_l / 2 - window1.width / 2;
                    window1.posY = this.field_146295_m / 2 - window1.height / 2;
                    window1.resized();
                    this.bringWindowToFront(window1);
                    return;
                }
            }
        }
        ArrayList<Window> topLevel = new ArrayList<Window>();
        topLevel.add(window);
        this.levels.add(topLevel);
    }

    public void screenResize() {
        Window window;
        int j;
        ArrayList<Window> docked;
        int i;
        for (i = 0; i < this.VARIABLE_LEVEL; ++i) {
            docked = this.levels.get(i);
            for (j = 0; j < docked.size(); ++j) {
                window = docked.get(j);
                if (i == 0) {
                    window.posX = -1;
                } else if (i == 1) {
                    window.posX = this.field_146294_l - window.getWidth() + 1;
                } else if (i == 2) {
                    int pX1 = -1;
                    int pX2 = this.field_146294_l + 1;
                    if (!this.levels.get(0).isEmpty()) {
                        pX1 = this.levels.get((int)0).get((int)0).width - 2;
                    }
                    if (!this.levels.get(1).isEmpty()) {
                        pX2 = this.levels.get((int)1).get((int)0).posX + 1;
                    }
                    window.posX = pX1;
                    window.width = pX2 - pX1;
                    window.posY = this.field_146295_m - window.getHeight() + 1;
                }
                if (j == docked.size() - 1 && i != 2) {
                    window.height = this.field_146295_m - window.posY + 1;
                }
                if (window.posX == (this.oldWidth - window.width) / 2 && window.posY == (this.oldHeight - window.height) / 2) {
                    window.posX = (this.field_146294_l - window.width) / 2;
                    window.posY = (this.field_146295_m - window.height) / 2;
                }
                window.resized();
            }
        }
        for (i = this.VARIABLE_LEVEL; i < this.levels.size(); ++i) {
            docked = this.levels.get(i);
            for (j = 0; j < docked.size(); ++j) {
                window = docked.get(j);
                if (window.posX == (this.oldWidth - window.width) / 2 && window.posY == (this.oldHeight - window.height) / 2) {
                    window.putInMiddleOfScreen();
                }
                window.resized();
            }
        }
        this.oldWidth = this.field_146294_l;
        this.oldHeight = this.field_146295_m;
    }

    public void bringWindowToFront(Window window) {
        if (window.isStatic()) {
            return;
        }
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            for (int j = this.levels.get(i).size() - 1; j >= 0; --j) {
                Window window1 = this.levels.get(i).get(j);
                if (window1 != window || window.docked >= 0 || i == this.levels.size() - 1 && this.levels.get(i).size() == 1) continue;
                ArrayList<Window> topLevel = new ArrayList<Window>();
                topLevel.add(window1);
                this.levels.get(i).remove(j);
                if (this.levels.get(i).isEmpty() && i >= this.VARIABLE_LEVEL) {
                    this.levels.remove(i);
                }
                this.levels.add(topLevel);
            }
        }
    }

    public String reString(String s, int width) {
        while (s.length() > 1 && this.getFontRenderer().func_78256_a(s) > width - 3 && !s.startsWith("...")) {
            if (s.endsWith("...")) {
                s = s.substring(0, s.length() - 4) + "...";
                continue;
            }
            s = s.substring(0, s.length() - 1) + "...";
        }
        return s;
    }
}

