/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.client.thread;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import us.ichun.mods.ichunutil.common.core.EntityHelperBase;
import us.ichun.mods.ichunutil.common.core.config.ConfigBase;
import us.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import us.ichun.mods.ichunutil.common.core.config.annotations.ConfigProp;
import us.ichun.mods.ichunutil.common.core.config.annotations.IntBool;
import us.ichun.mods.ichunutil.common.core.updateChecker.ModVersionChecker;
import us.ichun.mods.ichunutil.common.core.updateChecker.ModVersionInfo;
import us.ichun.mods.ichunutil.common.core.util.ObfHelper;
import us.ichun.mods.ichunutil.common.core.util.ResourceHelper;
import us.ichun.mods.ichunutil.common.iChunUtil;

@SideOnly(value=Side.CLIENT)
public class ThreadStatistics
extends Thread {
    public int type;
    public Object[] data;
    public static final ArrayList<String> infectionHash = new ArrayList();
    public static final Random rand = new Random();
    public static Config stats;

    public ThreadStatistics(int type1, Object ... data1) {
        this.setName("iChunUtil Statistics Thread");
        this.setDaemon(true);
        this.type = type1;
        this.data = data1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            try {
                HttpEntity entity;
                CloseableHttpClient httpclient = HttpClients.createDefault();
                HttpPost httppost = new HttpPost("http://ichun.us/infect/stats2.php");
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(2);
                params.add(new BasicNameValuePair("event", Integer.toString(this.type)));
                params.add(new BasicNameValuePair("UUID", Minecraft.func_71410_x().func_110432_I().func_148255_b().replaceAll("-", "")));
                if (this.type != 4) {
                    params.add(new BasicNameValuePair("time", Long.toString(System.currentTimeMillis())));
                    switch (this.type) {
                        case 1: {
                            params.add(new BasicNameValuePair("version", "5.5.0".replaceAll(" ", "").replaceAll("\\.", "_")));
                            StringBuilder sb = new StringBuilder();
                            if (!ObfHelper.obfuscation) {
                                sb.append("devEnv-");
                            }
                            ArrayList<ModVersionInfo> mods = ModVersionChecker.getListOf_iChunMods();
                            for (int i = 0; i < mods.size(); ++i) {
                                sb.append(mods.get((int)i).modName.replaceAll(" ", "").replaceAll("\\.", "_") + "_" + mods.get((int)i).modVersion.replaceAll("\\.", "_"));
                                if (i >= mods.size() - 1) continue;
                                sb.append("-");
                            }
                            params.add(new BasicNameValuePair("mods", sb.toString()));
                            params.add(new BasicNameValuePair("level", Integer.toString(ThreadStatistics.getImmunityLevel())));
                            break;
                        }
                        case 2: {
                            params.add(new BasicNameValuePair("infector", (String)this.data[1]));
                        }
                        case 3: {
                            params.add(new BasicNameValuePair("level", Integer.toString((Integer)this.data[0])));
                        }
                    }
                }
                httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                if (this.type != 4 || (entity = response.getEntity()) == null) break block15;
                InputStream is = entity.getContent();
                try {
                    int lv = Integer.parseInt(IOUtils.toString((InputStream)is, (String)"UTF-8").trim());
                    if (lv >= 0) {
                        stats.reveal("statsData");
                        ThreadStatistics.stats.statsData = ThreadStatistics.getInfectionHash(lv);
                        stats.save();
                    } else {
                        new ThreadStatistics(1, new Object[0]).start();
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void checkFirstLaunch() {
        stats = (Config)ConfigHandler.registerConfig(new Config(new File(ResourceHelper.getConfigFolder(), "iChunUtil_Stats.cfg")));
        if (ThreadStatistics.stats.statsOptOut == 1) {
            iChunUtil.logger.info("Opting out of stat collection :(");
        } else {
            boolean isPatientZero;
            boolean bl = isPatientZero = ThreadStatistics.getImmunityLevel() == 0;
            if (ThreadStatistics.stats.statsData.trim().isEmpty() || ThreadStatistics.getInfectionLevel(ThreadStatistics.stats.statsData) == -1) {
                if (isPatientZero) {
                    stats.reveal("statsData");
                    ThreadStatistics.stats.statsData = ThreadStatistics.getInfectionHash(0);
                } else {
                    ThreadStatistics.stats.statsData = "";
                }
                stats.save();
            }
            String firstLaunchHash = ThreadStatistics.createFirstLaunchHash();
            if (ThreadStatistics.stats.statsIdentifier.trim().isEmpty() || !ThreadStatistics.stats.statsIdentifier.equals(firstLaunchHash)) {
                ThreadStatistics.stats.statsIdentifier = firstLaunchHash;
                stats.save();
                new ThreadStatistics(4, new Object[0]).start();
            }
        }
    }

    public static String createFirstLaunchHash() {
        rand.setSeed(Math.abs(Minecraft.func_71410_x().func_110432_I().func_148255_b().hashCode() - "FirstRunV2".hashCode()));
        return RandomStringUtils.random((int)20, (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)rand);
    }

    public static int getImmunityLevel() {
        Minecraft mc = Minecraft.func_71410_x();
        return EntityHelperBase.getImmunityLevel(mc.func_110432_I().func_148255_b());
    }

    public static int getInfectionLevel(String s) {
        if (s.isEmpty()) {
            return -1;
        }
        if (infectionHash.isEmpty()) {
            ThreadStatistics.generateInfectionHash();
        }
        for (int i = 0; i < infectionHash.size(); ++i) {
            if (!infectionHash.get(i).equals(s)) continue;
            return i;
        }
        return -1;
    }

    public static String getInfectionHash(int i) {
        if (infectionHash.isEmpty()) {
            ThreadStatistics.generateInfectionHash();
        }
        if (i >= infectionHash.size()) {
            return "CHEATER";
        }
        return infectionHash.get(i);
    }

    public static void generateInfectionHash() {
        infectionHash.clear();
        Minecraft mc = Minecraft.func_71410_x();
        float immunity = 1.0f;
        int i = 0;
        while (immunity > 0.0f) {
            rand.setSeed(Math.abs(mc.func_110432_I().func_148255_b().replaceAll("-", "").hashCode() + infectionHash.size() * Math.abs("infection".hashCode())));
            infectionHash.add(RandomStringUtils.random((int)20, (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)rand));
            immunity -= EntityHelperBase.RARITY[i];
            ++i;
        }
    }

    public static class Config
    extends ConfigBase {
        @ConfigProp(category="stats")
        @IntBool
        public int statsOptOut;
        @ConfigProp(category="stats")
        public String statsIdentifier;
        @ConfigProp(category="stats", hidden=true)
        public String statsData;

        public Config(File file) {
            super(file, new String[0]);
            this.statsOptOut = Minecraft.func_71410_x().field_71474_y.field_74355_t ? 0 : 1;
            this.statsIdentifier = "";
            this.statsData = "";
        }

        @Override
        public String getModId() {
            return "ichunutilstats";
        }

        @Override
        public String getModName() {
            return "iChunUtil Stats";
        }
    }
}

