/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.core.event;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import us.ichun.mods.ichunutil.client.patron.LayerPatronEffect;
import us.ichun.mods.ichunutil.client.thread.ThreadStatistics;
import us.ichun.mods.ichunutil.common.core.config.ConfigBase;
import us.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import us.ichun.mods.ichunutil.common.core.event.RendererSafeCompatibilityEvent;
import us.ichun.mods.ichunutil.common.core.event.ServerPacketableEvent;
import us.ichun.mods.ichunutil.common.core.packet.mod.PacketNewGrabbedEntityId;
import us.ichun.mods.ichunutil.common.core.packet.mod.PacketPatientData;
import us.ichun.mods.ichunutil.common.core.packet.mod.PacketPatrons;
import us.ichun.mods.ichunutil.common.core.updateChecker.PacketModsList;
import us.ichun.mods.ichunutil.common.grab.GrabHandler;
import us.ichun.mods.ichunutil.common.iChunUtil;

public class EventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInitGuiPost(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!iChunUtil.hasShownFirstGui) {
            iChunUtil.hasShownFirstGui = true;
            MinecraftForge.EVENT_BUS.post((Event)new RendererSafeCompatibilityEvent());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRendererSafeCompatibility(RendererSafeCompatibilityEvent event) {
        RenderPlayer renderPlayer = (RenderPlayer)Minecraft.func_71410_x().func_175598_ae().field_178636_l.get("default");
        renderPlayer.func_177094_a((LayerRenderer)new LayerPatronEffect(renderPlayer));
        renderPlayer = (RenderPlayer)Minecraft.func_71410_x().func_175598_ae().field_178636_l.get("slim");
        renderPlayer.func_177094_a((LayerRenderer)new LayerPatronEffect(renderPlayer));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientConnection(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        for (ConfigBase conf : ConfigHandler.configs) {
            conf.storeSession();
        }
        if (iChunUtil.isPatron) {
            iChunUtil.proxy.effectTicker.tellServerAsPatron = true;
        }
        iChunUtil.proxy.tickHandlerClient.firstConnectToServer = true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        for (ConfigBase conf : ConfigHandler.configs) {
            conf.resetSession();
        }
        iChunUtil.proxy.tickHandlerClient.trackedEntities.clear();
        GrabHandler.grabbedEntities.get(Side.CLIENT).clear();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerPacketable(ServerPacketableEvent event) {
        int infectionLevel;
        if (ThreadStatistics.stats.statsOptOut != 1 && !ThreadStatistics.stats.statsData.isEmpty() && (infectionLevel = ThreadStatistics.getInfectionLevel(ThreadStatistics.stats.statsData)) >= 0) {
            iChunUtil.channel.sendToServer(new PacketPatientData(infectionLevel, false, ""));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        iChunUtil.channel.sendToPlayer(new PacketModsList(iChunUtil.config.versionNotificationTypes, FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152596_g(event.player.func_146103_bH())), event.player);
        iChunUtil.channel.sendToPlayer(new PacketPatrons(), event.player);
        for (ConfigBase conf : ConfigHandler.configs) {
            if (conf.sessionProp.isEmpty()) continue;
            conf.sendPlayerSession(event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ArrayList<GrabHandler> handlers = GrabHandler.getHandlers((EntityLivingBase)event.player, Side.SERVER);
        for (int i = handlers.size() - 1; i >= 0; --i) {
            GrabHandler handler = handlers.get(i);
            if (handler.canSendAcrossDimensions()) {
                GrabHandler.dimensionalEntities.add(handler.grabbed.func_145782_y());
                handler.grabbed.getEntityData().func_74768_a("Grabbed-ID", handler.grabbed.func_145782_y());
                handler.grabbed.func_71027_c(event.player.field_71093_bK);
                handler.update();
                continue;
            }
            handler.terminate();
            handlers.remove(i);
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity.getEntityData().func_74764_b("Grabbed-ID")) {
            Integer x = event.entity.getEntityData().func_74762_e("Grabbed-ID");
            if (event.entity.func_145782_y() != x.intValue()) {
                for (int i = GrabHandler.dimensionalEntities.size() - 1; i >= 0; --i) {
                    if (!GrabHandler.dimensionalEntities.get(i).equals(x)) continue;
                    GrabHandler.dimensionalEntities.remove(i);
                    for (GrabHandler handler : GrabHandler.grabbedEntities.get(Side.SERVER)) {
                        if (handler.grabbed.func_145782_y() != x.intValue()) continue;
                        handler.grabbed = event.entity;
                        iChunUtil.channel.sendToAll(new PacketNewGrabbedEntityId(true, x, event.entity.func_145782_y()));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            iChunUtil.proxy.effectTicker.streaks.clear();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_72995_K) {
            for (GrabHandler handler : GrabHandler.grabbedEntities.get(Side.CLIENT)) {
                handler.grabber = null;
                handler.grabbed = null;
            }
        }
    }
}

