/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import us.ichun.mods.ichunutil.common.core.CommonProxy;
import us.ichun.mods.ichunutil.common.core.Logger;
import us.ichun.mods.ichunutil.common.core.config.ConfigBase;
import us.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import us.ichun.mods.ichunutil.common.core.config.annotations.ConfigProp;
import us.ichun.mods.ichunutil.common.core.config.annotations.IntBool;
import us.ichun.mods.ichunutil.common.core.config.annotations.IntMinMax;
import us.ichun.mods.ichunutil.common.core.event.EventHandler;
import us.ichun.mods.ichunutil.common.core.network.PacketChannel;
import us.ichun.mods.ichunutil.common.core.network.PacketExecuter;
import us.ichun.mods.ichunutil.common.core.patron.PatronInfo;
import us.ichun.mods.ichunutil.common.core.updateChecker.ModVersionChecker;
import us.ichun.mods.ichunutil.common.core.updateChecker.ModVersionInfo;
import us.ichun.mods.ichunutil.common.core.util.ObfHelper;
import us.ichun.mods.ichunutil.common.grab.GrabHandler;

@Mod(modid="iChunUtil", name="iChunUtil", version="5.5.0", guiFactory="us.ichun.mods.ichunutil.common.core.config.GenericModGuiFactory", dependencies="required-after:Forge@[11.14.1.1354,99999.15.0.0)", acceptedMinecraftVersions="[1.8]")
public class iChunUtil {
    public static final int requiredForgeMajor = 11;
    public static final int requiredForgeMinor = 14;
    public static final int requiredForgeRevision = 1;
    public static final int requiredForgeBuild = 1354;
    public static final int versionMC = 5;
    public static final String versionOfMC = "1.8.0";
    public static final String MOD_NAME = "iChunUtil";
    public static final String VERSION = "5.5.0";
    public static final Logger logger = Logger.createLogger("iChunUtil");
    private static boolean hasPostLoad = false;
    public static boolean hasShownFirstGui = false;
    public static PacketChannel channel;
    public static Config config;
    public static boolean hasMorphMod;
    public static boolean isPatron;
    public static ArrayList<PatronInfo> patronList;
    @Mod.Instance(value="iChunUtil")
    public static iChunUtil instance;
    @SidedProxy(clientSide="us.ichun.mods.ichunutil.client.core.ClientProxy", serverSide="us.ichun.mods.ichunutil.common.core.CommonProxy")
    public static CommonProxy proxy;
    public static Block blockCompactPorkchop;
    public static List<ItemStack> oreDictBlockCompactRawPorkchop;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        String[] split;
        ObfHelper.detectObfuscation();
        FMLCommonHandler.instance().bus().register((Object)new PacketExecuter());
        EventHandler eventHandler = new EventHandler();
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        config = (Config)ConfigHandler.registerConfig(new Config(event.getSuggestedConfigurationFile()));
        for (String s : split = iChunUtil.config.lastCheck.split(", ")) {
            String[] str = s.split(": ");
            if (str.length < 2) continue;
            iChunUtil.proxy.prevVerChecker.put(str[0], str[1]);
        }
        ObfHelper.detectMCVersion();
        proxy.preInit();
        ModVersionChecker.register_iChunMod(new ModVersionInfo(MOD_NAME, versionOfMC, VERSION, false));
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.init();
        ModVersionChecker.init();
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent event) {
        proxy.postInit();
        hasPostLoad = true;
        for (ConfigBase cfg : ConfigHandler.configs) {
            cfg.setup();
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && ConfigHandler.configKeybind != null) {
            ConfigHandler.configKeybind.save();
        }
        hasMorphMod = Loader.isModLoaded((String)"Morph");
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        GrabHandler.grabbedEntities.get(Side.SERVER).clear();
        GrabHandler.dimensionalEntities.clear();
    }

    public static boolean getPostLoad() {
        return hasPostLoad;
    }

    static {
        patronList = new ArrayList();
    }

    public class Config
    extends ConfigBase {
        @ConfigProp(category="versionCheck")
        @IntMinMax(min=0, max=2)
        public int versionNotificationTypes;
        @ConfigProp(category="versionCheck")
        @IntMinMax(min=0, max=3)
        public int versionNotificationFrequency;
        @ConfigProp(category="versionSave", comment="", nameOverride="Last Check")
        public String lastCheck;
        @ConfigProp(category="versionSave", comment="", nameOverride="Day Check")
        @IntMinMax(min=0, max=35)
        public int dayCheck;
        @ConfigProp(category="clientOnly", side=Side.CLIENT, changeable=false)
        @IntBool
        public int enableStencils;
        @ConfigProp(category="patreon", hidden=true)
        @IntBool
        public int showPatronReward;
        @ConfigProp(category="patreon", hidden=true)
        @IntMinMax(min=1, max=5)
        public int patronRewardType;
        @ConfigProp
        @IntBool
        public int ignoreMCVersionCheck;
        @ConfigProp(category="block", useSession=true)
        @IntBool
        public int enableCompactPorkchop;

        public Config(File file) {
            super(file, new String[0]);
            this.versionNotificationTypes = 1;
            this.versionNotificationFrequency = 0;
            this.lastCheck = "";
            this.dayCheck = 0;
            this.enableStencils = 1;
            this.showPatronReward = 1;
            this.patronRewardType = 1;
            this.ignoreMCVersionCheck = 0;
            this.enableCompactPorkchop = 1;
        }

        @Override
        public String getModId() {
            return iChunUtil.MOD_NAME.toLowerCase();
        }

        @Override
        public String getModName() {
            return iChunUtil.MOD_NAME;
        }

        @Override
        public void onConfigChange(Field field, Object original) {
            if (field.getName().equals("showPatronReward") || field.getName().equals("patronRewardType")) {
                iChunUtil.proxy.effectTicker.tellServerAsPatron = true;
            }
        }

        @Override
        public void onReceiveSession() {
            List<ItemStack> compactPorkchops = oreDictBlockCompactRawPorkchop;
            if (compactPorkchops.size() == 1 && compactPorkchops.get(0).func_77973_b() != null && Block.func_149634_a((Item)compactPorkchops.get(0).func_77973_b()) == blockCompactPorkchop) {
                List recipes = CraftingManager.func_77594_a().func_77592_b();
                for (int i = recipes.size() - 1; i >= 0; --i) {
                    ShapedRecipes recipe;
                    if (!(recipes.get(i) instanceof ShapedRecipes) || !(recipe = (ShapedRecipes)recipes.get(i)).func_77571_b().func_77969_a(new ItemStack(blockCompactPorkchop))) continue;
                    recipes.remove(i);
                }
                if (this.enableCompactPorkchop == 1) {
                    GameRegistry.addRecipe((ItemStack)new ItemStack(blockCompactPorkchop), (Object[])new Object[]{"PPP", "PPP", "PPP", Character.valueOf('P'), Items.field_151147_al});
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151147_al, 9), (Object[])new Object[]{blockCompactPorkchop});
                }
            }
        }
    }
}

