/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.module.worldportals;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import us.ichun.mods.ichunutil.common.module.worldportals.WorldPortalInfo;

public abstract class WorldPortalCarrier
extends TileEntity
implements IUpdatePlayerListBox {
    public abstract WorldPortalInfo getPortalInfo();

    public void func_73660_a() {
        this.getPortalInfo().setParent(this);
        this.getPortalInfo().update();
        if (this.func_145831_w().field_72995_K) {
            this.identifyBorders();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound tag1 = new NBTTagCompound();
        this.getPortalInfo().write(tag1);
        tag.func_74782_a("portalInfo", (NBTBase)tag1);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.getPortalInfo().setParent(this);
        this.getPortalInfo().read(tag.func_74775_l("portalInfo"));
    }

    public AxisAlignedBB getWorldPortalBoundingBox() {
        WorldPortalInfo portalInfo = this.getPortalInfo();
        BlockPos blockPos = this.func_174877_v();
        double x1 = (double)blockPos.func_177958_n() + 0.5;
        double x2 = (double)blockPos.func_177958_n() + 0.5;
        double y1 = (double)blockPos.func_177956_o() + 0.5;
        double y2 = (double)blockPos.func_177956_o() + 0.5;
        double z1 = (double)blockPos.func_177952_p() + 0.5;
        double z2 = (double)blockPos.func_177952_p() + 0.5;
        if (portalInfo.face == 0) {
            y1 += portalInfo.offsetHeight + 0.5;
            y2 += portalInfo.offsetHeight + 0.5 + portalInfo.height;
            if (portalInfo.orientation == 0) {
                x1 += portalInfo.width;
                x2 -= portalInfo.width;
                z1 -= portalInfo.offsetDepth;
                z2 -= portalInfo.offsetDepth;
            } else if (portalInfo.orientation == 2) {
                x1 += portalInfo.width;
                x2 -= portalInfo.width;
                z1 += portalInfo.offsetDepth;
                z2 += portalInfo.offsetDepth;
            } else if (portalInfo.orientation == 1) {
                x1 -= portalInfo.offsetDepth;
                x2 -= portalInfo.offsetDepth;
                z1 -= portalInfo.width;
                z2 += portalInfo.width;
            } else if (portalInfo.orientation == 3) {
                x1 += portalInfo.offsetDepth;
                x2 += portalInfo.offsetDepth;
                z1 -= portalInfo.width;
                z2 += portalInfo.width;
            }
        }
        return AxisAlignedBB.func_178781_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    @SideOnly(value=Side.CLIENT)
    public void identifyBorders() {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            AxisAlignedBB aabb = this.getWorldPortalBoundingBox();
            EnumParticleTypes type = EnumParticleTypes.TOWN_AURA;
            this.func_145831_w().func_175688_a(type, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, 0.0, 0.0, 0.0, new int[0]);
            this.func_145831_w().func_175688_a(type, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c, 0.0, 0.0, 0.0, new int[0]);
            this.func_145831_w().func_175688_a(type, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f, 0.0, 0.0, 0.0, new int[0]);
            this.func_145831_w().func_175688_a(type, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f, 0.0, 0.0, 0.0, new int[0]);
            this.func_145831_w().func_175688_a(type, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c, 0.0, 0.0, 0.0, new int[0]);
            this.func_145831_w().func_175688_a(type, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c, 0.0, 0.0, 0.0, new int[0]);
            this.func_145831_w().func_175688_a(type, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f, 0.0, 0.0, 0.0, new int[0]);
            this.func_145831_w().func_175688_a(type, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.canRenderEntitySeePortal()) {
            AxisAlignedBB.func_178781_a((double)0.0, (double)-500.0, (double)0.0, (double)0.0, (double)-500.0, (double)0.0);
        }
        return this.getWorldPortalBoundingBox();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderEntitySeePortal() {
        Minecraft mc = Minecraft.func_71410_x();
        Entity ent = mc.func_175606_aa();
        float tpDist = mc.field_71474_y.field_74320_O == 0 ? 0.0f : mc.field_71460_t.field_78490_B;
        WorldPortalInfo portalInfo = this.getPortalInfo();
        AxisAlignedBB borders = this.getWorldPortalBoundingBox();
        if (portalInfo.face == 0) {
            boolean posFail;
            boolean bl = posFail = portalInfo.orientation == 0 && ent.field_70161_v < borders.field_72339_c - (double)tpDist || portalInfo.orientation == 2 && ent.field_70161_v > borders.field_72339_c + (double)tpDist || portalInfo.orientation == 1 && ent.field_70165_t < borders.field_72340_a - (double)tpDist || portalInfo.orientation == 3 && ent.field_70165_t > borders.field_72340_a + (double)tpDist;
            if (posFail) {
                return false;
            }
        }
        return true;
    }
}

