/*
 * Decompiled with CFR 0.152.
 */
package api.player.client;

import api.player.client.ClientPlayerAPI;
import api.player.client.IClientPlayer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;

public abstract class ClientPlayerBase {
    protected final EntityPlayerSP player;
    protected final IClientPlayer playerAPI;
    private final ClientPlayerAPI internalClientPlayerAPI;

    public ClientPlayerBase(ClientPlayerAPI clientPlayerAPI) {
        this.internalClientPlayerAPI = clientPlayerAPI;
        this.playerAPI = clientPlayerAPI.player;
        this.player = clientPlayerAPI.player.getEntityPlayerSP();
    }

    public void beforeBaseAttach(boolean bl) {
    }

    public void afterBaseAttach(boolean bl) {
    }

    public void beforeLocalConstructing(Minecraft minecraft, World world, NetHandlerPlayClient netHandlerPlayClient, StatisticsManager statisticsManager) {
    }

    public void afterLocalConstructing(Minecraft minecraft, World world, NetHandlerPlayClient netHandlerPlayClient, StatisticsManager statisticsManager) {
    }

    public void beforeBaseDetach(boolean bl) {
    }

    public void afterBaseDetach(boolean bl) {
    }

    public Object dynamic(String string, Object[] objectArray) {
        return this.internalClientPlayerAPI.dynamicOverwritten(string, objectArray, this);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void beforeAddExhaustion(float f) {
    }

    public void addExhaustion(float f) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenAddExhaustion(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localAddExhaustion(f);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.addExhaustion(f);
        }
    }

    public void afterAddExhaustion(float f) {
    }

    public void beforeAddMovementStat(double d, double d2, double d3) {
    }

    public void addMovementStat(double d, double d2, double d3) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenAddMovementStat(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localAddMovementStat(d, d2, d3);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.addMovementStat(d, d2, d3);
        }
    }

    public void afterAddMovementStat(double d, double d2, double d3) {
    }

    public void beforeAddStat(StatBase statBase, int n) {
    }

    public void addStat(StatBase statBase, int n) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenAddStat(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localAddStat(statBase, n);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.addStat(statBase, n);
        }
    }

    public void afterAddStat(StatBase statBase, int n) {
    }

    public void beforeAttackEntityFrom(DamageSource damageSource, float f) {
    }

    public boolean attackEntityFrom(DamageSource damageSource, float f) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenAttackEntityFrom(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localAttackEntityFrom(damageSource, f) : (clientPlayerBase != this ? clientPlayerBase.attackEntityFrom(damageSource, f) : false);
        return bl;
    }

    public void afterAttackEntityFrom(DamageSource damageSource, float f) {
    }

    public void beforeAttackTargetEntityWithCurrentItem(Entity entity) {
    }

    public void attackTargetEntityWithCurrentItem(Entity entity) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenAttackTargetEntityWithCurrentItem(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localAttackTargetEntityWithCurrentItem(entity);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.attackTargetEntityWithCurrentItem(entity);
        }
    }

    public void afterAttackTargetEntityWithCurrentItem(Entity entity) {
    }

    public void beforeCanBreatheUnderwater() {
    }

    public boolean canBreatheUnderwater() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenCanBreatheUnderwater(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localCanBreatheUnderwater() : (clientPlayerBase != this ? clientPlayerBase.canBreatheUnderwater() : false);
        return bl;
    }

    public void afterCanBreatheUnderwater() {
    }

    public void beforeCanHarvestBlock(IBlockState iBlockState) {
    }

    public boolean canHarvestBlock(IBlockState iBlockState) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenCanHarvestBlock(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localCanHarvestBlock(iBlockState) : (clientPlayerBase != this ? clientPlayerBase.canHarvestBlock(iBlockState) : false);
        return bl;
    }

    public void afterCanHarvestBlock(IBlockState iBlockState) {
    }

    public void beforeCanPlayerEdit(BlockPos blockPos, EnumFacing enumFacing, ItemStack itemStack) {
    }

    public boolean canPlayerEdit(BlockPos blockPos, EnumFacing enumFacing, ItemStack itemStack) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenCanPlayerEdit(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localCanPlayerEdit(blockPos, enumFacing, itemStack) : (clientPlayerBase != this ? clientPlayerBase.canPlayerEdit(blockPos, enumFacing, itemStack) : false);
        return bl;
    }

    public void afterCanPlayerEdit(BlockPos blockPos, EnumFacing enumFacing, ItemStack itemStack) {
    }

    public void beforeCanTriggerWalking() {
    }

    public boolean canTriggerWalking() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenCanTriggerWalking(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localCanTriggerWalking() : (clientPlayerBase != this ? clientPlayerBase.canTriggerWalking() : false);
        return bl;
    }

    public void afterCanTriggerWalking() {
    }

    public void beforeCloseScreen() {
    }

    public void closeScreen() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenCloseScreen(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localCloseScreen();
        } else if (clientPlayerBase != this) {
            clientPlayerBase.closeScreen();
        }
    }

    public void afterCloseScreen() {
    }

    public void beforeDamageEntity(DamageSource damageSource, float f) {
    }

    public void damageEntity(DamageSource damageSource, float f) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenDamageEntity(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localDamageEntity(damageSource, f);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.damageEntity(damageSource, f);
        }
    }

    public void afterDamageEntity(DamageSource damageSource, float f) {
    }

    public void beforeDisplayGui(IInteractionObject iInteractionObject) {
    }

    public void displayGui(IInteractionObject iInteractionObject) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenDisplayGui(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localDisplayGui(iInteractionObject);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.displayGui(iInteractionObject);
        }
    }

    public void afterDisplayGui(IInteractionObject iInteractionObject) {
    }

    public void beforeDisplayGUIChest(IInventory iInventory) {
    }

    public void displayGUIChest(IInventory iInventory) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenDisplayGUIChest(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localDisplayGUIChest(iInventory);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.displayGUIChest(iInventory);
        }
    }

    public void afterDisplayGUIChest(IInventory iInventory) {
    }

    public void beforeDropItem(ItemStack itemStack, boolean bl, boolean bl2) {
    }

    public EntityItem dropItem(ItemStack itemStack, boolean bl, boolean bl2) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenDropItem(this);
        EntityItem entityItem = clientPlayerBase == null ? this.playerAPI.localDropItem(itemStack, bl, bl2) : (clientPlayerBase != this ? clientPlayerBase.dropItem(itemStack, bl, bl2) : null);
        return entityItem;
    }

    public void afterDropItem(ItemStack itemStack, boolean bl, boolean bl2) {
    }

    public void beforeDropOneItem(boolean bl) {
    }

    public EntityItem dropOneItem(boolean bl) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenDropOneItem(this);
        Object object = clientPlayerBase == null ? this.playerAPI.localDropOneItem(bl) : (clientPlayerBase != this ? clientPlayerBase.dropOneItem(bl) : null);
        return object;
    }

    public void afterDropOneItem(boolean bl) {
    }

    public void beforeDropPlayerItemWithRandomChoice(ItemStack itemStack, boolean bl) {
    }

    public EntityItem dropPlayerItemWithRandomChoice(ItemStack itemStack, boolean bl) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenDropPlayerItemWithRandomChoice(this);
        EntityItem entityItem = clientPlayerBase == null ? this.playerAPI.localDropPlayerItemWithRandomChoice(itemStack, bl) : (clientPlayerBase != this ? clientPlayerBase.dropPlayerItemWithRandomChoice(itemStack, bl) : null);
        return entityItem;
    }

    public void afterDropPlayerItemWithRandomChoice(ItemStack itemStack, boolean bl) {
    }

    public void beforeFall(float f, float f2) {
    }

    public void fall(float f, float f2) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenFall(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localFall(f, f2);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.fall(f, f2);
        }
    }

    public void afterFall(float f, float f2) {
    }

    public void beforeGetAIMoveSpeed() {
    }

    public float getAIMoveSpeed() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenGetAIMoveSpeed(this);
        float f = clientPlayerBase == null ? this.playerAPI.localGetAIMoveSpeed() : (clientPlayerBase != this ? clientPlayerBase.getAIMoveSpeed() : 0.0f);
        return f;
    }

    public void afterGetAIMoveSpeed() {
    }

    public void beforeGetBedOrientationInDegrees() {
    }

    public float getBedOrientationInDegrees() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenGetBedOrientationInDegrees(this);
        float f = clientPlayerBase == null ? this.playerAPI.localGetBedOrientationInDegrees() : (clientPlayerBase != this ? clientPlayerBase.getBedOrientationInDegrees() : 0.0f);
        return f;
    }

    public void afterGetBedOrientationInDegrees() {
    }

    public void beforeGetBrightness(float f) {
    }

    public float getBrightness(float f) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenGetBrightness(this);
        float f2 = clientPlayerBase == null ? this.playerAPI.localGetBrightness(f) : (clientPlayerBase != this ? clientPlayerBase.getBrightness(f) : 0.0f);
        return f2;
    }

    public void afterGetBrightness(float f) {
    }

    public void beforeGetBrightnessForRender(float f) {
    }

    public int getBrightnessForRender(float f) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenGetBrightnessForRender(this);
        int n = clientPlayerBase == null ? this.playerAPI.localGetBrightnessForRender(f) : (clientPlayerBase != this ? clientPlayerBase.getBrightnessForRender(f) : 0);
        return n;
    }

    public void afterGetBrightnessForRender(float f) {
    }

    public void beforeGetBreakSpeed(IBlockState iBlockState, BlockPos blockPos) {
    }

    public float getBreakSpeed(IBlockState iBlockState, BlockPos blockPos) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenGetBreakSpeed(this);
        float f = clientPlayerBase == null ? this.playerAPI.localGetBreakSpeed(iBlockState, blockPos) : (clientPlayerBase != this ? clientPlayerBase.getBreakSpeed(iBlockState, blockPos) : 0.0f);
        return f;
    }

    public void afterGetBreakSpeed(IBlockState iBlockState, BlockPos blockPos) {
    }

    public void beforeGetDistanceSq(double d, double d2, double d3) {
    }

    public double getDistanceSq(double d, double d2, double d3) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenGetDistanceSq(this);
        double d4 = clientPlayerBase == null ? this.playerAPI.localGetDistanceSq(d, d2, d3) : (clientPlayerBase != this ? clientPlayerBase.getDistanceSq(d, d2, d3) : 0.0);
        return d4;
    }

    public void afterGetDistanceSq(double d, double d2, double d3) {
    }

    public void beforeGetDistanceSqToEntity(Entity entity) {
    }

    public double getDistanceSqToEntity(Entity entity) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenGetDistanceSqToEntity(this);
        double d = clientPlayerBase == null ? this.playerAPI.localGetDistanceSqToEntity(entity) : (clientPlayerBase != this ? clientPlayerBase.getDistanceSqToEntity(entity) : 0.0);
        return d;
    }

    public void afterGetDistanceSqToEntity(Entity entity) {
    }

    public void beforeGetFovModifier() {
    }

    public float getFovModifier() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenGetFovModifier(this);
        float f = clientPlayerBase == null ? this.playerAPI.localGetFovModifier() : (clientPlayerBase != this ? clientPlayerBase.getFovModifier() : 0.0f);
        return f;
    }

    public void afterGetFovModifier() {
    }

    public void beforeGetHurtSound() {
    }

    public SoundEvent getHurtSound() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenGetHurtSound(this);
        Object object = clientPlayerBase == null ? this.playerAPI.localGetHurtSound() : (clientPlayerBase != this ? clientPlayerBase.getHurtSound() : null);
        return object;
    }

    public void afterGetHurtSound() {
    }

    public void beforeGetName() {
    }

    public String getName() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenGetName(this);
        String string = clientPlayerBase == null ? this.playerAPI.localGetName() : (clientPlayerBase != this ? clientPlayerBase.getName() : null);
        return string;
    }

    public void afterGetName() {
    }

    public void beforeGetSleepTimer() {
    }

    public int getSleepTimer() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenGetSleepTimer(this);
        int n = clientPlayerBase == null ? this.playerAPI.localGetSleepTimer() : (clientPlayerBase != this ? clientPlayerBase.getSleepTimer() : 0);
        return n;
    }

    public void afterGetSleepTimer() {
    }

    public void beforeHandleWaterMovement() {
    }

    public boolean handleWaterMovement() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenHandleWaterMovement(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localHandleWaterMovement() : (clientPlayerBase != this ? clientPlayerBase.handleWaterMovement() : false);
        return bl;
    }

    public void afterHandleWaterMovement() {
    }

    public void beforeHeal(float f) {
    }

    public void heal(float f) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenHeal(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localHeal(f);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.heal(f);
        }
    }

    public void afterHeal(float f) {
    }

    public void beforeIsEntityInsideOpaqueBlock() {
    }

    public boolean isEntityInsideOpaqueBlock() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenIsEntityInsideOpaqueBlock(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localIsEntityInsideOpaqueBlock() : (clientPlayerBase != this ? clientPlayerBase.isEntityInsideOpaqueBlock() : false);
        return bl;
    }

    public void afterIsEntityInsideOpaqueBlock() {
    }

    public void beforeIsInWater() {
    }

    public boolean isInWater() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenIsInWater(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localIsInWater() : (clientPlayerBase != this ? clientPlayerBase.isInWater() : false);
        return bl;
    }

    public void afterIsInWater() {
    }

    public void beforeIsInsideOfMaterial(Material material) {
    }

    public boolean isInsideOfMaterial(Material material) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenIsInsideOfMaterial(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localIsInsideOfMaterial(material) : (clientPlayerBase != this ? clientPlayerBase.isInsideOfMaterial(material) : false);
        return bl;
    }

    public void afterIsInsideOfMaterial(Material material) {
    }

    public void beforeIsOnLadder() {
    }

    public boolean isOnLadder() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenIsOnLadder(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localIsOnLadder() : (clientPlayerBase != this ? clientPlayerBase.isOnLadder() : false);
        return bl;
    }

    public void afterIsOnLadder() {
    }

    public void beforeIsPlayerSleeping() {
    }

    public boolean isPlayerSleeping() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenIsPlayerSleeping(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localIsPlayerSleeping() : (clientPlayerBase != this ? clientPlayerBase.isPlayerSleeping() : false);
        return bl;
    }

    public void afterIsPlayerSleeping() {
    }

    public void beforeIsSneaking() {
    }

    public boolean isSneaking() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenIsSneaking(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localIsSneaking() : (clientPlayerBase != this ? clientPlayerBase.isSneaking() : false);
        return bl;
    }

    public void afterIsSneaking() {
    }

    public void beforeIsSprinting() {
    }

    public boolean isSprinting() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenIsSprinting(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localIsSprinting() : (clientPlayerBase != this ? clientPlayerBase.isSprinting() : false);
        return bl;
    }

    public void afterIsSprinting() {
    }

    public void beforeJump() {
    }

    public void jump() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenJump(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localJump();
        } else if (clientPlayerBase != this) {
            clientPlayerBase.jump();
        }
    }

    public void afterJump() {
    }

    public void beforeKnockBack(Entity entity, float f, double d, double d2) {
    }

    public void knockBack(Entity entity, float f, double d, double d2) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenKnockBack(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localKnockBack(entity, f, d, d2);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.knockBack(entity, f, d, d2);
        }
    }

    public void afterKnockBack(Entity entity, float f, double d, double d2) {
    }

    public void beforeMoveEntity(MoverType moverType, double d, double d2, double d3) {
    }

    public void moveEntity(MoverType moverType, double d, double d2, double d3) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenMoveEntity(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localMoveEntity(moverType, d, d2, d3);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.moveEntity(moverType, d, d2, d3);
        }
    }

    public void afterMoveEntity(MoverType moverType, double d, double d2, double d3) {
    }

    public void beforeMoveEntityWithHeading(float f, float f2) {
    }

    public void moveEntityWithHeading(float f, float f2) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenMoveEntityWithHeading(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localMoveEntityWithHeading(f, f2);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.moveEntityWithHeading(f, f2);
        }
    }

    public void afterMoveEntityWithHeading(float f, float f2) {
    }

    public void beforeMoveFlying(float f, float f2, float f3) {
    }

    public void moveFlying(float f, float f2, float f3) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenMoveFlying(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localMoveFlying(f, f2, f3);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.moveFlying(f, f2, f3);
        }
    }

    public void afterMoveFlying(float f, float f2, float f3) {
    }

    public void beforeOnDeath(DamageSource damageSource) {
    }

    public void onDeath(DamageSource damageSource) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenOnDeath(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localOnDeath(damageSource);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.onDeath(damageSource);
        }
    }

    public void afterOnDeath(DamageSource damageSource) {
    }

    public void beforeOnLivingUpdate() {
    }

    public void onLivingUpdate() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenOnLivingUpdate(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localOnLivingUpdate();
        } else if (clientPlayerBase != this) {
            clientPlayerBase.onLivingUpdate();
        }
    }

    public void afterOnLivingUpdate() {
    }

    public void beforeOnKillEntity(EntityLivingBase entityLivingBase) {
    }

    public void onKillEntity(EntityLivingBase entityLivingBase) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenOnKillEntity(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localOnKillEntity(entityLivingBase);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.onKillEntity(entityLivingBase);
        }
    }

    public void afterOnKillEntity(EntityLivingBase entityLivingBase) {
    }

    public void beforeOnStruckByLightning(EntityLightningBolt entityLightningBolt) {
    }

    public void onStruckByLightning(EntityLightningBolt entityLightningBolt) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenOnStruckByLightning(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localOnStruckByLightning(entityLightningBolt);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.onStruckByLightning(entityLightningBolt);
        }
    }

    public void afterOnStruckByLightning(EntityLightningBolt entityLightningBolt) {
    }

    public void beforeOnUpdate() {
    }

    public void onUpdate() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenOnUpdate(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localOnUpdate();
        } else if (clientPlayerBase != this) {
            clientPlayerBase.onUpdate();
        }
    }

    public void afterOnUpdate() {
    }

    public void beforePlayStepSound(BlockPos blockPos, Block block) {
    }

    public void playStepSound(BlockPos blockPos, Block block) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenPlayStepSound(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localPlayStepSound(blockPos, block);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.playStepSound(blockPos, block);
        }
    }

    public void afterPlayStepSound(BlockPos blockPos, Block block) {
    }

    public void beforePushOutOfBlocks(double d, double d2, double d3) {
    }

    public boolean pushOutOfBlocks(double d, double d2, double d3) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenPushOutOfBlocks(this);
        boolean bl = clientPlayerBase == null ? this.playerAPI.localPushOutOfBlocks(d, d2, d3) : (clientPlayerBase != this ? clientPlayerBase.pushOutOfBlocks(d, d2, d3) : false);
        return bl;
    }

    public void afterPushOutOfBlocks(double d, double d2, double d3) {
    }

    public void beforeRayTrace(double d, float f) {
    }

    public RayTraceResult rayTrace(double d, float f) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenRayTrace(this);
        RayTraceResult rayTraceResult = clientPlayerBase == null ? this.playerAPI.localRayTrace(d, f) : (clientPlayerBase != this ? clientPlayerBase.rayTrace(d, f) : null);
        return rayTraceResult;
    }

    public void afterRayTrace(double d, float f) {
    }

    public void beforeReadEntityFromNBT(NBTTagCompound nBTTagCompound) {
    }

    public void readEntityFromNBT(NBTTagCompound nBTTagCompound) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenReadEntityFromNBT(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localReadEntityFromNBT(nBTTagCompound);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.readEntityFromNBT(nBTTagCompound);
        }
    }

    public void afterReadEntityFromNBT(NBTTagCompound nBTTagCompound) {
    }

    public void beforeRespawnPlayer() {
    }

    public void respawnPlayer() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenRespawnPlayer(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localRespawnPlayer();
        } else if (clientPlayerBase != this) {
            clientPlayerBase.respawnPlayer();
        }
    }

    public void afterRespawnPlayer() {
    }

    public void beforeSetDead() {
    }

    public void setDead() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenSetDead(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localSetDead();
        } else if (clientPlayerBase != this) {
            clientPlayerBase.setDead();
        }
    }

    public void afterSetDead() {
    }

    public void beforeSetPlayerSPHealth(float f) {
    }

    public void setPlayerSPHealth(float f) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenSetPlayerSPHealth(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localSetPlayerSPHealth(f);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.setPlayerSPHealth(f);
        }
    }

    public void afterSetPlayerSPHealth(float f) {
    }

    public void beforeSetPositionAndRotation(double d, double d2, double d3, float f, float f2) {
    }

    public void setPositionAndRotation(double d, double d2, double d3, float f, float f2) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenSetPositionAndRotation(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localSetPositionAndRotation(d, d2, d3, f, f2);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.setPositionAndRotation(d, d2, d3, f, f2);
        }
    }

    public void afterSetPositionAndRotation(double d, double d2, double d3, float f, float f2) {
    }

    public void beforeSetSneaking(boolean bl) {
    }

    public void setSneaking(boolean bl) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenSetSneaking(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localSetSneaking(bl);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.setSneaking(bl);
        }
    }

    public void afterSetSneaking(boolean bl) {
    }

    public void beforeSetSprinting(boolean bl) {
    }

    public void setSprinting(boolean bl) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenSetSprinting(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localSetSprinting(bl);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.setSprinting(bl);
        }
    }

    public void afterSetSprinting(boolean bl) {
    }

    public void beforeTrySleep(BlockPos blockPos) {
    }

    public EntityPlayer.SleepResult trySleep(BlockPos blockPos) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenTrySleep(this);
        Object object = clientPlayerBase == null ? this.playerAPI.localTrySleep(blockPos) : (clientPlayerBase != this ? clientPlayerBase.trySleep(blockPos) : null);
        return object;
    }

    public void afterTrySleep(BlockPos blockPos) {
    }

    public void beforeSwingItem(EnumHand enumHand) {
    }

    public void swingItem(EnumHand enumHand) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenSwingItem(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localSwingItem(enumHand);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.swingItem(enumHand);
        }
    }

    public void afterSwingItem(EnumHand enumHand) {
    }

    public void beforeUpdateEntityActionState() {
    }

    public void updateEntityActionState() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenUpdateEntityActionState(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localUpdateEntityActionState();
        } else if (clientPlayerBase != this) {
            clientPlayerBase.updateEntityActionState();
        }
    }

    public void afterUpdateEntityActionState() {
    }

    public void beforeUpdateRidden() {
    }

    public void updateRidden() {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenUpdateRidden(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localUpdateRidden();
        } else if (clientPlayerBase != this) {
            clientPlayerBase.updateRidden();
        }
    }

    public void afterUpdateRidden() {
    }

    public void beforeWakeUpPlayer(boolean bl, boolean bl2, boolean bl3) {
    }

    public void wakeUpPlayer(boolean bl, boolean bl2, boolean bl3) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenWakeUpPlayer(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localWakeUpPlayer(bl, bl2, bl3);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.wakeUpPlayer(bl, bl2, bl3);
        }
    }

    public void afterWakeUpPlayer(boolean bl, boolean bl2, boolean bl3) {
    }

    public void beforeWriteEntityToNBT(NBTTagCompound nBTTagCompound) {
    }

    public void writeEntityToNBT(NBTTagCompound nBTTagCompound) {
        ClientPlayerBase clientPlayerBase = this.internalClientPlayerAPI.GetOverwrittenWriteEntityToNBT(this);
        if (clientPlayerBase == null) {
            this.playerAPI.localWriteEntityToNBT(nBTTagCompound);
        } else if (clientPlayerBase != this) {
            clientPlayerBase.writeEntityToNBT(nBTTagCompound);
        }
    }

    public void afterWriteEntityToNBT(NBTTagCompound nBTTagCompound) {
    }
}

