/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.automation.item.AWAutomationItemLoader;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStorage;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStorageLarge;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStorageMedium;
import net.shadowmage.ancientwarfare.core.block.BlockIconMap;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;

public class BlockWarehouseStorage
extends Block {
    private BlockIconMap iconMap = new BlockIconMap();

    public BlockWarehouseStorage(String regName) {
        super(Material.field_151576_e);
        this.func_149663_c(regName);
        this.func_149647_a(AWAutomationItemLoader.automationTab);
        this.func_149711_c(2.0f);
    }

    public BlockWarehouseStorage setIcon(int meta, int side, String texName) {
        this.iconMap.setIconTexture(side, meta, texName);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.iconMap.registerIcons(reg);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.iconMap.getIconFor(side, meta);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 1: {
                return new TileWarehouseStorageMedium();
            }
            case 2: {
                return new TileWarehouseStorageLarge();
            }
        }
        return new TileWarehouseStorage();
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int sideHit, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof IInteractableTile && ((IInteractableTile)te).onBlockClicked(player);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int fortune) {
        TileWarehouseStorage tile;
        if (!world.field_72995_K && (tile = (TileWarehouseStorage)world.func_147438_o(x, y, z)) != null) {
            tile.onTileBroken();
        }
        super.func_149749_a(world, x, y, z, block, fortune);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventID, int eventParam) {
        super.func_149696_a(world, x, y, z, eventID, eventParam);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }
}

