/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;

public class ContainerWarehouseControl
extends ContainerTileBase<TileWarehouseBase> {
    public ItemQuantityMap itemMap = new ItemQuantityMap();
    private final ItemQuantityMap cache = new ItemQuantityMap();
    private boolean shouldUpdate = true;
    public int maxStorage = 0;
    public int currentStored = 0;

    public ContainerWarehouseControl(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        this.addPlayerSlots(142);
        ((TileWarehouseBase)this.tileEntity).addViewer(this);
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        ((TileWarehouseBase)this.tileEntity).removeViewer(this);
        super.func_75134_a(par1EntityPlayer);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotClickedIndex) {
        if (player.field_70170_p.field_72995_K) {
            return null;
        }
        Slot slot = this.func_75139_a(slotClickedIndex);
        if (slot == null || !slot.func_75216_d()) {
            return null;
        }
        ItemStack stack = slot.func_75211_c();
        if ((stack = ((TileWarehouseBase)this.tileEntity).tryAdd(stack)) == null) {
            slot.func_75215_d(null);
        }
        this.func_75142_b();
        return null;
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("slotClick")) {
            NBTTagCompound reqTag = tag.func_74775_l("slotClick");
            ItemStack item = null;
            if (reqTag.func_74764_b("reqItem")) {
                item = ItemStack.func_77949_a((NBTTagCompound)reqTag.func_74775_l("reqItem"));
            }
            ((TileWarehouseBase)this.tileEntity).handleSlotClick(this.player, item, reqTag.func_74767_n("isShiftClick"));
        } else if (tag.func_74764_b("changeList")) {
            this.handleChangeList(tag.func_150295_c("changeList", 10));
        } else if (tag.func_74764_b("maxStorage")) {
            this.maxStorage = tag.func_74762_e("maxStorage");
        }
        this.currentStored = this.itemMap.getTotalItemCount();
        this.refreshGui();
    }

    public void handleClientRequestSpecific(ItemStack stack, boolean isShiftClick) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack != null) {
            tag.func_74782_a("reqItem", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74757_a("isShiftClick", isShiftClick);
        NBTTagCompound pktTag = new NBTTagCompound();
        pktTag.func_74782_a("slotClick", (NBTBase)tag);
        this.sendDataToServer(pktTag);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.shouldUpdate) {
            this.synchItemMaps();
            this.shouldUpdate = false;
        }
        if (this.maxStorage != ((TileWarehouseBase)this.tileEntity).getMaxStorage()) {
            this.maxStorage = ((TileWarehouseBase)this.tileEntity).getMaxStorage();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("maxStorage", this.maxStorage);
            this.sendDataToClient(tag);
        }
    }

    private void handleChangeList(NBTTagList changeList) {
        for (int i = 0; i < changeList.func_74745_c(); ++i) {
            NBTTagCompound tag = changeList.func_150305_b(i);
            ItemQuantityMap.ItemHashEntry wrap = ItemQuantityMap.ItemHashEntry.readFromNBT(tag);
            int qty = tag.func_74762_e("qty");
            if (qty == 0) {
                this.itemMap.remove(wrap);
                continue;
            }
            if (wrap == null) continue;
            this.itemMap.put(wrap, qty);
        }
    }

    private void synchItemMaps() {
        NBTTagCompound tag;
        int qty;
        this.cache.clear();
        ((TileWarehouseBase)this.tileEntity).getItems(this.cache);
        ItemQuantityMap warehouseItemMap = this.cache;
        NBTTagList changeList = new NBTTagList();
        for (ItemQuantityMap.ItemHashEntry wrap : this.itemMap.keySet()) {
            qty = this.itemMap.getCount(wrap);
            if (qty == warehouseItemMap.getCount(wrap)) continue;
            qty = warehouseItemMap.getCount(wrap);
            tag = wrap.writeToNBT(new NBTTagCompound());
            tag.func_74768_a("qty", qty);
            changeList.func_74742_a((NBTBase)tag);
            this.itemMap.put(wrap, qty);
        }
        for (ItemQuantityMap.ItemHashEntry entry : warehouseItemMap.keySet()) {
            if (this.itemMap.contains(entry)) continue;
            qty = warehouseItemMap.getCount(entry);
            tag = ItemQuantityMap.ItemHashEntry.writeToNBT(entry, new NBTTagCompound());
            tag.func_74768_a("qty", qty);
            changeList.func_74742_a((NBTBase)tag);
            this.itemMap.put(entry, qty);
        }
        if (changeList.func_74745_c() > 0) {
            tag = new NBTTagCompound();
            tag.func_74782_a("changeList", (NBTBase)changeList);
            this.sendDataToClient(tag);
        }
    }

    public void onWarehouseInventoryUpdated() {
        this.shouldUpdate = true;
    }
}

