/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseCraftingStation;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.item.ItemResearchBook;

public class ContainerWarehouseCraftingStation
extends ContainerTileBase<TileWarehouseCraftingStation> {
    private ItemQuantityMap itemMap = new ItemQuantityMap();
    private final ItemQuantityMap cache = new ItemQuantityMap();
    private boolean shouldUpdate = true;

    public ContainerWarehouseCraftingStation(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        int y1;
        InventoryCrafting inventory = ((TileWarehouseCraftingStation)this.tileEntity).layoutMatrix;
        Object slot = new SlotCrafting(player, (IInventory)inventory, (IInventory)((TileWarehouseCraftingStation)this.tileEntity).result, 0, 134, 26){

            public void func_82870_a(EntityPlayer par1EntityPlayer, ItemStack par2ItemStack) {
                ((TileWarehouseCraftingStation)ContainerWarehouseCraftingStation.this.tileEntity).preItemCrafted();
                super.func_82870_a(par1EntityPlayer, par2ItemStack);
                ((TileWarehouseCraftingStation)ContainerWarehouseCraftingStation.this.tileEntity).onItemCrafted();
            }
        };
        this.func_75146_a((Slot)slot);
        slot = new Slot((IInventory)((TileWarehouseCraftingStation)this.tileEntity).bookInventory, 0, 8, 26){

            public boolean func_75214_a(ItemStack par1ItemStack) {
                return ItemResearchBook.getResearcherName(par1ItemStack) != null;
            }
        };
        this.func_75146_a((Slot)slot);
        int slotNum = 0;
        for (y1 = 0; y1 < 3; ++y1) {
            int y2 = y1 * 18 + 8;
            for (int x1 = 0; x1 < 3; ++x1) {
                int x2 = x1 * 18 + 8 + 54;
                slotNum = y1 * 3 + x1;
                slot = new Slot((IInventory)inventory, slotNum, x2, y2);
                this.func_75146_a((Slot)slot);
            }
        }
        y1 = 70;
        y1 = this.addPlayerSlots(y1);
        TileWarehouseBase warehouse = ((TileWarehouseCraftingStation)this.tileEntity).getWarehouse();
        if (warehouse != null) {
            warehouse.addCraftingViewer(this);
        }
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        TileWarehouseBase warehouse = ((TileWarehouseCraftingStation)this.tileEntity).getWarehouse();
        if (warehouse != null) {
            warehouse.removeCraftingViewer(this);
        }
        super.func_75134_a(par1EntityPlayer);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
        ItemStack slotStackCopy = null;
        Slot theSlot = this.func_75139_a(slotClickedIndex);
        if (theSlot != null && theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            int playerSlotStart = 2 + ((TileWarehouseCraftingStation)this.tileEntity).layoutMatrix.func_70302_i_();
            if (slotClickedIndex < playerSlotStart && !this.func_75135_a(slotStack, playerSlotStart, playerSlotStart + this.playerSlots, false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                theSlot.func_75215_d(null);
            } else {
                theSlot.func_75218_e();
            }
            if (slotStack.field_77994_a == slotStackCopy.field_77994_a) {
                return null;
            }
            theSlot.func_82870_a(par1EntityPlayer, slotStack);
        }
        return slotStackCopy;
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("changeList")) {
            AWLog.logDebug("rec. warehouse item map..");
            this.handleChangeList(tag.func_150295_c("changeList", 10));
        }
        this.refreshGui();
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.shouldUpdate) {
            this.synchItemMaps();
            this.shouldUpdate = false;
        }
    }

    private void handleChangeList(NBTTagList changeList) {
        for (int i = 0; i < changeList.func_74745_c(); ++i) {
            NBTTagCompound tag = changeList.func_150305_b(i);
            ItemQuantityMap.ItemHashEntry wrap = ItemQuantityMap.ItemHashEntry.readFromNBT(tag);
            int qty = tag.func_74762_e("qty");
            if (qty == 0) {
                this.itemMap.remove(wrap);
                continue;
            }
            if (wrap == null) continue;
            this.itemMap.put(wrap, qty);
        }
        TileWarehouseBase warehouse = ((TileWarehouseCraftingStation)this.tileEntity).getWarehouse();
        if (warehouse != null) {
            warehouse.clearItemCache();
            warehouse.addItemsToCache(this.itemMap);
        }
    }

    private void synchItemMaps() {
        NBTTagCompound tag;
        int qty;
        this.cache.clear();
        TileWarehouseBase warehouse = ((TileWarehouseCraftingStation)this.tileEntity).getWarehouse();
        if (warehouse != null) {
            warehouse.getItems(this.cache);
        }
        ItemQuantityMap warehouseItemMap = this.cache;
        NBTTagList changeList = new NBTTagList();
        for (ItemQuantityMap.ItemHashEntry wrap : this.itemMap.keySet()) {
            qty = this.itemMap.getCount(wrap);
            if (qty == warehouseItemMap.getCount(wrap)) continue;
            qty = warehouseItemMap.getCount(wrap);
            tag = wrap.writeToNBT(new NBTTagCompound());
            tag.func_74768_a("qty", qty);
            changeList.func_74742_a((NBTBase)tag);
            this.itemMap.put(wrap, qty);
        }
        for (ItemQuantityMap.ItemHashEntry entry : warehouseItemMap.keySet()) {
            if (this.itemMap.contains(entry)) continue;
            qty = warehouseItemMap.getCount(entry);
            tag = ItemQuantityMap.ItemHashEntry.writeToNBT(entry, new NBTTagCompound());
            tag.func_74768_a("qty", qty);
            changeList.func_74742_a((NBTBase)tag);
            this.itemMap.put(entry, qty);
        }
        if (changeList.func_74745_c() > 0) {
            tag = new NBTTagCompound();
            tag.func_74782_a("changeList", (NBTBase)changeList);
            this.sendDataToClient(tag);
        }
    }

    public void onWarehouseInventoryUpdated() {
        AWLog.logDebug("update callback from warehouse...");
        this.shouldUpdate = true;
    }
}

