/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStorage;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseStorageFilter;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.interfaces.INBTSerialable;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;

public class ContainerWarehouseStorage
extends ContainerTileBase<TileWarehouseStorage> {
    private boolean shouldSynch = true;
    private ItemQuantityMap cache = new ItemQuantityMap();
    public ItemQuantityMap itemMap = new ItemQuantityMap();
    public List<WarehouseStorageFilter> filters = new ArrayList<WarehouseStorageFilter>();

    public ContainerWarehouseStorage(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        ((TileWarehouseStorage)this.tileEntity).addViewer(this);
        this.filters.addAll(((TileWarehouseStorage)this.tileEntity).getFilters());
        this.addPlayerSlots(156);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotClickedIndex) {
        if (player.field_70170_p.field_72995_K) {
            return null;
        }
        Slot slot = this.func_75139_a(slotClickedIndex);
        if (slot == null || !slot.func_75216_d()) {
            return null;
        }
        ItemStack stack = slot.func_75211_c();
        if ((stack = ((TileWarehouseStorage)this.tileEntity).tryAdd(stack)) == null) {
            slot.func_75215_d(null);
        }
        this.func_75142_b();
        return null;
    }

    public void handleClientRequestSpecific(ItemStack stack, boolean isShiftClick) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack != null) {
            tag.func_74782_a("reqItem", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74757_a("isShiftClick", isShiftClick);
        NBTTagCompound pktTag = new NBTTagCompound();
        pktTag.func_74782_a("slotClick", (NBTBase)tag);
        this.sendDataToServer(pktTag);
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        INBTSerialable.Helper.write(tag, "filterList", this.filters);
        this.sendDataToClient(tag);
    }

    public void sendFiltersToServer() {
        NBTTagCompound tag = new NBTTagCompound();
        INBTSerialable.Helper.write(tag, "filterList", this.filters);
        this.sendDataToServer(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("filterList")) {
            List<WarehouseStorageFilter> filters = INBTSerialable.Helper.read(tag, "filterList", WarehouseStorageFilter.class);
            if (this.player.field_70170_p.field_72995_K) {
                this.filters = filters;
                this.refreshGui();
            } else {
                ((TileWarehouseStorage)this.tileEntity).setFilters(filters);
            }
        } else if (tag.func_74764_b("slotClick")) {
            NBTTagCompound reqTag = tag.func_74775_l("slotClick");
            ItemStack item = null;
            if (reqTag.func_74764_b("reqItem")) {
                item = ItemStack.func_77949_a((NBTTagCompound)reqTag.func_74775_l("reqItem"));
            }
            ((TileWarehouseStorage)this.tileEntity).handleSlotClick(this.player, item, reqTag.func_74767_n("isShiftClick"));
        } else if (tag.func_74764_b("changeList")) {
            this.handleChangeList(tag.func_150295_c("changeList", 10));
            this.refreshGui();
        }
        super.handlePacketData(tag);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.shouldSynch) {
            this.synchItemMaps();
            this.shouldSynch = false;
        }
    }

    private void handleChangeList(NBTTagList changeList) {
        for (int i = 0; i < changeList.func_74745_c(); ++i) {
            NBTTagCompound tag = changeList.func_150305_b(i);
            ItemQuantityMap.ItemHashEntry wrap = ItemQuantityMap.ItemHashEntry.readFromNBT(tag);
            int qty = tag.func_74762_e("qty");
            if (qty == 0) {
                this.itemMap.remove(wrap);
                continue;
            }
            if (wrap == null) continue;
            this.itemMap.put(wrap, qty);
        }
    }

    private void synchItemMaps() {
        NBTTagCompound tag;
        int qty;
        this.cache.clear();
        ((TileWarehouseStorage)this.tileEntity).addItems(this.cache);
        ItemQuantityMap warehouseItemMap = this.cache;
        NBTTagList changeList = new NBTTagList();
        for (ItemQuantityMap.ItemHashEntry wrap : this.itemMap.keySet()) {
            qty = this.itemMap.getCount(wrap);
            if (qty == warehouseItemMap.getCount(wrap)) continue;
            qty = warehouseItemMap.getCount(wrap);
            tag = wrap.writeToNBT(new NBTTagCompound());
            tag.func_74768_a("qty", qty);
            changeList.func_74742_a((NBTBase)tag);
            this.itemMap.put(wrap, qty);
        }
        for (ItemQuantityMap.ItemHashEntry entry : warehouseItemMap.keySet()) {
            if (this.itemMap.contains(entry)) continue;
            qty = warehouseItemMap.getCount(entry);
            tag = ItemQuantityMap.ItemHashEntry.writeToNBT(entry, new NBTTagCompound());
            tag.func_74768_a("qty", qty);
            changeList.func_74742_a((NBTBase)tag);
            this.itemMap.put(entry, qty);
        }
        if (changeList.func_74745_c() > 0) {
            tag = new NBTTagCompound();
            tag.func_74782_a("changeList", (NBTBase)changeList);
            this.sendDataToClient(tag);
        }
    }

    public void onStorageInventoryUpdated() {
        this.shouldSynch = true;
    }

    public void onFilterListUpdated() {
        this.filters.clear();
        this.filters.addAll(((TileWarehouseStorage)this.tileEntity).getFilters());
        this.sendInitData();
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        ((TileWarehouseStorage)this.tileEntity).removeViewer(this);
        super.func_75134_a(par1EntityPlayer);
    }
}

