/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteUserBlocks;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.interfaces.IBoundedSite;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;

public class ContainerWorksiteBoundsAdjust
extends ContainerTileBase {
    public BlockPosition min;
    public BlockPosition max;

    public ContainerWorksiteBoundsAdjust(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        if (!(this.tileEntity instanceof IBoundedSite)) {
            throw new IllegalArgumentException("Couldn't find work site");
        }
        this.min = this.getWorksite().getWorkBoundsMin().copy();
        this.max = this.getWorksite().getWorkBoundsMax().copy();
    }

    @Override
    public void sendInitData() {
        if (this.tileEntity instanceof TileWorksiteUserBlocks) {
            TileWorksiteUserBlocks twub = (TileWorksiteUserBlocks)this.tileEntity;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74773_a("checkedMap", twub.getTargetMap());
            this.sendDataToGui(tag);
        }
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("guiClosed")) {
            if (tag.func_74764_b("min") && tag.func_74764_b("max")) {
                BlockPosition min = new BlockPosition(tag.func_74775_l("min"));
                BlockPosition max = new BlockPosition(tag.func_74775_l("max"));
                this.getWorksite().setWorkBoundsMin(min);
                this.getWorksite().setWorkBoundsMax(max);
                this.getWorksite().onBoundsAdjusted();
                this.getWorksite().onPostBoundsAdjusted();
            }
            if (tag.func_74764_b("checkedMap") && this.tileEntity instanceof TileWorksiteUserBlocks) {
                TileWorksiteUserBlocks twub = (TileWorksiteUserBlocks)this.tileEntity;
                byte[] map = tag.func_74770_j("checkedMap");
                twub.setTargetBlocks(map);
            }
            this.player.field_70170_p.func_147471_g(this.getX(), this.getY(), this.getZ());
        }
    }

    public void onClose(boolean boundsAdjusted, boolean targetsAdjusted, byte[] checkedMap) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("guiClosed", true);
        if (boundsAdjusted) {
            tag.func_74782_a("min", (NBTBase)this.min.writeToNBT(new NBTTagCompound()));
            tag.func_74782_a("max", (NBTBase)this.max.writeToNBT(new NBTTagCompound()));
        }
        if (targetsAdjusted && this.tileEntity instanceof TileWorksiteUserBlocks) {
            tag.func_74773_a("checkedMap", checkedMap);
        }
        this.sendDataToServer(tag);
    }

    public int getX() {
        return this.tileEntity.field_145851_c;
    }

    public int getY() {
        return this.tileEntity.field_145848_d;
    }

    public int getZ() {
        return this.tileEntity.field_145849_e;
    }

    public IBoundedSite getWorksite() {
        return (IBoundedSite)this.tileEntity;
    }
}

