/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseStorage;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseStorageFilter;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeItemSlots;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;

public class GuiWarehouseStorage
extends GuiContainerBase<ContainerWarehouseStorage> {
    private CompositeScrolled area;
    private CompositeItemSlots area2;

    public GuiWarehouseStorage(ContainerBase par1Container) {
        super(par1Container, 178, 240);
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 0, this.field_146999_f, 74);
        this.addGuiElement(this.area);
        Listener l = new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (evt.mButton == 0 && widget.isMouseOverElement(evt.mx, evt.my) && !GuiWarehouseStorage.this.area2.isMouseOverSubElement(evt.mx, evt.my)) {
                    ((ContainerWarehouseStorage)((Object)GuiWarehouseStorage.this.getContainer())).handleClientRequestSpecific(null, GuiScreen.func_146272_n());
                }
                return true;
            }
        };
        this.area2 = new CompositeItemSlots(this, 0, 74, this.field_146999_f, 74, this);
        this.area2.addNewListener(l);
        this.addGuiElement(this.area2);
    }

    @Override
    public void setupElements() {
        Button button;
        this.area.clearElements();
        this.area2.clearElements();
        this.addInventoryViewElements();
        List<WarehouseStorageFilter> filters = ((ContainerWarehouseStorage)((Object)this.getContainer())).filters;
        int totalHeight = 8;
        for (WarehouseStorageFilter filter : filters) {
            FilterItemSlot slot = new FilterItemSlot(8, totalHeight, filter, this);
            this.area.addGuiElement(slot);
            String name = filter.getFilterItem() == null ? "" : filter.getFilterItem().func_82833_r();
            Label label = new Label(28, totalHeight + 4, name);
            this.area.addGuiElement(label);
            button = new FilterRemoveButton(this.field_146999_f - 16 - 12, totalHeight + 3, filter);
            this.area.addGuiElement(button);
            totalHeight += 18;
        }
        if (filters.size() < 10) {
            button = new Button(8, totalHeight, 95, 12, "guistrings.automation.new_filter"){

                @Override
                protected void onPressed() {
                    WarehouseStorageFilter filter = new WarehouseStorageFilter(null);
                    ((ContainerWarehouseStorage)((Object)GuiWarehouseStorage.this.getContainer())).filters.add(filter);
                    ((ContainerWarehouseStorage)((Object)GuiWarehouseStorage.this.getContainer())).sendFiltersToServer();
                    GuiWarehouseStorage.this.refreshGui();
                }
            };
            this.area.addGuiElement(button);
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
    }

    private void addInventoryViewElements() {
        int x = 0;
        int y = 0;
        int totalSize = 8;
        ArrayList<ItemStack> displayStacks = new ArrayList<ItemStack>();
        for (ItemQuantityMap.ItemHashEntry entry : ((ContainerWarehouseStorage)((Object)this.getContainer())).itemMap.keySet()) {
            int qty = ((ContainerWarehouseStorage)((Object)this.getContainer())).itemMap.getCount(entry);
            ItemStack stack = entry.getItemStack();
            stack.field_77994_a = qty;
            displayStacks.add(stack);
        }
        for (ItemStack displayStack : displayStacks) {
            ItemSlot slot = new ItemSlot(4 + x * 18, 8 + y * 18, displayStack, this){

                @Override
                public void onSlotClicked(ItemStack stack) {
                    ((ContainerWarehouseStorage)((Object)GuiWarehouseStorage.this.getContainer())).handleClientRequestSpecific(this.getStack(), GuiScreen.func_146272_n());
                }
            };
            this.area2.addGuiElement(slot);
            if (++x < 9) continue;
            x = 0;
            ++y;
            totalSize += 18;
        }
        this.area2.setAreaSize(totalSize);
    }

    private class FilterItemSlot
    extends ItemSlot {
        final WarehouseStorageFilter filter;

        public FilterItemSlot(int topLeftX, int topLeftY, WarehouseStorageFilter filter, ITooltipRenderer render) {
            super(topLeftX, topLeftY, filter.getFilterItem(), render);
            this.filter = filter;
        }

        @Override
        public void onSlotClicked(ItemStack stack) {
            ItemStack in = stack == null ? null : stack.func_77946_l();
            this.setItem(in);
            if (in != null) {
                in.field_77994_a = 1;
            }
            this.filter.setFilterItem(in == null ? null : in.func_77946_l());
            ((ContainerWarehouseStorage)((Object)GuiWarehouseStorage.this.getContainer())).sendFiltersToServer();
        }
    }

    private class FilterRemoveButton
    extends Button {
        final WarehouseStorageFilter filter;

        public FilterRemoveButton(int topLeftX, int topLeftY, WarehouseStorageFilter filter) {
            super(topLeftX, topLeftY, 12, 12, "-");
            this.filter = filter;
        }

        @Override
        protected void onPressed() {
            ((ContainerWarehouseStorage)((Object)GuiWarehouseStorage.this.getContainer())).filters.remove(this.filter);
            ((ContainerWarehouseStorage)((Object)GuiWarehouseStorage.this.getContainer())).sendFiltersToServer();
            GuiWarehouseStorage.this.refreshGui();
        }
    }
}

