/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileSterlingEngine;
import net.shadowmage.ancientwarfare.core.model.ModelBaseAW;
import net.shadowmage.ancientwarfare.core.model.ModelLoader;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import org.lwjgl.opengl.GL11;

public class RenderSterlingEngine
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private final ModelBaseAW model;
    private final ResourceLocation texture;
    private final ModelPiece flywheel;
    private final ModelPiece pistonCrank;
    private final ModelPiece pistonCrank2;
    private final ModelPiece flywheel_arm;
    private final ModelPiece piston_arm;
    private final ModelPiece piston_arm2;
    float pistonPos;
    float armAngle;
    float pistonPos2;
    float armAngle2;

    public RenderSterlingEngine() {
        ModelLoader loader = new ModelLoader();
        this.texture = new ResourceLocation("ancientwarfare:textures/model/automation/sterling_engine.png");
        this.model = loader.loadModel(((Object)((Object)this)).getClass().getResourceAsStream("/assets/ancientwarfare/models/automation/sterling_engine.m2f"));
        this.flywheel = this.model.getPiece("flywheel2");
        this.pistonCrank = this.model.getPiece("piston_crank");
        this.pistonCrank2 = this.model.getPiece("piston_crank2");
        this.flywheel_arm = this.model.getPiece("flywheel_arm");
        this.piston_arm = this.model.getPiece("piston_arm");
        this.piston_arm2 = this.model.getPiece("piston_arm2");
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTick) {
        TileSterlingEngine tt = (TileSterlingEngine)tile;
        ForgeDirection d = tt.getPrimaryFacing();
        float baseRotation = d == ForgeDirection.SOUTH ? 180.0f : (d == ForgeDirection.WEST ? 270.0f : (d == ForgeDirection.EAST ? 90.0f : 0.0f));
        float rotation = -tt.getClientOutputRotation(d, partialTick);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotatef((float)(-baseRotation), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(this.texture);
        this.flywheel.setRotation(0.0f, 0.0f, rotation);
        this.pistonCrank2.setRotation(0.0f, 0.0f, rotation);
        this.flywheel_arm.setRotation(0.0f, 0.0f, -rotation);
        this.calculateArmAngle1(-rotation);
        this.calculateArmAngle2(-rotation - 90.0f);
        this.pistonCrank.setRotation(0.0f, 0.0f, -rotation);
        this.piston_arm.setRotation(0.0f, 0.0f, rotation + this.armAngle);
        this.piston_arm2.setRotation(0.0f, 0.0f, rotation + this.armAngle2);
        this.model.renderModel();
        GL11.glPopMatrix();
    }

    private void calculateArmAngle1(float crankAngle) {
        float ra = crankAngle * ((float)Math.PI / 180);
        float crankDistance = 1.0f;
        float crankLength = 9.0f;
        this.calculatePistonPosition1(ra, crankDistance, crankLength);
    }

    private void calculatePistonPosition1(float crankAngleRadians, float radius, float length) {
        float cA = MathHelper.func_76134_b((float)crankAngleRadians);
        float sA = MathHelper.func_76126_a((float)crankAngleRadians);
        this.pistonPos = radius * cA + MathHelper.func_76129_c((float)(length * length - radius * radius * sA * sA));
        float bx = sA * radius;
        float by = cA * radius;
        float cx = 0.0f;
        float cy = this.pistonPos;
        float rlrA = (float)Math.atan2(cx - bx, cy - by);
        this.armAngle = rlrA * 57.295776f;
    }

    private void calculateArmAngle2(float crankAngle) {
        float ra = crankAngle * ((float)Math.PI / 180);
        float crankDistance = 1.0f;
        float crankLength = 7.0f;
        this.calculatePistonPosition2(ra, crankDistance, crankLength);
    }

    private void calculatePistonPosition2(float crankAngleRadians, float radius, float length) {
        float cA = MathHelper.func_76134_b((float)crankAngleRadians);
        float sA = MathHelper.func_76126_a((float)crankAngleRadians);
        this.pistonPos2 = radius * cA + MathHelper.func_76129_c((float)(length * length - radius * radius * sA * sA));
        float bx = sA * radius;
        float by = cA * radius;
        float cx = 0.0f;
        float cy = this.pistonPos2;
        float rlrA = (float)Math.atan2(cx - bx, cy - by);
        this.armAngle2 = rlrA * 57.295776f;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
        this.func_147499_a(this.texture);
        this.flywheel.setRotation(0.0f, 0.0f, 0.0f);
        this.pistonCrank2.setRotation(0.0f, 0.0f, 0.0f);
        this.flywheel_arm.setRotation(0.0f, 0.0f, 0.0f);
        this.pistonCrank.setRotation(0.0f, 0.0f, 0.0f);
        this.piston_arm.setRotation(0.0f, 0.0f, 0.0f);
        this.piston_arm2.setRotation(0.0f, 0.0f, 0.0f);
        this.model.renderModel();
        GL11.glPopMatrix();
    }
}

