/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.shadowmage.ancientwarfare.automation.tile.torque.multiblock.TileFlywheelStorage;
import net.shadowmage.ancientwarfare.core.model.ModelBaseAW;
import net.shadowmage.ancientwarfare.core.model.ModelLoader;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import org.lwjgl.opengl.GL11;

public class RenderTileFlywheelStorage
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private final ModelBaseAW smallModel;
    private final ModelBaseAW largeModel;
    private final ResourceLocation[] smallTex = new ResourceLocation[3];
    private final ResourceLocation[] largeTex = new ResourceLocation[3];
    private final ModelPiece spindleSmall;
    private final ModelPiece upperShroudSmall;
    private final ModelPiece lowerShroudSmall;
    private final ModelPiece flywheelExtensionSmall;
    private final ModelPiece lowerWindowSmall;
    private final ModelPiece upperWindowSmall;
    private final ModelPiece caseBarsSmall;
    private final ModelPiece spindleLarge;
    private final ModelPiece upperShroudLarge;
    private final ModelPiece lowerShroudLarge;
    private final ModelPiece flywheelExtensionLarge;
    private final ModelPiece lowerWindowLarge;
    private final ModelPiece upperWindowLarge;
    private final ModelPiece caseBarsLarge;

    public RenderTileFlywheelStorage() {
        ModelLoader loader = new ModelLoader();
        this.smallTex[0] = new ResourceLocation("ancientwarfare", "textures/model/automation/flywheel_small_light.png");
        this.smallTex[1] = new ResourceLocation("ancientwarfare", "textures/model/automation/flywheel_small_medium.png");
        this.smallTex[2] = new ResourceLocation("ancientwarfare", "textures/model/automation/flywheel_small_heavy.png");
        this.largeTex[0] = new ResourceLocation("ancientwarfare", "textures/model/automation/flywheel_large_light.png");
        this.largeTex[1] = new ResourceLocation("ancientwarfare", "textures/model/automation/flywheel_large_medium.png");
        this.largeTex[2] = new ResourceLocation("ancientwarfare", "textures/model/automation/flywheel_large_heavy.png");
        this.smallModel = loader.loadModel(((Object)((Object)this)).getClass().getResourceAsStream("/assets/ancientwarfare/models/automation/flywheel_small.m2f"));
        this.spindleSmall = this.smallModel.getPiece("spindle");
        this.upperShroudSmall = this.smallModel.getPiece("shroudUpper");
        this.lowerShroudSmall = this.smallModel.getPiece("shroudLower");
        this.flywheelExtensionSmall = this.smallModel.getPiece("flywheelExtension");
        this.lowerWindowSmall = this.smallModel.getPiece("windowLower");
        this.upperWindowSmall = this.smallModel.getPiece("windowUpper");
        this.caseBarsSmall = this.smallModel.getPiece("caseBars");
        this.largeModel = loader.loadModel(((Object)((Object)this)).getClass().getResourceAsStream("/assets/ancientwarfare/models/automation/flywheel_large.m2f"));
        this.spindleLarge = this.largeModel.getPiece("spindle");
        this.upperShroudLarge = this.largeModel.getPiece("shroudUpper");
        this.lowerShroudLarge = this.largeModel.getPiece("shroudLower");
        this.flywheelExtensionLarge = this.largeModel.getPiece("flywheelExtension");
        this.lowerWindowLarge = this.largeModel.getPiece("windowLower");
        this.upperWindowLarge = this.largeModel.getPiece("windowUpper");
        this.caseBarsLarge = this.largeModel.getPiece("caseBars");
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float delta) {
        TileFlywheelStorage storage = (TileFlywheelStorage)te;
        if (storage.controllerPos == null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
            this.renderSmallModel(te.func_145832_p(), 1, 0.0f, MinecraftForgeClient.getRenderPass());
            GL11.glPopMatrix();
        } else if (storage.isControl) {
            int pass = MinecraftForgeClient.getRenderPass();
            GL11.glPushMatrix();
            float rotation = (float)this.getRotation(storage.rotation, storage.prevRotation, delta);
            if (storage.setType >= 0 && storage.setHeight > 0) {
                GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
                if (storage.setWidth > 1) {
                    this.renderLargeModel(te.func_145832_p(), storage.setHeight, -rotation, pass);
                } else {
                    this.renderSmallModel(te.func_145832_p(), storage.setHeight, -rotation, pass);
                }
            }
            GL11.glPopMatrix();
        }
    }

    protected void renderSmallModel(int type, int height, float rotation, int pass) {
        this.func_147499_a(this.smallTex[type]);
        GL11.glPushMatrix();
        if (pass == 0) {
            this.spindleSmall.setRotation(0.0f, rotation, 0.0f);
            this.spindleSmall.setVisible(true);
            this.caseBarsSmall.setVisible(true);
            this.upperWindowSmall.setVisible(false);
            this.lowerWindowSmall.setVisible(false);
        } else {
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            this.caseBarsSmall.setVisible(false);
            this.spindleSmall.setVisible(false);
            this.lowerWindowSmall.setVisible(true);
            this.flywheelExtensionSmall.setVisible(false);
            this.upperShroudSmall.setVisible(false);
            this.lowerShroudSmall.setVisible(false);
        }
        for (int i = 0; i < height; ++i) {
            if (pass == 0) {
                this.flywheelExtensionSmall.setVisible(i < height - 1);
                this.upperShroudSmall.setVisible(i == height - 1);
                this.lowerShroudSmall.setVisible(i == 0);
                this.smallModel.renderModel();
            } else {
                this.upperWindowSmall.setVisible(i < height - 1);
                this.smallModel.renderModel();
            }
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (pass == 1) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    protected void renderLargeModel(int type, int height, float rotation, int pass) {
        this.func_147499_a(this.largeTex[type]);
        GL11.glPushMatrix();
        if (pass == 0) {
            this.spindleLarge.setRotation(0.0f, rotation, 0.0f);
            this.spindleLarge.setVisible(true);
            this.caseBarsLarge.setVisible(true);
            this.upperWindowLarge.setVisible(false);
            this.lowerWindowLarge.setVisible(false);
        } else {
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            this.caseBarsLarge.setVisible(false);
            this.spindleLarge.setVisible(false);
            this.lowerWindowLarge.setVisible(true);
            this.flywheelExtensionLarge.setVisible(false);
            this.upperShroudLarge.setVisible(false);
            this.lowerShroudLarge.setVisible(false);
        }
        for (int i = 0; i < height; ++i) {
            if (pass == 0) {
                this.flywheelExtensionLarge.setVisible(i < height - 1);
                this.upperShroudLarge.setVisible(i == height - 1);
                this.lowerShroudLarge.setVisible(i == 0);
                this.largeModel.renderModel();
            } else {
                this.upperWindowLarge.setVisible(i < height - 1);
                this.largeModel.renderModel();
            }
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (pass == 1) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    private double getRotation(double rotation, double prevRotation, float delta) {
        double rd = rotation - prevRotation;
        return prevRotation + rd * (double)delta;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
        this.renderSmallModel(item.func_77960_j(), 1, 0.0f, 0);
        GL11.glPopMatrix();
    }
}

