/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileFlywheelControl;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.model.ModelBaseAW;
import net.shadowmage.ancientwarfare.core.model.ModelLoader;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import org.lwjgl.opengl.GL11;

public class RenderTileTorqueFlywheelController
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private float[][] gearboxRotationMatrix = new float[6][];
    private final ModelBaseAW controllerModel;
    private final ModelPiece controlInput;
    private final ModelPiece controlOutput;
    private final ModelPiece controlSpindle;
    private final ResourceLocation[] texture = new ResourceLocation[3];

    public RenderTileTorqueFlywheelController() {
        this.texture[0] = new ResourceLocation("ancientwarfare", "textures/model/automation/flywheel_controller_light.png");
        this.texture[1] = new ResourceLocation("ancientwarfare", "textures/model/automation/flywheel_controller_medium.png");
        this.texture[2] = new ResourceLocation("ancientwarfare", "textures/model/automation/flywheel_controller_heavy.png");
        ModelLoader loader = new ModelLoader();
        this.controllerModel = loader.loadModel(((Object)((Object)this)).getClass().getResourceAsStream("/assets/ancientwarfare/models/automation/flywheel_controller.m2f"));
        this.controlInput = this.controllerModel.getPiece("inputGear");
        this.controlOutput = this.controllerModel.getPiece("outputGear");
        this.controlSpindle = this.controllerModel.getPiece("spindle");
        this.gearboxRotationMatrix[0] = new float[]{-90.0f, 0.0f, 0.0f};
        this.gearboxRotationMatrix[1] = new float[]{90.0f, 0.0f, 0.0f};
        this.gearboxRotationMatrix[2] = new float[]{0.0f, 0.0f, 0.0f};
        this.gearboxRotationMatrix[3] = new float[]{0.0f, 180.0f, 0.0f};
        this.gearboxRotationMatrix[4] = new float[]{0.0f, 90.0f, 0.0f};
        this.gearboxRotationMatrix[5] = new float[]{0.0f, 270.0f, 0.0f};
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float delta) {
        float outputRotation;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        TileFlywheelControl flywheel = (TileFlywheelControl)te;
        ITorque.ITorqueTile[] neighbors = flywheel.getTorqueCache();
        ForgeDirection d = flywheel.getPrimaryFacing();
        float inputRotation = outputRotation = flywheel.getClientOutputRotation(d, delta);
        float flywheelRotation = flywheel.getFlywheelRotation(delta);
        ITorque.ITorqueTile inputNeighbor = neighbors[d.getOpposite().ordinal()];
        if (inputNeighbor != null && inputNeighbor.canOutputTorque(d) && inputNeighbor.useOutputRotation(d.getOpposite())) {
            inputRotation = inputNeighbor.getClientOutputRotation(d.getOpposite(), delta);
        }
        this.func_147499_a(this.texture[te.func_145832_p() % this.texture.length]);
        this.renderModel(outputRotation, inputRotation, flywheelRotation, d.ordinal());
        GL11.glPopMatrix();
    }

    protected void renderModel(float outR, float inR, float wheelR, int face) {
        float[] rot = this.gearboxRotationMatrix[face];
        if (rot[0] != 0.0f) {
            GL11.glRotatef((float)rot[0], (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (rot[1] != 0.0f) {
            GL11.glRotatef((float)rot[1], (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rot[2] != 0.0f) {
            GL11.glRotatef((float)rot[2], (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.controlInput.setRotation(0.0f, 0.0f, -inR);
        this.controlOutput.setRotation(0.0f, 0.0f, -outR);
        this.controlSpindle.setRotation(0.0f, -wheelR, 0.0f);
        this.controllerModel.renderModel();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        this.func_147499_a(this.texture[item.func_77960_j() % this.texture.length]);
        this.renderModel(0.0f, 0.0f, 0.0f, 2);
        GL11.glPopMatrix();
    }
}

