/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueShaft;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.model.ModelBaseAW;
import net.shadowmage.ancientwarfare.core.model.ModelLoader;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import org.lwjgl.opengl.GL11;

public class RenderTileTorqueShaft
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private final float[][] gearboxRotationMatrix = new float[6][];
    private final ModelBaseAW model;
    private final ModelPiece inputHead;
    private final ModelPiece outputHead;
    private final ModelPiece shaft;
    private final ModelPiece gearbox;
    private final ResourceLocation[] textures = new ResourceLocation[3];

    public RenderTileTorqueShaft(ResourceLocation light, ResourceLocation med, ResourceLocation heavy) {
        this.textures[0] = light;
        this.textures[1] = med;
        this.textures[2] = heavy;
        ModelLoader loader = new ModelLoader();
        this.model = loader.loadModel(((Object)((Object)this)).getClass().getResourceAsStream("/assets/ancientwarfare/models/automation/torque_shaft.m2f"));
        this.inputHead = this.model.getPiece("southShaft");
        this.outputHead = this.model.getPiece("northShaft");
        this.shaft = this.model.getPiece("shaft");
        this.gearbox = this.model.getPiece("gearBox");
        this.gearboxRotationMatrix[0] = new float[]{-90.0f, 0.0f, 0.0f};
        this.gearboxRotationMatrix[1] = new float[]{90.0f, 0.0f, 0.0f};
        this.gearboxRotationMatrix[2] = new float[]{0.0f, 0.0f, 0.0f};
        this.gearboxRotationMatrix[3] = new float[]{0.0f, 180.0f, 0.0f};
        this.gearboxRotationMatrix[4] = new float[]{0.0f, 90.0f, 0.0f};
        this.gearboxRotationMatrix[5] = new float[]{0.0f, 270.0f, 0.0f};
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float delta) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        TileTorqueShaft shaft = (TileTorqueShaft)te;
        ForgeDirection d = shaft.getPrimaryFacing();
        float[] rotations = this.gearboxRotationMatrix[d.ordinal()];
        if (rotations[0] != 0.0f) {
            GL11.glRotatef((float)rotations[0], (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (rotations[1] != 0.0f) {
            GL11.glRotatef((float)rotations[1], (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotations[2] != 0.0f) {
            GL11.glRotatef((float)rotations[2], (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.inputHead.setVisible(shaft.prev() == null);
        this.gearbox.setVisible(shaft.prev() == null);
        this.outputHead.setVisible(shaft.next() == null);
        float rotation = shaft.getClientOutputRotation(d, delta);
        this.shaft.setRotation(0.0f, 0.0f, -rotation);
        this.outputHead.setRotation(0.0f, 0.0f, -rotation);
        if (shaft.prev() == null) {
            ITorque.ITorqueTile itt = shaft.getTorqueCache()[d.getOpposite().ordinal()];
            if (itt != null && itt.canOutputTorque(d) && itt.useOutputRotation(null)) {
                rotation = itt.getClientOutputRotation(d, delta);
            }
            this.inputHead.setRotation(0.0f, 0.0f, -rotation);
        }
        this.func_147499_a(this.textures[te.func_145832_p() % this.textures.length]);
        this.model.renderModel();
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        float[] rotations = this.gearboxRotationMatrix[1];
        if (rotations[0] != 0.0f) {
            GL11.glRotatef((float)rotations[0], (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (rotations[1] != 0.0f) {
            GL11.glRotatef((float)rotations[1], (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotations[2] != 0.0f) {
            GL11.glRotatef((float)rotations[2], (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.inputHead.setVisible(true);
        this.gearbox.setVisible(true);
        this.outputHead.setVisible(true);
        this.shaft.setRotation(0.0f, 0.0f, 0.0f);
        this.outputHead.setRotation(0.0f, 0.0f, 0.0f);
        this.inputHead.setRotation(0.0f, 0.0f, 0.0f);
        this.func_147499_a(this.textures[item.func_77960_j() % this.textures.length]);
        this.model.renderModel();
        GL11.glPopMatrix();
    }
}

