/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSidedCell;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.model.ModelBaseAW;
import net.shadowmage.ancientwarfare.core.model.ModelLoader;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import org.lwjgl.opengl.GL11;

public class RenderTileTorqueTransport
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private static float[][] headRotationDirectionMatrix = new float[6][];
    private static float[][] gearboxRotationMatrix = new float[6][];
    private static ModelBaseAW model = null;
    private static ModelPiece[] gearHeads = null;
    private static ModelPiece gearbox = null;
    private static float textureWidth;
    private static float textureHeight;
    private final ResourceLocation[] textures = new ResourceLocation[3];

    public RenderTileTorqueTransport(ResourceLocation light, ResourceLocation med, ResourceLocation heavy) {
        this.constructModel();
        this.textures[0] = light;
        this.textures[1] = med;
        this.textures[2] = heavy;
    }

    private void constructModel() {
        if (model == null) {
            ModelLoader loader = new ModelLoader();
            model = loader.loadModel(((Object)((Object)this)).getClass().getResourceAsStream("/assets/ancientwarfare/models/automation/torque_conduit.m2f"));
            gearHeads = new ModelPiece[6];
            RenderTileTorqueTransport.gearHeads[0] = model.getPiece("downShaft");
            RenderTileTorqueTransport.gearHeads[1] = model.getPiece("upShaft");
            RenderTileTorqueTransport.gearHeads[2] = model.getPiece("northShaft");
            RenderTileTorqueTransport.gearHeads[3] = model.getPiece("southShaft");
            RenderTileTorqueTransport.gearHeads[4] = model.getPiece("westShaft");
            RenderTileTorqueTransport.gearHeads[5] = model.getPiece("eastShaft");
            gearbox = model.getPiece("gearBox");
            textureWidth = model.textureWidth();
            textureHeight = model.textureHeight();
            RenderTileTorqueTransport.headRotationDirectionMatrix[0] = new float[]{0.0f, -1.0f, 0.0f};
            RenderTileTorqueTransport.headRotationDirectionMatrix[1] = new float[]{0.0f, 1.0f, 0.0f};
            RenderTileTorqueTransport.headRotationDirectionMatrix[2] = new float[]{0.0f, 0.0f, -1.0f};
            RenderTileTorqueTransport.headRotationDirectionMatrix[3] = new float[]{0.0f, 0.0f, 1.0f};
            RenderTileTorqueTransport.headRotationDirectionMatrix[4] = new float[]{-1.0f, 0.0f, 0.0f};
            RenderTileTorqueTransport.headRotationDirectionMatrix[5] = new float[]{1.0f, 0.0f, 0.0f};
            RenderTileTorqueTransport.gearboxRotationMatrix[0] = new float[]{-90.0f, 0.0f, 0.0f};
            RenderTileTorqueTransport.gearboxRotationMatrix[1] = new float[]{90.0f, 0.0f, 0.0f};
            RenderTileTorqueTransport.gearboxRotationMatrix[2] = new float[]{0.0f, 0.0f, 0.0f};
            RenderTileTorqueTransport.gearboxRotationMatrix[3] = new float[]{0.0f, 180.0f, 0.0f};
            RenderTileTorqueTransport.gearboxRotationMatrix[4] = new float[]{0.0f, 90.0f, 0.0f};
            RenderTileTorqueTransport.gearboxRotationMatrix[5] = new float[]{0.0f, 270.0f, 0.0f};
        }
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float delta) {
        float[] rotationArray;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        TileTorqueSidedCell conduit = (TileTorqueSidedCell)te;
        ITorque.ITorqueTile[] neighbors = conduit.getTorqueCache();
        boolean[] connections = conduit.getConnections();
        float rotation = conduit.getClientOutputRotation(conduit.getPrimaryFacing(), delta);
        this.func_147499_a(this.textures[te.func_145832_p() % this.textures.length]);
        for (int i = 0; i < 6; ++i) {
            float rz;
            float ry;
            float rx;
            if (!connections[i]) continue;
            ModelPiece piece = gearHeads[i];
            rotationArray = headRotationDirectionMatrix[i];
            if (conduit.canOutputTorque(ForgeDirection.getOrientation((int)i))) {
                rx = rotationArray[0] * rotation;
                ry = rotationArray[1] * rotation;
                rz = rotationArray[2] * rotation;
                piece.setRotation(rx, ry, rz);
            } else {
                if (neighbors != null && neighbors[i] != null && neighbors[i].useOutputRotation(null)) {
                    float r = neighbors[i].getClientOutputRotation(ForgeDirection.values()[i].getOpposite(), delta);
                    rx = rotationArray[0] * r;
                    ry = rotationArray[1] * r;
                    rz = rotationArray[2] * r;
                } else {
                    rx = rotationArray[0] * rotation;
                    ry = rotationArray[1] * rotation;
                    rz = rotationArray[2] * rotation;
                }
                piece.setRotation(-rx, -ry, -rz);
            }
            piece.render(textureWidth, textureHeight);
        }
        ForgeDirection d = conduit.getPrimaryFacing();
        rotationArray = gearboxRotationMatrix[d.ordinal()];
        gearbox.setRotation(rotationArray[0], rotationArray[1], rotationArray[2]);
        gearbox.render(textureWidth, textureHeight);
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        this.func_147499_a(this.textures[item.func_77960_j() % this.textures.length]);
        for (int i = 0; i < 2; ++i) {
            gearHeads[i].setRotation(0.0f, 0.0f, 0.0f);
            gearHeads[i].render(textureWidth, textureHeight);
        }
        gearbox.setRotation(0.0f, 0.0f, 0.0f);
        gearbox.render(textureWidth, textureHeight);
        GL11.glPopMatrix();
    }
}

