/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.gamedata.MailboxData;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.tile.TileOwned;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class TileMailbox
extends TileOwned
implements ISidedInventory,
BlockRotationHandler.IRotatableTile {
    private boolean autoExport;
    private boolean privateBox;
    public BlockRotationHandler.InventorySided inventory = new BlockRotationHandler.InventorySided(this, BlockRotationHandler.RotationType.FOUR_WAY, 36);
    private String mailboxName;
    private String destinationName;

    public TileMailbox() {
        InventoryTools.IndexHelper helper = new InventoryTools.IndexHelper();
        int[] topIndices = helper.getIndiceArrayForSpread(this.inventory.func_70302_i_() / 2);
        int[] bottomIndices = helper.getIndiceArrayForSpread(this.inventory.func_70302_i_() / 2);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.TOP, BlockRotationHandler.RelativeSide.TOP, topIndices);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.BOTTOM, BlockRotationHandler.RelativeSide.BOTTOM, bottomIndices);
    }

    public void func_145845_h() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.mailboxName != null) {
            MailboxData data = AWGameData.INSTANCE.getData(this.field_145850_b, MailboxData.class);
            ArrayList<MailboxData.DeliverableItem> items = new ArrayList<MailboxData.DeliverableItem>();
            data.getDeliverableItems(this.privateBox ? this.getOwnerName() : null, this.mailboxName, items, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            data.addMailboxReceiver(this.privateBox ? this.getOwnerName() : null, this.mailboxName, this);
            if (this.destinationName != null) {
                this.trySendItems(data);
            }
        }
    }

    private void trySendItems(MailboxData data) {
        String owner = this.privateBox ? this.getOwnerName() : null;
        int dim = this.field_145850_b.field_73011_w.field_76574_g;
        for (int k = this.inventory.func_70302_i_() / 2; k < this.inventory.func_70302_i_(); ++k) {
            ItemStack item = this.inventory.func_70301_a(k);
            if (item == null) continue;
            data.addDeliverableItem(owner, this.destinationName, item, dim, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.inventory.func_70299_a(k, null);
            break;
        }
    }

    public String getMailboxName() {
        return this.mailboxName;
    }

    public String getTargetName() {
        return this.destinationName;
    }

    public void setMailboxName(String name) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.mailboxName = name;
        this.func_70296_d();
    }

    public void setTargetName(String name) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.destinationName = name;
        this.func_70296_d();
    }

    public boolean isAutoExport() {
        return this.autoExport;
    }

    public boolean isPrivateBox() {
        return this.privateBox;
    }

    public void setAutoExport(boolean val) {
        this.autoExport = val;
    }

    public void setPrivateBox(boolean val) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (val != this.privateBox) {
            this.mailboxName = null;
            this.destinationName = null;
            this.func_70296_d();
        }
        this.privateBox = val;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("targetName")) {
            this.destinationName = tag.func_74779_i("targetName");
        }
        if (tag.func_74764_b("mailboxName")) {
            this.mailboxName = tag.func_74779_i("mailboxName");
        }
        if (tag.func_74764_b("inventory")) {
            this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.destinationName != null) {
            tag.func_74778_a("targetName", this.destinationName);
        }
        if (this.mailboxName != null) {
            tag.func_74778_a("mailboxName", this.mailboxName);
        }
        tag.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
    }

    public int[] func_94128_d(int p_94128_1_) {
        return this.inventory.func_94128_d(p_94128_1_);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.inventory.func_102007_a(slot, stack, side);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return this.inventory.func_102008_b(slot, stack, side);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amt) {
        return this.inventory.func_70298_a(slot, amt);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.inventory.func_70300_a(p_70300_1_);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return this.inventory.func_94041_b(p_94041_1_, p_94041_2_);
    }

    @Override
    public ForgeDirection getPrimaryFacing() {
        return ForgeDirection.getOrientation((int)this.func_145832_p());
    }

    @Override
    public void setPrimaryFacing(ForgeDirection face) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, face.ordinal(), 0);
    }
}

