/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;

public final class TreeFinder {
    private static final int[][] offsets = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, -1}, {-1, 0, 1}, {1, 0, -1}, {1, 0, 1}, {-1, 1, 0}, {1, 1, 0}, {0, 1, -1}, {0, 1, 1}, {-1, 1, -1}, {-1, 1, 1}, {1, 1, -1}, {1, 1, 1}, {0, 1, 0}, {-2, 0, 0}, {2, 0, 0}, {0, 0, -2}, {0, 0, 2}};
    public static final TreeFinder DEFAULT = new TreeFinder();
    private final int max;

    public TreeFinder(int size) {
        this.max = size <= offsets.length ? size : offsets.length;
    }

    private TreeFinder() {
        this.max = offsets.length;
    }

    public void findAttachedTreeBlocks(Block blockType, World world, BlockPosition pos, Set<BlockPosition> addTo) {
        ArrayList<BlockPosition> openList = new ArrayList<BlockPosition>(this.max * 2);
        HashSet<BlockPosition> badNodes = new HashSet<BlockPosition>();
        openList.add(pos);
        while (!openList.isEmpty()) {
            pos = (BlockPosition)openList.remove(openList.size() - 1);
            addTo.add(pos);
            this.addNeighborNodes(world, pos, blockType, openList, badNodes, addTo);
        }
    }

    private void addNeighborNodes(World world, BlockPosition pos, Block blockType, List<BlockPosition> openList, Set<BlockPosition> badNodes, Set<BlockPosition> foundNodes) {
        for (int i = 0; i < this.max; ++i) {
            BlockPosition n = pos.offset(offsets[i][0], offsets[i][1], offsets[i][2]);
            if (badNodes.contains(n) || openList.contains(n) || foundNodes.contains(n)) continue;
            if (TreeFinder.isTree(world, n, blockType)) {
                openList.add(n);
                continue;
            }
            badNodes.add(n);
        }
    }

    private static boolean isTree(World world, BlockPosition pos, Block blockType) {
        return world.func_147439_a(pos.x, pos.y, pos.z) == blockType;
    }
}

