/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueBase;
import net.shadowmage.ancientwarfare.core.api.ModuleStatus;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;

public abstract class TileTorqueSidedCell
extends TileTorqueBase {
    boolean[] connections = null;
    final ITorque.SidedTorqueCell[] storage = new ITorque.SidedTorqueCell[DIRECTION_LENGTH];
    double clientEnergyState;
    int clientDestEnergyState;
    double rotation;
    double prevRotation;

    public TileTorqueSidedCell() {
        double max = this.getMaxTransfer();
        double eff = this.getEfficiency();
        for (int i = 0; i < this.storage.length; ++i) {
            this.storage[i] = new ITorque.SidedTorqueCell(max, max, max, eff, ForgeDirection.values()[i], this);
        }
    }

    protected abstract double getEfficiency();

    protected abstract double getMaxTransfer();

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.serverNetworkUpdate();
            this.torqueIn = this.getTotalTorque() - this.prevEnergy;
            this.balanceStorage();
            this.torqueLoss = this.applyPowerLoss();
            this.torqueOut = this.transferPower();
            this.prevEnergy = this.getTotalTorque();
        } else {
            this.clientNetworkUpdate();
            this.updateRotation();
        }
    }

    protected double applyPowerLoss() {
        double loss = 0.0;
        for (ITorque.SidedTorqueCell aStorage : this.storage) {
            loss += this.applyPowerDrain(aStorage);
        }
        return loss;
    }

    protected double transferPower() {
        return this.transferPowerTo(this.getPrimaryFacing());
    }

    protected void balanceStorage() {
        int face = this.getPrimaryFacing().ordinal();
        ITorque.SidedTorqueCell out = this.storage[face];
        double total = 0.0;
        for (int i = 0; i < this.storage.length; ++i) {
            if (i == face) continue;
            total += this.storage[i].getEnergy();
        }
        if (total > 0.0) {
            double transfer = Math.min(total, out.getMaxEnergy() - out.getEnergy());
            double percent = transfer / total;
            transfer = 0.0;
            for (int i = 0; i < this.storage.length; ++i) {
                if (i == face) continue;
                ITorque.SidedTorqueCell in = this.storage[i];
                double fromEach = in.getEnergy() * percent;
                transfer += fromEach;
                in.setEnergy(in.getEnergy() - fromEach);
            }
            out.setEnergy(out.getEnergy() + transfer);
        }
    }

    @Override
    protected void serverNetworkSynch() {
        int percent = (int)(this.storage[this.getPrimaryFacing().ordinal()].getPercentFull() * 100.0);
        int percent2 = (int)(this.torqueOut / this.storage[this.getPrimaryFacing().ordinal()].getMaxOutput() * 100.0);
        if ((percent = Math.max(percent, percent2)) != this.clientDestEnergyState) {
            this.clientDestEnergyState = percent;
            this.sendSideRotation(this.getPrimaryFacing(), percent);
        }
    }

    @Override
    protected void updateRotation() {
        this.prevRotation = this.rotation;
        if (this.clientEnergyState > 0.0) {
            double r = 30.000001907348633 * this.clientEnergyState * 0.01;
            this.rotation += r;
        }
    }

    @Override
    protected void clientNetworkUpdate() {
        if (this.clientEnergyState != (double)this.clientDestEnergyState) {
            if (this.networkUpdateTicks > 0) {
                this.clientEnergyState += ((double)this.clientDestEnergyState - this.clientEnergyState) / (double)this.networkUpdateTicks;
                --this.networkUpdateTicks;
            } else {
                this.clientEnergyState = this.clientDestEnergyState;
            }
        }
    }

    @Override
    protected void handleClientRotationData(ForgeDirection side, int value) {
        this.clientDestEnergyState = value;
        this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
    }

    @Override
    public boolean canInputTorque(ForgeDirection from) {
        return from != this.orientation;
    }

    @Override
    public boolean canOutputTorque(ForgeDirection towards) {
        return towards == this.orientation;
    }

    public boolean[] getConnections() {
        if (this.connections == null) {
            this.buildConnections();
        }
        return this.connections;
    }

    @Override
    public void onNeighborTileChanged() {
        super.onNeighborTileChanged();
        this.connections = null;
    }

    protected void buildConnections() {
        boolean[] connections = new boolean[DIRECTION_LENGTH];
        ITorque.ITorqueTile[] cache = this.getTorqueCache();
        for (int i = 0; i < cache.length; ++i) {
            ForgeDirection dir = ForgeDirection.values()[i];
            if (cache[i] == null) continue;
            connections[i] = cache[i].canInputTorque(dir.getOpposite()) && this.canOutputTorque(dir) || cache[i].canOutputTorque(dir.getOpposite()) && this.canInputTorque(dir);
        }
        if (ModuleStatus.redstoneFluxEnabled) {
            TileEntity[] tes = this.getRFCache();
            for (int i = 0; i < tes.length; ++i) {
                if (cache[i] != null || tes[i] == null) continue;
                connections[i] = true;
            }
        }
        this.connections = connections;
    }

    @Override
    public double getMaxTorque(ForgeDirection from) {
        return this.storage[from.ordinal()].getMaxEnergy();
    }

    @Override
    public double getTorqueStored(ForgeDirection from) {
        return this.storage[from.ordinal()].getEnergy();
    }

    @Override
    public double addTorque(ForgeDirection from, double energy) {
        return this.storage[from.ordinal()].addEnergy(energy);
    }

    @Override
    public double drainTorque(ForgeDirection from, double energy) {
        return this.storage[from.ordinal()].drainEnergy(energy);
    }

    @Override
    public double getMaxTorqueOutput(ForgeDirection from) {
        return this.storage[from.ordinal()].getMaxTickOutput();
    }

    @Override
    public double getMaxTorqueInput(ForgeDirection from) {
        return this.storage[from.ordinal()].getMaxTickInput();
    }

    @Override
    public boolean useOutputRotation(ForgeDirection from) {
        return true;
    }

    @Override
    public float getClientOutputRotation(ForgeDirection from, float delta) {
        return this.getRotation(this.rotation, this.prevRotation, delta);
    }

    @Override
    public NBTTagCompound getDescriptionTag() {
        NBTTagCompound tag = super.getDescriptionTag();
        tag.func_74768_a("clientEnergy", this.clientDestEnergyState);
        return tag;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt.func_148857_g();
        this.clientDestEnergyState = tag.func_74762_e("clientEnergy");
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("energyList", 10);
        for (int i = 0; i < this.storage.length; ++i) {
            this.storage[i].readFromNBT(list.func_150305_b(i));
        }
        this.clientDestEnergyState = tag.func_74762_e("clientEnergy");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList list = new NBTTagList();
        for (ITorque.SidedTorqueCell aStorage : this.storage) {
            list.func_74742_a((NBTBase)aStorage.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("energyList", (NBTBase)list);
        tag.func_74768_a("clientEnergy", this.clientDestEnergyState);
    }

    @Override
    protected double getTotalTorque() {
        double d = 0.0;
        for (int i = 0; i < this.storage.length; ++i) {
            ForgeDirection dir = ForgeDirection.values()[i];
            if (!this.canInputTorque(dir) && !this.canOutputTorque(dir)) continue;
            d += this.storage[i].getEnergy();
        }
        return d;
    }
}

