/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueBase;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;

public abstract class TileTorqueSingleCell
extends TileTorqueBase {
    ITorque.TorqueCell torqueCell;
    double clientEnergyState;
    int clientDestEnergyState;
    double rotation;
    double prevRotation;

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.serverNetworkUpdate();
            this.torqueIn = this.torqueCell.getEnergy() - this.prevEnergy;
            this.torqueLoss = this.applyPowerDrain(this.torqueCell);
            this.torqueOut = this.transferPowerTo(this.getPrimaryFacing());
            this.prevEnergy = this.torqueCell.getEnergy();
        } else {
            this.clientNetworkUpdate();
            this.updateRotation();
        }
    }

    protected double applyPowerLoss() {
        return this.applyPowerDrain(this.torqueCell);
    }

    @Override
    protected void serverNetworkSynch() {
        int percent = (int)(this.torqueCell.getPercentFull() * 100.0);
        int percent2 = (int)(this.torqueOut / this.torqueCell.getMaxOutput() * 100.0);
        if ((percent = Math.max(percent, percent2)) != this.clientDestEnergyState) {
            this.clientDestEnergyState = percent;
            this.sendSideRotation(this.getPrimaryFacing(), percent);
        }
    }

    @Override
    protected void updateRotation() {
        this.prevRotation = this.rotation;
        if (this.clientEnergyState > 0.0) {
            this.rotation += 30.000001907348633 * this.clientEnergyState * 0.01;
        }
    }

    @Override
    protected void clientNetworkUpdate() {
        if (this.clientEnergyState != (double)this.clientDestEnergyState) {
            if (this.networkUpdateTicks > 0) {
                this.clientEnergyState += ((double)this.clientDestEnergyState - this.clientEnergyState) / (double)this.networkUpdateTicks;
                --this.networkUpdateTicks;
            } else {
                this.clientEnergyState = this.clientDestEnergyState;
            }
        }
    }

    @Override
    protected void handleClientRotationData(ForgeDirection side, int value) {
        AWLog.logDebug("receiving sided rotation data: " + side + " :: " + value);
        if (side == this.orientation) {
            this.clientDestEnergyState = value;
            this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
        }
    }

    @Override
    public double getMaxTorque(ForgeDirection from) {
        return this.torqueCell.getMaxEnergy();
    }

    @Override
    public double getTorqueStored(ForgeDirection from) {
        return this.torqueCell.getEnergy();
    }

    @Override
    public double addTorque(ForgeDirection from, double energy) {
        return this.torqueCell.addEnergy(energy);
    }

    @Override
    public double drainTorque(ForgeDirection from, double energy) {
        return this.torqueCell.drainEnergy(energy);
    }

    @Override
    public double getMaxTorqueOutput(ForgeDirection from) {
        return this.canOutputTorque(from) ? this.torqueCell.getMaxTickOutput() : 0.0;
    }

    @Override
    public double getMaxTorqueInput(ForgeDirection from) {
        return this.canInputTorque(from) ? this.torqueCell.getMaxTickInput() : 0.0;
    }

    @Override
    public boolean useOutputRotation(ForgeDirection from) {
        return true;
    }

    @Override
    protected double getTotalTorque() {
        return this.torqueCell.getEnergy();
    }

    @Override
    public boolean canOutputTorque(ForgeDirection towards) {
        return towards == this.orientation;
    }

    @Override
    public boolean canInputTorque(ForgeDirection from) {
        return from == this.orientation.getOpposite();
    }

    @Override
    public float getClientOutputRotation(ForgeDirection from, float delta) {
        return from == this.orientation ? this.getRotation(this.rotation, this.prevRotation, delta) : 0.0f;
    }

    @Override
    public NBTTagCompound getDescriptionTag() {
        NBTTagCompound tag = super.getDescriptionTag();
        tag.func_74768_a("clientEnergy", this.clientDestEnergyState);
        return tag;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt.func_148857_g();
        this.clientDestEnergyState = tag.func_74762_e("clientEnergy");
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.torqueCell.setEnergy(tag.func_74769_h("torqueEnergy"));
        this.clientDestEnergyState = tag.func_74762_e("clientEnergy");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74780_a("torqueEnergy", this.torqueCell.getEnergy());
        tag.func_74768_a("clientEnergy", this.clientDestEnergyState);
    }
}

