/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSingleCell;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;

public class TileWaterwheel
extends TileTorqueSingleCell {
    public float wheelRotation;
    public float prevWheelRotation;
    private float rotTick;
    private byte rotationDirection = 1;
    private int updateTick;
    public boolean validSetup = false;

    public TileWaterwheel() {
        this.torqueCell = new ITorque.TorqueCell(0.0, 4.0, AWAutomationStatics.low_transfer_max, AWAutomationStatics.low_efficiency_factor);
        float maxWheelRpm = 20.0f;
        this.rotTick = maxWheelRpm * 0.3f;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            --this.updateTick;
            if (this.updateTick <= 0) {
                this.updateTick = 20;
                boolean valid = this.validateBlocks();
                if (valid != this.validSetup) {
                    this.validSetup = valid;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            if (this.validSetup) {
                this.torqueCell.setEnergy(this.torqueCell.getEnergy() + AWAutomationStatics.waterwheel_generator_output);
            }
        }
    }

    @Override
    protected void updateRotation() {
        super.updateRotation();
        this.prevWheelRotation = this.wheelRotation;
        if (this.validSetup) {
            this.wheelRotation += this.rotTick * (float)this.rotationDirection;
        }
    }

    @Override
    public NBTTagCompound getDescriptionTag() {
        NBTTagCompound tag = super.getDescriptionTag();
        tag.func_74757_a("validSetup", this.validSetup);
        tag.func_74774_a("rotationDirection", this.rotationDirection);
        return tag;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt.func_148857_g();
        this.validSetup = tag.func_74767_n("validSetup");
        this.rotationDirection = tag.func_74771_c("rotationDirection");
    }

    private ForgeDirection getRight(ForgeDirection in) {
        switch (in) {
            case NORTH: {
                return ForgeDirection.EAST;
            }
            case EAST: {
                return ForgeDirection.SOUTH;
            }
            case SOUTH: {
                return ForgeDirection.WEST;
            }
            case WEST: {
                return ForgeDirection.NORTH;
            }
        }
        return ForgeDirection.NORTH;
    }

    private boolean validateBlocks() {
        int metaRight;
        ForgeDirection d = this.orientation.getOpposite();
        int x = this.field_145851_c + d.offsetX;
        int y = this.field_145848_d + d.offsetY;
        int z = this.field_145849_e + d.offsetZ;
        if (this.getValidationType(x, y + 1, z) != 1 || this.getValidationType(x, y, z) != 1) {
            return false;
        }
        ForgeDirection dr = this.getRight(d);
        ForgeDirection dl = dr.getOpposite();
        int x1 = x + dr.offsetX;
        int z1 = z + dr.offsetZ;
        int x2 = x + dl.offsetX;
        int z2 = z + dl.offsetZ;
        byte[] validationGrid = new byte[]{this.getValidationType(x2, y + 1, z2), this.getValidationType(x1, y + 1, z1), this.getValidationType(x2, y, z2), this.getValidationType(x1, y, z1), this.getValidationType(x2, y - 1, z2), this.getValidationType(x1, y - 1, z1)};
        for (byte aValue : validationGrid) {
            if (aValue != 0) continue;
            return false;
        }
        if (validationGrid[2] == 2 && validationGrid[4] == 2) {
            if (validationGrid[1] == 1 && validationGrid[3] == 1) {
                this.rotationDirection = (byte)-1;
                return true;
            }
            return false;
        }
        if (validationGrid[3] == 2 && validationGrid[5] == 2) {
            if (validationGrid[0] == 1 && validationGrid[2] == 1) {
                this.rotationDirection = 1;
                return true;
            }
            return false;
        }
        if (validationGrid[4] != 2 || validationGrid[5] != 2 || this.getValidationType(x, y - 1, z) != 2) {
            return false;
        }
        int metaLeft = this.field_145850_b.func_72805_g(x2, y - 1, z2);
        this.rotationDirection = (byte)(metaLeft < (metaRight = this.field_145850_b.func_72805_g(x1, y - 1, z1)) ? -1 : (metaRight < metaLeft ? 1 : 0));
        return true;
    }

    private byte getValidationType(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
            return 1;
        }
        if (block.func_149688_o() == Material.field_151586_h) {
            return 2;
        }
        return 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)(this.field_145848_d - 3), (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 4));
    }
}

