/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque.multiblock;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketBlockEvent;
import net.shadowmage.ancientwarfare.core.util.BlockFinder;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import org.apache.commons.lang3.tuple.Pair;

public class TileFlywheelStorage
extends TileEntity {
    public BlockPosition controllerPos;
    public boolean isControl = false;
    public int setWidth;
    public int setHeight;
    public int setCube;
    public int setType;
    public double storedEnergy;
    public double maxEnergyStored;
    public double maxRpm = 100.0;
    public double torqueLoss;
    public double rotation;
    public double prevRotation;
    private int clientEnergy;
    private int clientDestEnergy;
    private int networkUpdateTicks = 0;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isControl) {
            if (this.field_145850_b.field_72995_K) {
                this.clientNetworkUpdate();
            } else {
                this.serverNetworkUpdate();
                this.applyPowerLoss();
            }
        }
    }

    protected void clientNetworkUpdate() {
        this.updateRotation();
        if (this.networkUpdateTicks > 0) {
            int diff = this.clientDestEnergy - this.clientEnergy;
            this.clientEnergy += diff / this.networkUpdateTicks;
            --this.networkUpdateTicks;
        }
    }

    protected void applyPowerLoss() {
        double eff = 1.0 - this.getEfficiency();
        this.torqueLoss = this.storedEnergy * (eff *= 0.1);
        this.storedEnergy -= this.torqueLoss;
    }

    protected double getEfficiency() {
        int meta = this.func_145832_p();
        switch (meta) {
            case 0: {
                return AWAutomationStatics.low_efficiency_factor;
            }
            case 1: {
                return AWAutomationStatics.med_efficiency_factor;
            }
            case 2: {
                return AWAutomationStatics.high_efficiency_factor;
            }
        }
        return AWAutomationStatics.low_efficiency_factor;
    }

    protected void serverNetworkUpdate() {
        if (!AWAutomationStatics.enable_energy_network_updates) {
            return;
        }
        --this.networkUpdateTicks;
        if (this.networkUpdateTicks <= 0) {
            double percentStored = this.storedEnergy / this.maxEnergyStored;
            int total = (int)(percentStored * 100.0);
            if (total != this.clientEnergy) {
                this.clientEnergy = total;
                this.sendDataToClient(1, this.clientEnergy);
            }
            this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
        }
    }

    protected final void sendDataToClient(int type, int data) {
        PacketBlockEvent pkt = new PacketBlockEvent();
        pkt.setParams(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), (byte)type, (short)data);
        NetworkHandler.sendToAllTrackingChunk(this.field_145850_b, this.field_145851_c >> 4, this.field_145849_e >> 4, pkt);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public boolean func_145842_c(int a, int b) {
        if (this.field_145850_b.field_72995_K && a == 1) {
            this.clientDestEnergy = b;
            this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
        }
        return true;
    }

    protected void updateRotation() {
        double rpm = (double)this.clientEnergy * 0.01 * this.maxRpm;
        this.prevRotation = this.rotation;
        this.rotation += rpm * (double)0.3f;
    }

    public void blockBroken() {
        if (this.isControl) {
            this.informNeighborsToValidate();
        } else if (this.controllerPos != null) {
            TileFlywheelStorage controller = this.getController();
            if (controller == null || controller == this) {
                this.informNeighborsToValidate();
            } else {
                controller.validateSetup();
            }
        } else {
            this.informNeighborsToValidate();
        }
    }

    public final void blockPlaced() {
        this.validateSetup();
    }

    public final void setController(BlockPosition pos) {
        this.controllerPos = pos == null ? null : pos.copy();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected boolean validateSetup() {
        boolean valid;
        ArrayList<BlockPosition> connectedPosSet = new ArrayList<BlockPosition>(30);
        BlockFinder finder = new BlockFinder(this.field_145850_b, this.func_145838_q(), this.func_145832_p());
        Pair<BlockPosition, BlockPosition> corners = finder.cross(new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e), new BlockPosition(3, this.field_145850_b.func_72940_L(), 3), connectedPosSet);
        int minX = ((BlockPosition)corners.getLeft()).x;
        int minY = ((BlockPosition)corners.getLeft()).y;
        int minZ = ((BlockPosition)corners.getLeft()).z;
        int w = ((BlockPosition)corners.getRight()).x - minX + 1;
        int h = ((BlockPosition)corners.getRight()).y - minY + 1;
        int l = ((BlockPosition)corners.getRight()).z - minZ + 1;
        boolean bl = valid = w == l && (w == 1 || w == 3) && finder.box(corners, connectedPosSet);
        if (valid) {
            int cx = w == 1 ? minX : minX + 1;
            int cz = l == 1 ? minZ : minZ + 1;
            this.setValidSetup(connectedPosSet, cx, minY, cz, w, h, this.func_145832_p());
        } else {
            finder.connect((BlockPosition)corners.getLeft(), connectedPosSet, ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST);
            this.setInvalidSetup(connectedPosSet);
        }
        return valid;
    }

    private void setValidSetup(List<BlockPosition> set, int cx, int cy, int cz, int size, int height, int type) {
        this.controllerPos = new BlockPosition(cx, cy, cz);
        TileEntity te = this.field_145850_b.func_147438_o(this.controllerPos.x, this.controllerPos.y, this.controllerPos.z);
        if (te instanceof TileFlywheelStorage) {
            ((TileFlywheelStorage)te).setAsController(size, height, type);
            for (BlockPosition pos : set) {
                te = this.field_145850_b.func_147438_o(pos.x, pos.y, pos.z);
                if (!(te instanceof TileFlywheelStorage)) continue;
                ((TileFlywheelStorage)te).setController(this.controllerPos);
            }
        } else {
            this.controllerPos = null;
        }
    }

    private void setAsController(int size, int height, int type) {
        this.isControl = true;
        this.setWidth = size;
        this.setHeight = height;
        this.setType = type;
        this.setCube = size * size * height;
        double energyPerBlockForType = 1600.0;
        switch (type) {
            case 0: {
                energyPerBlockForType = AWAutomationStatics.low_storage_energy_max;
                break;
            }
            case 1: {
                energyPerBlockForType = AWAutomationStatics.med_storage_energy_max;
                break;
            }
            case 2: {
                energyPerBlockForType = AWAutomationStatics.high_storage_energy_max;
            }
        }
        this.maxEnergyStored = (double)this.setCube * energyPerBlockForType;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void setInvalidSetup(List<BlockPosition> set) {
        this.controllerPos = null;
        this.isControl = false;
        for (BlockPosition pos : set) {
            TileEntity te = this.field_145850_b.func_147438_o(pos.x, pos.y, pos.z);
            if (!(te instanceof TileFlywheelStorage)) continue;
            ((TileFlywheelStorage)te).setController(null);
            ((TileFlywheelStorage)te).isControl = false;
        }
    }

    private void informNeighborsToValidate() {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            int x = this.field_145851_c + d.offsetX;
            int y = this.field_145848_d + d.offsetY;
            int z = this.field_145849_e + d.offsetZ;
            TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
            if (!(te instanceof TileFlywheelStorage)) continue;
            ((TileFlywheelStorage)te).validateSetup();
        }
    }

    public TileFlywheelStorage getController() {
        if (this.controllerPos != null) {
            TileEntity te = this.field_145850_b.func_147438_o(this.controllerPos.x, this.controllerPos.y, this.controllerPos.z);
            return te instanceof TileFlywheelStorage ? (TileFlywheelStorage)te : null;
        }
        return null;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.controllerPos != null) {
            tag.func_74782_a("controllerPos", (NBTBase)this.controllerPos.writeToNBT(new NBTTagCompound()));
            if (this.isControl) {
                tag.func_74757_a("isControl", true);
                tag.func_74768_a("setWidth", this.setWidth);
                tag.func_74768_a("setHeight", this.setHeight);
                tag.func_74768_a("setType", this.setType);
                tag.func_74768_a("clientEnergy", this.clientEnergy);
            }
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt.func_148857_g();
        BlockPosition blockPosition = this.controllerPos = tag.func_74764_b("controllerPos") ? new BlockPosition(tag.func_74775_l("controllerPos")) : null;
        if (this.controllerPos != null) {
            this.isControl = tag.func_74767_n("isControl");
            if (this.isControl) {
                this.setHeight = tag.func_74762_e("setHeight");
                this.setWidth = tag.func_74762_e("setWidth");
                this.setCube = this.setWidth * this.setWidth * this.setHeight;
                this.setType = tag.func_74762_e("type");
                this.clientEnergy = tag.func_74762_e("clientEnergy");
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        BlockPosition blockPosition = this.controllerPos = tag.func_74764_b("controllerPos") ? new BlockPosition(tag.func_74775_l("controllerPos")) : null;
        if (this.controllerPos != null) {
            this.isControl = tag.func_74767_n("isControl");
            if (this.isControl) {
                this.maxEnergyStored = tag.func_74769_h("maxEnergy");
                this.setHeight = tag.func_74762_e("setHeight");
                this.setWidth = tag.func_74762_e("setWidth");
                this.setCube = this.setWidth * this.setWidth * this.setHeight;
                this.setType = tag.func_74762_e("type");
            }
        }
        this.storedEnergy = tag.func_74769_h("storedEnergy");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.controllerPos != null) {
            tag.func_74782_a("controllerPos", (NBTBase)this.controllerPos.writeToNBT(new NBTTagCompound()));
            if (this.isControl) {
                tag.func_74757_a("isControl", true);
                tag.func_74780_a("maxEnergy", this.maxEnergyStored);
                tag.func_74768_a("setWidth", this.setWidth);
                tag.func_74768_a("setHeight", this.setHeight);
                tag.func_74768_a("setType", this.setType);
            }
        }
        tag.func_74780_a("storedEnergy", this.storedEnergy);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + this.setHeight), (double)(this.field_145849_e + 2));
    }
}

