/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque.multiblock;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.core.util.BlockFinder;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import org.apache.commons.lang3.tuple.Pair;

public class TileWindmillBlade
extends TileEntity {
    double bladeRpm = 20.0;
    double bladeRpt = this.bladeRpm * (double)0.3f;
    public BlockPosition controlPos;
    public boolean isControl = false;
    protected float rotation;
    protected float prevRotation;
    public int windmillSize = 0;
    public double energy = 0.0;
    public int windmillDirection = 2;

    public void func_145845_h() {
        if (this.isControl) {
            if (!this.field_145850_b.field_72995_K) {
                this.energy = (double)this.windmillSize * AWAutomationStatics.windmill_per_size_output;
            } else {
                this.updateRotation();
            }
        }
    }

    public float getRotation(float delta) {
        return this.prevRotation + (this.rotation - this.prevRotation) * delta;
    }

    protected void updateRotation() {
        this.prevRotation = this.rotation;
        this.rotation = (float)((double)this.rotation + this.bladeRpt);
    }

    public void blockPlaced() {
        if (!this.field_145850_b.field_72995_K) {
            this.validateSetup();
        }
    }

    public void blockBroken() {
        if (!this.field_145850_b.field_72995_K) {
            this.informNeighborsToValidate();
        }
    }

    public TileWindmillBlade getMaster() {
        if (this.controlPos != null) {
            TileEntity te = this.field_145850_b.func_147438_o(this.controlPos.x, this.controlPos.y, this.controlPos.z);
            return te instanceof TileWindmillBlade ? (TileWindmillBlade)te : null;
        }
        if (this.isControl) {
            return this;
        }
        return null;
    }

    protected boolean validateSetup() {
        boolean valid;
        ArrayList<BlockPosition> connectedPosSet = new ArrayList<BlockPosition>(81);
        BlockFinder finder = new BlockFinder(this.field_145850_b, this.func_145838_q(), this.func_145832_p());
        Pair<BlockPosition, BlockPosition> corners = finder.cross(new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e), new BlockPosition(17, 17, 17), connectedPosSet);
        int minX = ((BlockPosition)corners.getLeft()).x;
        int minY = ((BlockPosition)corners.getLeft()).y;
        int minZ = ((BlockPosition)corners.getLeft()).z;
        int xSize = ((BlockPosition)corners.getRight()).x - minX + 1;
        int ySize = ((BlockPosition)corners.getRight()).y - minY + 1;
        int zSize = ((BlockPosition)corners.getRight()).z - minZ + 1;
        boolean bl = valid = !(ySize < 5 || ySize % 2 != 1 || zSize != 1 && xSize != 1 || zSize != ySize && xSize != ySize || !finder.box(corners, connectedPosSet));
        if (valid) {
            int controlZ;
            int controlX;
            int halfSize = (ySize - 1) / 2;
            int controlY = minY + halfSize;
            if (xSize > 1) {
                controlX = minX + halfSize;
                controlZ = minZ;
            } else {
                controlX = minX;
                controlZ = minZ + halfSize;
            }
            this.setValidSetup(connectedPosSet, controlX, controlY, controlZ, xSize, ySize, zSize);
        } else {
            finder.connect((BlockPosition)corners.getLeft(), connectedPosSet, ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST);
            this.setInvalidSetup(connectedPosSet);
        }
        return valid;
    }

    private void informNeighborsToValidate() {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            int x = this.field_145851_c + d.offsetX;
            int y = this.field_145848_d + d.offsetY;
            int z = this.field_145849_e + d.offsetZ;
            TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
            if (!(te instanceof TileWindmillBlade)) continue;
            ((TileWindmillBlade)te).validateSetup();
        }
    }

    private void setController(BlockPosition pos) {
        if (pos == null) {
            this.isControl = false;
        }
        this.controlPos = pos;
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void setInvalidSetup(List<BlockPosition> set) {
        this.setController(null);
        for (BlockPosition pos : set) {
            TileEntity te = this.field_145850_b.func_147438_o(pos.x, pos.y, pos.z);
            if (!(te instanceof TileWindmillBlade)) continue;
            ((TileWindmillBlade)te).setController(null);
        }
    }

    private void setValidSetup(List<BlockPosition> set, int cx, int cy, int cz, int xs, int ys, int zs) {
        this.controlPos = new BlockPosition(cx, cy, cz);
        TileEntity te = this.field_145850_b.func_147438_o(this.controlPos.x, this.controlPos.y, this.controlPos.z);
        if (te instanceof TileWindmillBlade) {
            ((TileWindmillBlade)te).setAsController(xs, ys, zs);
            for (BlockPosition pos : set) {
                te = this.field_145850_b.func_147438_o(pos.x, pos.y, pos.z);
                if (!(te instanceof TileWindmillBlade)) continue;
                ((TileWindmillBlade)te).setController(this.controlPos);
            }
        } else {
            this.controlPos = null;
        }
    }

    private void setAsController(int xSize, int ySize, int zSize) {
        this.windmillDirection = xSize == 1 ? 4 : (zSize == 1 ? 2 : 0);
        this.windmillSize = ySize;
        this.isControl = true;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("isControl", this.isControl);
        if (this.controlPos != null) {
            tag.func_74782_a("controlPos", (NBTBase)this.controlPos.writeToNBT(new NBTTagCompound()));
        }
        if (this.isControl) {
            tag.func_74768_a("size", this.windmillSize);
            tag.func_74768_a("direction", this.windmillDirection);
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt.func_148857_g();
        this.controlPos = tag.func_74764_b("controlPos") ? new BlockPosition(tag.func_74775_l("controlPos")) : null;
        this.isControl = tag.func_74767_n("isControl");
        if (this.isControl) {
            this.windmillSize = tag.func_74762_e("size");
            this.windmillDirection = tag.func_74762_e("direction");
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.controlPos = tag.func_74764_b("controlPos") ? new BlockPosition(tag.func_74775_l("controlPos")) : null;
        this.isControl = tag.func_74767_n("isControl");
        if (this.isControl) {
            this.windmillSize = tag.func_74762_e("size");
            this.windmillDirection = tag.func_74762_e("direction");
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("isControl", this.isControl);
        if (this.controlPos != null) {
            tag.func_74782_a("controlPos", (NBTBase)this.controlPos.writeToNBT(new NBTTagCompound()));
        }
        if (this.isControl) {
            tag.func_74768_a("size", this.windmillSize);
            tag.func_74768_a("direction", this.windmillDirection);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isControl) {
            int expand = (this.windmillSize - 1) / 2;
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - expand), (double)(this.field_145848_d - expand), (double)(this.field_145849_e - expand), (double)(this.field_145851_c + 1 + expand), (double)(this.field_145848_d + 1 + expand), (double)(this.field_145849_e + 1 + expand));
        }
        return this.func_145838_q().func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

