/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IWarehouseStorageTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class TileWarehouse
extends TileWarehouseBase {
    @Override
    public void handleSlotClick(EntityPlayer player, ItemStack filter, boolean shiftClick) {
        if (filter == null) {
            this.tryAddItem(player, player.field_71071_by.func_70445_o());
        } else if (player.field_71071_by.func_70445_o() == null) {
            this.tryGetItem(player, filter, shiftClick);
        }
    }

    private void tryAddItem(EntityPlayer player, ItemStack cursorStack) {
        if (cursorStack == null) {
            return;
        }
        ArrayList<IWarehouseStorageTile> destinations = new ArrayList<IWarehouseStorageTile>();
        this.storageMap.getDestinations(cursorStack, destinations);
        int stackSize = cursorStack.field_77994_a;
        for (IWarehouseStorageTile tile : destinations) {
            int moved = tile.insertItem(cursorStack, cursorStack.field_77994_a);
            cursorStack.field_77994_a -= moved;
            this.changeCachedQuantity(cursorStack, moved);
            this.updateViewers();
            if (cursorStack.field_77994_a > 0) continue;
            break;
        }
        if (cursorStack.field_77994_a <= 0) {
            player.field_71071_by.func_70437_b(null);
        }
        if (stackSize != cursorStack.field_77994_a) {
            ((EntityPlayerMP)player).func_71113_k();
        }
    }

    private void tryGetItem(EntityPlayer player, ItemStack filter, boolean shiftClick) {
        ArrayList<IWarehouseStorageTile> destinations = new ArrayList<IWarehouseStorageTile>();
        ItemStack newCursorStack = filter.func_77946_l();
        newCursorStack.field_77994_a = 0;
        this.storageMap.getDestinations(filter, destinations);
        for (IWarehouseStorageTile tile : destinations) {
            int count = tile.getQuantityStored(filter);
            int toMove = newCursorStack.func_77976_d() - newCursorStack.field_77994_a;
            int n = toMove = toMove > count ? count : toMove;
            if (toMove > 0) {
                newCursorStack.field_77994_a += toMove;
                tile.extractItem(filter, toMove);
                this.changeCachedQuantity(filter, -toMove);
                this.updateViewers();
            }
            if (newCursorStack.field_77994_a < newCursorStack.func_77976_d()) continue;
            break;
        }
        InventoryTools.updateCursorItem((EntityPlayerMP)player, newCursorStack, shiftClick);
    }
}

