/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseControl;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseCraftingStation;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IControlledTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IControllerTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IWarehouseStorageTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseInterface;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStockViewer;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseStorageFilter;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseStorageMap;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBounded;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public abstract class TileWarehouseBase
extends TileWorksiteBounded
implements IControllerTile {
    private boolean init;
    private boolean shouldRecount;
    private final Set<TileWarehouseStockViewer> stockViewers = new HashSet<TileWarehouseStockViewer>();
    private final Set<TileWarehouseInterface> interfaceTiles = new HashSet<TileWarehouseInterface>();
    private final Set<IWarehouseStorageTile> storageTiles = new HashSet<IWarehouseStorageTile>();
    private final Set<TileWarehouseInterface> interfacesToFill = new HashSet<TileWarehouseInterface>();
    private final Set<TileWarehouseInterface> interfacesToEmpty = new HashSet<TileWarehouseInterface>();
    protected WarehouseStorageMap storageMap = new WarehouseStorageMap();
    private ItemQuantityMap cachedItemMap = new ItemQuantityMap();
    private final Set<ContainerWarehouseControl> viewers = new HashSet<ContainerWarehouseControl>();
    private final Set<ContainerWarehouseCraftingStation> craftingViewers = new HashSet<ContainerWarehouseCraftingStation>();

    public int getMaxStorage() {
        int max = 0;
        for (IWarehouseStorageTile t : this.storageTiles) {
            max += t.getStorageAdditionSize();
        }
        return max;
    }

    @Override
    public void onBoundsAdjusted() {
        BlockPosition max = this.getWorkBoundsMax();
        this.setWorkBoundsMax(max.moveUp(this.getWorkBoundsMin().y + this.getBoundsMaxHeight() - max.y));
        this.interfacesToEmpty.clear();
        this.interfacesToFill.clear();
        for (TileWarehouseInterface tileWarehouseInterface : this.interfaceTiles) {
            tileWarehouseInterface.setController(null);
        }
        this.interfaceTiles.clear();
        for (TileWarehouseStockViewer tileWarehouseStockViewer : this.stockViewers) {
            tileWarehouseStockViewer.setController(null);
        }
        this.stockViewers.clear();
        for (IWarehouseStorageTile iWarehouseStorageTile : this.storageTiles) {
            if (!(iWarehouseStorageTile instanceof IControlledTile)) continue;
            ((IControlledTile)((Object)iWarehouseStorageTile)).setController(null);
        }
        this.storageTiles.clear();
        this.storageMap = new WarehouseStorageMap();
        this.cachedItemMap.clear();
        this.scanForInitialTiles();
    }

    @Override
    public boolean userAdjustableBlocks() {
        return false;
    }

    @Override
    public int getBoundsMaxHeight() {
        return 3;
    }

    public abstract void handleSlotClick(EntityPlayer var1, ItemStack var2, boolean var3);

    public void changeCachedQuantity(ItemStack filter, int change) {
        if (change > 0) {
            this.cachedItemMap.addCount(filter, change);
        } else {
            this.cachedItemMap.decreaseCount(filter, -change);
        }
        this.updateViewers();
    }

    private boolean tryEmptyInterfaces() {
        ArrayList<TileWarehouseInterface> toEmpty = new ArrayList<TileWarehouseInterface>(this.interfacesToEmpty);
        for (TileWarehouseInterface tile : toEmpty) {
            if (!this.tryEmptyTile(tile)) continue;
            tile.recalcRequests();
            return true;
        }
        return false;
    }

    private boolean tryEmptyTile(TileWarehouseInterface tile) {
        List<TileWarehouseInterface.InterfaceEmptyRequest> reqs = tile.getEmptyRequests();
        for (TileWarehouseInterface.InterfaceEmptyRequest req : reqs) {
            if (!this.tryRemoveFromRequest(tile, req)) continue;
            return true;
        }
        return false;
    }

    private boolean tryRemoveFromRequest(TileWarehouseInterface tile, TileWarehouseInterface.InterfaceEmptyRequest request) {
        ItemStack stack = tile.func_70301_a(request.slotNum);
        if (stack == null) {
            return false;
        }
        int stackSize = stack.field_77994_a;
        int toMove = request.count;
        ArrayList<IWarehouseStorageTile> potentialStorage = new ArrayList<IWarehouseStorageTile>();
        this.storageMap.getDestinations(stack, potentialStorage);
        for (IWarehouseStorageTile dest : potentialStorage) {
            int stackMove;
            int moved = dest.insertItem(stack, stackMove = toMove > stack.field_77994_a ? stack.field_77994_a : toMove);
            if (moved > 0) {
                this.changeCachedQuantity(stack, moved);
            }
            stack.field_77994_a -= moved;
            toMove -= moved;
            if (stack.field_77994_a != stackSize) {
                if (stack.field_77994_a <= 0) {
                    tile.inventory.func_70299_a(request.slotNum, null);
                }
                return true;
            }
            if (toMove > 0) continue;
            break;
        }
        return false;
    }

    private boolean tryFillInterfaces() {
        ArrayList<TileWarehouseInterface> toFill = new ArrayList<TileWarehouseInterface>(this.interfacesToFill);
        for (TileWarehouseInterface tile : toFill) {
            if (!this.tryFillTile(tile)) continue;
            tile.recalcRequests();
            return true;
        }
        return false;
    }

    private boolean tryFillTile(TileWarehouseInterface tile) {
        List<TileWarehouseInterface.InterfaceFillRequest> reqs = tile.getFillRequests();
        for (TileWarehouseInterface.InterfaceFillRequest req : reqs) {
            if (!this.tryFillFromRequest(tile, req)) continue;
            return true;
        }
        return false;
    }

    private boolean tryFillFromRequest(TileWarehouseInterface tile, TileWarehouseInterface.InterfaceFillRequest request) {
        ArrayList<IWarehouseStorageTile> potentialStorage = new ArrayList<IWarehouseStorageTile>();
        this.storageMap.getDestinations(request.requestedItem, potentialStorage);
        for (IWarehouseStorageTile source : potentialStorage) {
            int found = source.getQuantityStored(request.requestedItem);
            if (found <= 0) continue;
            ItemStack stack = request.requestedItem.func_77946_l();
            int stackSize = stack.field_77994_a = found > stack.func_77976_d() ? stack.func_77976_d() : found;
            if ((stack = InventoryTools.mergeItemStack((IInventory)tile.inventory, stack, -1)) != null && stack.field_77994_a == stackSize) continue;
            int moved = stack == null ? stackSize : stackSize - stack.field_77994_a;
            source.extractItem(request.requestedItem, moved);
            this.cachedItemMap.decreaseCount(request.requestedItem, moved);
            this.updateViewers();
            return true;
        }
        return false;
    }

    public final void getItems(ItemQuantityMap map) {
        map.addAll(this.cachedItemMap);
    }

    public final void clearItemCache() {
        this.cachedItemMap.clear();
    }

    public final void addItemsToCache(ItemQuantityMap map) {
        this.cachedItemMap.addAll(map);
    }

    @Override
    protected boolean processWork() {
        if (!this.interfacesToEmpty.isEmpty() && this.tryEmptyInterfaces()) {
            return true;
        }
        return !this.interfacesToFill.isEmpty() && this.tryFillInterfaces();
    }

    @Override
    protected boolean hasWorksiteWork() {
        return !this.interfacesToEmpty.isEmpty() || !this.interfacesToFill.isEmpty();
    }

    @Override
    protected final void updateWorksite() {
        if (!this.init) {
            this.scanForInitialTiles();
        }
        if (this.shouldRecount) {
            this.shouldRecount = false;
            this.recountInventory();
        }
    }

    private void scanForInitialTiles() {
        BlockPosition max = this.getWorkBoundsMax();
        if (max == null) {
            return;
        }
        BlockPosition min = this.getWorkBoundsMin();
        if (min == null) {
            return;
        }
        List<TileEntity> tiles = WorldTools.getTileEntitiesInArea(this.field_145850_b, min.x, min.y, min.z, max.x, max.y, max.z);
        for (TileEntity te : tiles) {
            if (te instanceof IWarehouseStorageTile) {
                this.addStorageTile((IWarehouseStorageTile)te);
                continue;
            }
            if (te instanceof TileWarehouseInterface) {
                this.addInterfaceTile((TileWarehouseInterface)te);
                continue;
            }
            if (!(te instanceof TileWarehouseStockViewer)) continue;
            this.addStockViewer((TileWarehouseStockViewer)te);
        }
        this.init = true;
    }

    private void recountInventory() {
        this.cachedItemMap.clear();
        for (IWarehouseStorageTile tile : this.storageTiles) {
            tile.addItems(this.cachedItemMap);
        }
    }

    public final void addViewer(ContainerWarehouseControl viewer) {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.viewers.add(viewer);
    }

    public final void addCraftingViewer(ContainerWarehouseCraftingStation viewer) {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.craftingViewers.add(viewer);
    }

    public final void removeViewer(ContainerWarehouseControl viewer) {
        this.viewers.remove((Object)viewer);
    }

    public final void removeCraftingViewer(ContainerWarehouseCraftingStation viewer) {
        this.craftingViewers.remove((Object)viewer);
    }

    public final void updateViewers() {
        for (ContainerWarehouseControl containerWarehouseControl : this.viewers) {
            containerWarehouseControl.onWarehouseInventoryUpdated();
        }
        for (TileWarehouseStockViewer tileWarehouseStockViewer : this.stockViewers) {
            tileWarehouseStockViewer.onWarehouseInventoryUpdated();
        }
        for (ContainerWarehouseCraftingStation containerWarehouseCraftingStation : this.craftingViewers) {
            containerWarehouseCraftingStation.onWarehouseInventoryUpdated();
        }
    }

    public final void addStorageTile(IWarehouseStorageTile tile) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.storageTiles.contains(tile)) {
            this.storageTiles.add(tile);
            if (tile instanceof IControlledTile) {
                ((IControlledTile)((Object)tile)).setController(this);
            }
            this.storageMap.addStorageTile(tile);
            tile.addItems(this.cachedItemMap);
        }
    }

    public final void removeStorageTile(IWarehouseStorageTile tile) {
        ItemQuantityMap iqm = new ItemQuantityMap();
        tile.addItems(iqm);
        this.cachedItemMap.removeAll(iqm);
        this.storageTiles.remove(tile);
        this.storageMap.removeStorageTile(tile);
        this.updateViewers();
    }

    public final void addInterfaceTile(TileWarehouseInterface tile) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.interfaceTiles.contains(tile)) {
            this.interfaceTiles.add(tile);
            tile.setController(this);
            if (!tile.getEmptyRequests().isEmpty()) {
                this.interfacesToEmpty.add(tile);
            }
            if (!tile.getFillRequests().isEmpty()) {
                this.interfacesToFill.add(tile);
            }
        }
    }

    public final void removeInterfaceTile(TileWarehouseInterface tile) {
        this.interfaceTiles.remove(tile);
        this.interfacesToFill.remove(tile);
        this.interfacesToEmpty.remove(tile);
    }

    public final void onIterfaceInventoryChanged(TileWarehouseInterface tile) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.interfacesToFill.remove(tile);
        this.interfacesToEmpty.remove(tile);
        if (!tile.getEmptyRequests().isEmpty()) {
            this.interfacesToEmpty.add(tile);
        }
        if (!tile.getFillRequests().isEmpty()) {
            this.interfacesToFill.add(tile);
        }
    }

    public final void onStorageFilterChanged(IWarehouseStorageTile tile, List<WarehouseStorageFilter> oldFilters, List<WarehouseStorageFilter> newFilters) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.storageMap.updateTileFilters(tile, oldFilters, newFilters);
    }

    public final void addStockViewer(TileWarehouseStockViewer viewer) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.stockViewers.add(viewer);
        viewer.setController(this);
        viewer.onWarehouseInventoryUpdated();
    }

    public final void removeStockViewer(TileWarehouseStockViewer tile) {
        this.stockViewers.remove(tile);
    }

    @Override
    public final void addControlledTile(IControlledTile tile) {
        if (tile instanceof IWarehouseStorageTile) {
            this.addStorageTile((IWarehouseStorageTile)((Object)tile));
        } else if (tile instanceof TileWarehouseInterface) {
            this.addInterfaceTile((TileWarehouseInterface)tile);
        } else if (tile instanceof TileWarehouseStockViewer) {
            this.addStockViewer((TileWarehouseStockViewer)tile);
        }
    }

    @Override
    public final BlockPosition getPosition() {
        return new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public final void removeControlledTile(IControlledTile tile) {
        if (tile instanceof IWarehouseStorageTile) {
            this.removeStorageTile((IWarehouseStorageTile)((Object)tile));
        } else if (tile instanceof TileWarehouseInterface) {
            this.removeInterfaceTile((TileWarehouseInterface)tile);
        } else if (tile instanceof TileWarehouseStockViewer) {
            this.removeStockViewer((TileWarehouseStockViewer)tile);
        }
    }

    @Override
    public final IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.CRAFTING;
    }

    @Override
    public final boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 18, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public final boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public int getCountOf(ItemStack layoutStack) {
        return this.cachedItemMap.getCount(layoutStack);
    }

    public void decreaseCountOf(ItemStack layoutStack, int i) {
        if (this.field_145850_b.field_72995_K) {
            this.cachedItemMap.decreaseCount(layoutStack, i);
            return;
        }
        ArrayList<IWarehouseStorageTile> dest = new ArrayList<IWarehouseStorageTile>();
        this.storageMap.getDestinations(layoutStack, dest);
        int found = 0;
        for (IWarehouseStorageTile tile : dest) {
            found = tile.getQuantityStored(layoutStack);
            if (found <= 0) continue;
            if (found > i) {
                found = i;
            }
            tile.extractItem(layoutStack, found);
            this.cachedItemMap.decreaseCount(layoutStack, found);
            if ((i -= found) > 0) continue;
            break;
        }
        this.updateViewers();
    }

    public ItemStack tryAdd(ItemStack stack) {
        ArrayList<IWarehouseStorageTile> destinations = new ArrayList<IWarehouseStorageTile>();
        this.storageMap.getDestinations(stack, destinations);
        int moved = 0;
        for (IWarehouseStorageTile tile : destinations) {
            moved = tile.insertItem(stack, stack.field_77994_a);
            stack.field_77994_a -= moved;
            this.changeCachedQuantity(stack, moved);
            if (stack.field_77994_a > 0) continue;
            break;
        }
        if (stack.field_77994_a <= 0) {
            return null;
        }
        return stack;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("min")) {
            this.setWorkBoundsMin(new BlockPosition(tag.func_74775_l("min")));
        }
        if (tag.func_74764_b("max")) {
            this.setWorkBoundsMax(new BlockPosition(tag.func_74775_l("max")));
        }
    }

    @Override
    protected void onBoundsSet() {
        this.setWorkBoundsMax(this.getWorkBoundsMax().moveUp(this.getWorkBoundsMin().y + this.getBoundsMaxHeight() - this.getWorkBoundsMax().y));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

