/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.item.ItemResearchBook;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class TileWarehouseCraftingStation
extends TileEntity
implements IInteractableTile,
IInvBasic {
    public InventoryCrafting layoutMatrix;
    public InventoryCraftResult result;
    public net.shadowmage.ancientwarfare.core.inventory.InventoryBasic bookInventory;
    ItemStack[] matrixShadow;

    public TileWarehouseCraftingStation() {
        Container c = new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return true;
            }

            public void func_75130_a(IInventory par1iInventory) {
                TileWarehouseCraftingStation.this.func_76316_a(null);
            }
        };
        this.layoutMatrix = new InventoryCrafting(c, 3, 3);
        this.matrixShadow = new ItemStack[this.layoutMatrix.func_70302_i_()];
        this.result = new InventoryCraftResult();
        this.bookInventory = new net.shadowmage.ancientwarfare.core.inventory.InventoryBasic(1, this);
    }

    public void preItemCrafted() {
        for (int i = 0; i < this.layoutMatrix.func_70302_i_(); ++i) {
            ItemStack stack = this.layoutMatrix.func_70301_a(i);
            this.matrixShadow[i] = stack == null ? null : stack.func_77946_l();
        }
    }

    public void onItemCrafted() {
        TileWarehouseBase warehouse = this.getWarehouse();
        if (warehouse == null) {
            return;
        }
        AWLog.logDebug("crafting item...");
        for (int i = 0; i < this.layoutMatrix.func_70302_i_(); ++i) {
            ItemStack layoutStack = this.matrixShadow[i];
            if (layoutStack == null || this.layoutMatrix.func_70301_a(i) != null) continue;
            int q = warehouse.getCountOf(layoutStack);
            AWLog.logDebug("warehouse count of: " + layoutStack + " :: " + q);
            if (q <= 0) continue;
            warehouse.decreaseCountOf(layoutStack, 1);
            layoutStack = layoutStack.func_77946_l();
            layoutStack.field_77994_a = 1;
            this.layoutMatrix.func_70299_a(i, layoutStack);
        }
        if (!this.field_145850_b.field_72995_K) {
            warehouse.updateViewers();
        }
    }

    public final TileWarehouseBase getWarehouse() {
        if (this.field_145848_d <= 1) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (te instanceof TileWarehouseBase) {
            return (TileWarehouseBase)te;
        }
        return null;
    }

    public boolean canUpdate() {
        return false;
    }

    private void onLayoutMatrixChanged() {
        this.result.func_70299_a(0, AWCraftingManager.INSTANCE.findMatchingRecipe(this.layoutMatrix, this.field_145850_b, this.getCrafterName()));
    }

    public String getCrafterName() {
        return ItemResearchBook.getResearcherName(this.bookInventory.func_70301_a(0));
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.onLayoutMatrixChanged();
    }

    public void func_76316_a(InventoryBasic internal) {
        this.onLayoutMatrixChanged();
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        InventoryTools.readInventoryFromNBT((IInventory)this.bookInventory, tag.func_74775_l("bookInventory"));
        InventoryTools.readInventoryFromNBT((IInventory)this.result, tag.func_74775_l("resultInventory"));
        InventoryTools.readInventoryFromNBT((IInventory)this.layoutMatrix, tag.func_74775_l("layoutMatrix"));
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound inventoryTag = InventoryTools.writeInventoryToNBT((IInventory)this.bookInventory, new NBTTagCompound());
        tag.func_74782_a("bookInventory", (NBTBase)inventoryTag);
        inventoryTag = InventoryTools.writeInventoryToNBT((IInventory)this.result, new NBTTagCompound());
        tag.func_74782_a("resultInventory", (NBTBase)inventoryTag);
        inventoryTag = InventoryTools.writeInventoryToNBT((IInventory)this.layoutMatrix, new NBTTagCompound());
        tag.func_74782_a("layoutMatrix", (NBTBase)inventoryTag);
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 22, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }
}

