/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseStockViewer;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileControlled;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.interfaces.INBTSerialable;
import net.shadowmage.ancientwarfare.core.interfaces.IOwnable;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class TileWarehouseStockViewer
extends TileControlled
implements IOwnable,
IInteractableTile {
    private final List<WarehouseStockFilter> filters = new ArrayList<WarehouseStockFilter>();
    private UUID owner;
    private String ownerName = "";
    private boolean shouldUpdate = false;
    private final Set<ContainerWarehouseStockViewer> viewers = new HashSet<ContainerWarehouseStockViewer>();

    public void updateViewers() {
        for (ContainerWarehouseStockViewer viewer : this.viewers) {
            viewer.onFiltersChanged();
        }
    }

    public void addViewer(ContainerWarehouseStockViewer viewer) {
        this.viewers.add(viewer);
    }

    public void removeViewer(ContainerWarehouseStockViewer viewer) {
        this.viewers.remove((Object)viewer);
    }

    public List<WarehouseStockFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<WarehouseStockFilter> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
        this.shouldUpdate = false;
        this.recountFilters(false);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void recountFilters(boolean sendToClients) {
        TileWarehouseBase twb = (TileWarehouseBase)this.getController();
        int index = 0;
        if (twb == null) {
            int count = 0;
            for (WarehouseStockFilter filter : this.filters) {
                if (count != filter.getQuantity()) {
                    filter.setQuantity(0);
                    if (sendToClients) {
                        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), index, count);
                    }
                }
                ++index;
            }
        } else {
            for (WarehouseStockFilter filter : this.filters) {
                int count;
                int n = count = filter.getFilterItem() == null ? 0 : twb.getCountOf(filter.getFilterItem());
                if (count != filter.getQuantity()) {
                    filter.setQuantity(count);
                    if (sendToClients) {
                        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), index, count);
                    }
                }
                ++index;
            }
        }
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.owner != null) {
            return player.func_110124_au().equals(this.owner);
        }
        return player.func_70005_c_().equals(this.ownerName);
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = player.func_110124_au();
        this.ownerName = player.func_70005_c_();
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 20, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    protected void updateTile() {
        if (this.shouldUpdate) {
            this.shouldUpdate = false;
            this.recountFilters(true);
        }
    }

    public void onWarehouseInventoryUpdated() {
        this.shouldUpdate = true;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        INBTSerialable.Helper.write(tag, "filterList", this.filters);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.filters.clear();
        this.filters.addAll(INBTSerialable.Helper.read(pkt.func_148857_g(), "filterList", WarehouseStockFilter.class));
        this.updateViewers();
    }

    public boolean func_145842_c(int a, int b) {
        if (this.field_145850_b.field_72995_K && a >= 0 && a < this.filters.size()) {
            this.filters.get(a).setQuantity(b);
            this.updateViewers();
        }
        return true;
    }

    private void checkOwnerName() {
        if (this.func_145830_o()) {
            EntityPlayer player;
            if (this.owner != null) {
                EntityPlayer player2 = this.field_145850_b.func_152378_a(this.owner);
                if (player2 != null) {
                    this.setOwner(player2);
                }
            } else if (this.ownerName != null && (player = this.field_145850_b.func_72924_a(this.ownerName)) != null) {
                this.setOwner(player);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.filters.addAll(INBTSerialable.Helper.read(tag, "filterList", WarehouseStockFilter.class));
        this.ownerName = tag.func_74779_i("ownerName");
        if (tag.func_74764_b("ownerId")) {
            this.owner = UUID.fromString(tag.func_74779_i("ownerId"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        INBTSerialable.Helper.write(tag, "filterList", this.filters);
        this.checkOwnerName();
        tag.func_74778_a("ownerName", this.ownerName);
        if (this.owner != null) {
            tag.func_74778_a("ownerId", this.owner.toString());
        }
    }

    public static class WarehouseStockFilter
    implements INBTSerialable {
        private ItemStack item;
        ItemQuantityMap.ItemHashEntry hashKey;
        private int quantity;

        public WarehouseStockFilter() {
        }

        public WarehouseStockFilter(ItemStack item, int qty) {
            this.setQuantity(qty);
            this.setItem(item);
        }

        public void setItem(ItemStack item) {
            this.item = item;
            this.hashKey = item == null ? null : new ItemQuantityMap.ItemHashEntry(item);
        }

        public void setQuantity(int quantity) {
            this.quantity = quantity;
        }

        public ItemStack getFilterItem() {
            return this.item;
        }

        public int getQuantity() {
            return this.quantity;
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.setItem(tag.func_74764_b("item") ? InventoryTools.readItemStack(tag.func_74775_l("item")) : null);
            this.setQuantity(tag.func_74762_e("quantity"));
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            if (this.item != null) {
                tag.func_74782_a("item", (NBTBase)InventoryTools.writeItemStack(this.item));
            }
            tag.func_74768_a("quantity", this.quantity);
            return tag;
        }
    }
}

