/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.shadowmage.ancientwarfare.api.IAncientWarfareFarmable;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBounded;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public abstract class TileWorksiteBoundedInventory
extends TileWorksiteBounded
implements ISidedInventory {
    public BlockRotationHandler.InventorySided inventory;

    public void openAltGui(EntityPlayer player) {
    }

    public final void addStackToInventory(ItemStack stack, BlockRotationHandler.RelativeSide ... sides) {
        int[] slots = this.inventory.getRawIndicesCombined(sides);
        if ((stack = InventoryTools.mergeItemStack((IInventory)this.inventory, stack, slots)) != null) {
            InventoryTools.dropItemInWorld(this.field_145850_b, stack, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    protected boolean harvestBlock(int x, int y, int z, BlockRotationHandler.RelativeSide ... relativeSides) {
        ArrayList stacks;
        int[] combinedIndices = this.inventory.getRawIndicesCombined(relativeSides);
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block instanceof IAncientWarfareFarmable) {
            stacks = ((IAncientWarfareFarmable)block).doHarvest(this.field_145850_b, x, y, z, this.getFortune());
        } else {
            int meta = this.field_145850_b.func_72805_g(x, y, z);
            stacks = block.getDrops(this.field_145850_b, x, y, z, meta, this.getFortune());
            if (!InventoryTools.canInventoryHold((IInventory)this.inventory, combinedIndices, (List<ItemStack>)stacks)) {
                return false;
            }
            if (!BlockTools.canBreakBlock(this.field_145850_b, this.getOwnerAsPlayer(), x, y, z, block, meta)) {
                return false;
            }
            this.field_145850_b.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            if (!this.field_145850_b.func_147468_f(x, y, z)) {
                return false;
            }
        }
        for (ItemStack stack : stacks) {
            if ((stack = InventoryTools.mergeItemStack((IInventory)this.inventory, stack, combinedIndices)) == null) continue;
            InventoryTools.dropItemInWorld(this.field_145850_b, stack, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    protected <T> List<T> getEntitiesWithinBounds(Class<T> clazz) {
        BlockPosition p1 = this.getWorkBoundsMin();
        BlockPosition p2 = this.getWorkBoundsMax();
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)p1.x, (double)p1.y, (double)p1.z, (double)(p2.x + 1), (double)(p2.y + 1), (double)(p2.z + 1));
        return this.field_145850_b.func_72872_a(clazz, bb);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.inventory != null) {
            NBTTagCompound invTag = new NBTTagCompound();
            this.inventory.writeToNBT(invTag);
            tag.func_74782_a("inventory", (NBTBase)invTag);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("inventory") && this.inventory != null) {
            this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        }
    }

    public final int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public final ItemStack func_70301_a(int var1) {
        return this.inventory.func_70301_a(var1);
    }

    public final ItemStack func_70298_a(int var1, int var2) {
        return this.inventory.func_70298_a(var1, var2);
    }

    public final ItemStack func_70304_b(int var1) {
        return this.inventory.func_70304_b(var1);
    }

    public final void func_70299_a(int var1, ItemStack var2) {
        this.inventory.func_70299_a(var1, var2);
    }

    public final String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public final boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public final int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public final boolean func_70300_a(EntityPlayer var1) {
        return this.inventory.func_70300_a(var1);
    }

    public final void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public final void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public final boolean func_94041_b(int var1, ItemStack var2) {
        return this.inventory.func_94041_b(var1, var2);
    }

    public final int[] func_94128_d(int var1) {
        return this.inventory.func_94128_d(var1);
    }

    public final boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return this.inventory.func_102007_a(var1, var2, var3);
    }

    public final boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return this.inventory.func_102008_b(var1, var2, var3);
    }
}

