/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBoundedInventory;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.inventory.ItemSlotFilter;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class WorkSiteAnimalFarm
extends TileWorksiteBoundedInventory {
    private static final int TOP_LENGTH = 27;
    private static final int FRONT_LENGTH = 3;
    private static final int BOTTOM_LENGTH = 3;
    private int workerRescanDelay;
    private boolean shouldCountResources = true;
    public int maxPigCount = 6;
    public int maxCowCount = 6;
    public int maxChickenCount = 6;
    public int maxSheepCount = 6;
    private int wheatCount;
    private int bucketCount;
    private int carrotCount;
    private int seedCount;
    private ItemStack shears = null;
    private List<EntityPair> pigsToBreed = new ArrayList<EntityPair>();
    private List<EntityPair> chickensToBreed = new ArrayList<EntityPair>();
    private List<EntityPair> cowsToBreed = new ArrayList<EntityPair>();
    private int cowsToMilk;
    private List<EntityPair> sheepToBreed = new ArrayList<EntityPair>();
    private List<Integer> sheepToShear = new ArrayList<Integer>();
    private List<Integer> entitiesToCull = new ArrayList<Integer>();

    public WorkSiteAnimalFarm() {
        this.inventory = new BlockRotationHandler.InventorySided(this, BlockRotationHandler.RotationType.FOUR_WAY, 33){

            @Override
            public void func_70296_d() {
                super.func_70296_d();
                WorkSiteAnimalFarm.this.shouldCountResources = true;
            }
        };
        InventoryTools.IndexHelper helper = new InventoryTools.IndexHelper();
        int[] topIndices = helper.getIndiceArrayForSpread(27);
        int[] frontIndices = helper.getIndiceArrayForSpread(3);
        int[] bottomIndices = helper.getIndiceArrayForSpread(3);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.TOP, BlockRotationHandler.RelativeSide.TOP, topIndices);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.FRONT, frontIndices);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.BOTTOM, BlockRotationHandler.RelativeSide.BOTTOM, bottomIndices);
        ItemSlotFilter filter = new ItemSlotFilter(){

            public boolean apply(ItemStack stack) {
                return stack == null || WorkSiteAnimalFarm.this.isFood(stack.func_77973_b());
            }
        };
        this.inventory.setFilterForSlots(filter, frontIndices);
        filter = new ItemSlotFilter(){

            public boolean apply(ItemStack stack) {
                return stack == null || WorkSiteAnimalFarm.this.isTool(stack.func_77973_b());
            }
        };
        this.inventory.setFilterForSlots(filter, bottomIndices);
    }

    private boolean isFood(Item item) {
        return item == Items.field_151014_N || item == Items.field_151015_O || item == Items.field_151172_bF;
    }

    private boolean isTool(Item item) {
        return item == Items.field_151133_ar || item instanceof ItemShears;
    }

    @Override
    public boolean userAdjustableBlocks() {
        return false;
    }

    @Override
    protected boolean hasWorksiteWork() {
        return !this.entitiesToCull.isEmpty() || this.carrotCount > 0 && !this.pigsToBreed.isEmpty() || this.seedCount > 0 && !this.chickensToBreed.isEmpty() || this.wheatCount > 0 && (!this.cowsToBreed.isEmpty() || !this.sheepToBreed.isEmpty()) || this.bucketCount > 0 && this.cowsToMilk > 0 || this.shears != null && !this.sheepToShear.isEmpty();
    }

    @Override
    protected void updateWorksite() {
        this.field_145850_b.field_72984_F.func_76320_a("Count Resources");
        if (this.shouldCountResources) {
            this.countResources();
            this.shouldCountResources = false;
        }
        this.field_145850_b.field_72984_F.func_76318_c("Animal Rescan");
        if (this.workerRescanDelay-- <= 0) {
            this.rescan();
            this.workerRescanDelay = 200;
        }
        this.field_145850_b.field_72984_F.func_76318_c("EggPickup");
        if (this.field_145850_b.func_72820_D() % 20L == 0L) {
            this.pickupEggs();
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    private void countResources() {
        ItemStack stack;
        int i;
        this.carrotCount = 0;
        this.seedCount = 0;
        this.wheatCount = 0;
        this.bucketCount = 0;
        this.shears = null;
        for (i = 27; i < 30; ++i) {
            stack = this.func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() == Items.field_151172_bF) {
                this.carrotCount += stack.field_77994_a;
                continue;
            }
            if (stack.func_77973_b() == Items.field_151014_N) {
                this.seedCount += stack.field_77994_a;
                continue;
            }
            if (stack.func_77973_b() != Items.field_151015_O) continue;
            this.wheatCount += stack.field_77994_a;
        }
        for (i = 30; i < this.func_70302_i_(); ++i) {
            stack = this.func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() == Items.field_151133_ar) {
                this.bucketCount += stack.field_77994_a;
                continue;
            }
            if (!(stack.func_77973_b() instanceof ItemShears)) continue;
            this.shears = stack;
        }
    }

    private void rescan() {
        this.pigsToBreed.clear();
        this.cowsToBreed.clear();
        this.cowsToMilk = 0;
        this.sheepToBreed.clear();
        this.chickensToBreed.clear();
        this.entitiesToCull.clear();
        List<EntityAnimal> entityList = this.getEntitiesWithinBounds(EntityAnimal.class);
        ArrayList<EntityAnimal> cows = new ArrayList<EntityAnimal>();
        ArrayList<EntityAnimal> pigs = new ArrayList<EntityAnimal>();
        ArrayList<EntityAnimal> sheep = new ArrayList<EntityAnimal>();
        ArrayList<EntityAnimal> chickens = new ArrayList<EntityAnimal>();
        for (EntityAnimal animal : entityList) {
            if (animal instanceof EntityCow) {
                cows.add(animal);
                continue;
            }
            if (animal instanceof EntityChicken) {
                chickens.add(animal);
                continue;
            }
            if (animal instanceof EntitySheep) {
                sheep.add(animal);
                continue;
            }
            if (!(animal instanceof EntityPig)) continue;
            pigs.add(animal);
        }
        this.scanForCows(cows);
        this.scanForSheep(sheep);
        this.scanForAnimals(chickens, this.chickensToBreed, this.maxChickenCount);
        this.scanForAnimals(pigs, this.pigsToBreed, this.maxPigCount);
    }

    private void scanForAnimals(List<EntityAnimal> animals, List<EntityPair> targets, int maxCount) {
        block0: for (int i = 0; i < animals.size(); ++i) {
            EntityAnimal animal1 = animals.get(i);
            int age = animal1.func_70874_b();
            if (age != 0 || animal1.func_70880_s()) continue;
            while (i + 1 < animals.size()) {
                EntityAnimal animal2;
                if ((age = (animal2 = animals.get(++i)).func_70874_b()) != 0 || animal2.func_70880_s()) continue;
                EntityPair breedingPair = new EntityPair((Entity)animal1, (Entity)animal2);
                targets.add(breedingPair);
                continue block0;
            }
        }
        int grownCount = 0;
        for (EntityAnimal animal : animals) {
            if (animal.func_70874_b() < 0) continue;
            ++grownCount;
        }
        if (grownCount > maxCount) {
            int cullCount = grownCount - maxCount;
            for (int i = 0; i < animals.size() && cullCount > 0; ++i) {
                if (animals.get(i).func_70874_b() < 0) continue;
                this.entitiesToCull.add(animals.get(i).func_145782_y());
                --cullCount;
            }
        }
    }

    private void scanForSheep(List<EntityAnimal> sheep) {
        this.scanForAnimals(sheep, this.sheepToBreed, this.maxSheepCount);
        for (EntityAnimal animal : sheep) {
            EntitySheep sheep1;
            if (animal.func_70874_b() < 0 || (sheep1 = (EntitySheep)animal).func_70892_o()) continue;
            this.sheepToShear.add(sheep1.func_145782_y());
        }
    }

    private void scanForCows(List<EntityAnimal> animals) {
        this.scanForAnimals(animals, this.cowsToBreed, this.maxCowCount);
        for (EntityAnimal animal : animals) {
            if (animal.func_70874_b() < 0) continue;
            ++this.cowsToMilk;
            if (this.cowsToMilk <= this.maxCowCount) continue;
            this.cowsToMilk = this.maxCowCount;
            break;
        }
    }

    @Override
    protected boolean processWork() {
        if (!this.cowsToBreed.isEmpty() && this.wheatCount >= 2 && this.tryBreeding(this.cowsToBreed)) {
            this.wheatCount -= 2;
            InventoryTools.removeItems((IInventory)this.inventory, this.inventory.getAccessDirectionFor(BlockRotationHandler.RelativeSide.FRONT), new ItemStack(Items.field_151015_O), 2);
            return true;
        }
        if (!this.sheepToBreed.isEmpty() && this.wheatCount >= 2 && this.tryBreeding(this.sheepToBreed)) {
            this.wheatCount -= 2;
            InventoryTools.removeItems((IInventory)this.inventory, this.inventory.getAccessDirectionFor(BlockRotationHandler.RelativeSide.FRONT), new ItemStack(Items.field_151015_O), 2);
            return true;
        }
        if (!this.chickensToBreed.isEmpty() && this.seedCount >= 2 && this.tryBreeding(this.chickensToBreed)) {
            this.seedCount -= 2;
            InventoryTools.removeItems((IInventory)this.inventory, this.inventory.getAccessDirectionFor(BlockRotationHandler.RelativeSide.FRONT), new ItemStack(Items.field_151014_N), 2);
            return true;
        }
        if (!this.pigsToBreed.isEmpty() && this.carrotCount >= 2 && this.tryBreeding(this.pigsToBreed)) {
            this.carrotCount -= 2;
            InventoryTools.removeItems((IInventory)this.inventory, this.inventory.getAccessDirectionFor(BlockRotationHandler.RelativeSide.FRONT), new ItemStack(Items.field_151172_bF), 2);
            return true;
        }
        if (this.tryShearing()) {
            return true;
        }
        if (this.bucketCount > 0 && this.tryMilking()) {
            InventoryTools.removeItems((IInventory)this.inventory, this.inventory.getAccessDirectionFor(BlockRotationHandler.RelativeSide.BOTTOM), new ItemStack(Items.field_151133_ar), 1);
            this.addStackToInventory(new ItemStack(Items.field_151117_aB), BlockRotationHandler.RelativeSide.TOP);
            return true;
        }
        return this.tryCulling();
    }

    private boolean tryBreeding(List<EntityPair> targets) {
        if (!targets.isEmpty()) {
            EntityPair pair = targets.remove(0);
            Entity animalA = pair.getEntityA(this.field_145850_b);
            Entity animalB = pair.getEntityB(this.field_145850_b);
            if (!(animalA instanceof EntityAnimal) || !(animalB instanceof EntityAnimal)) {
                return false;
            }
            if (animalA.func_70089_S() && animalB.func_70089_S()) {
                ((EntityAnimal)animalA).func_146082_f(this.getOwnerAsPlayer());
                ((EntityAnimal)animalB).func_146082_f(this.getOwnerAsPlayer());
                return true;
            }
        }
        return false;
    }

    private boolean tryMilking() {
        return this.cowsToMilk > 0 && this.field_145850_b.field_73012_v.nextInt(this.cowsToMilk + this.getFortune()) > this.maxCowCount / 2;
    }

    private boolean tryShearing() {
        if (this.shears == null || this.sheepToShear.isEmpty()) {
            return false;
        }
        EntitySheep sheep = (EntitySheep)this.field_145850_b.func_73045_a(this.sheepToShear.remove(0).intValue());
        if (sheep == null || !sheep.isShearable(this.shears, (IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return false;
        }
        ArrayList items = sheep.onSheared(this.shears, (IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getFortune());
        for (ItemStack item : items) {
            this.addStackToInventory(item, BlockRotationHandler.RelativeSide.TOP);
        }
        return true;
    }

    private boolean tryCulling() {
        int fortune = this.getFortune();
        while (!this.entitiesToCull.isEmpty()) {
            EntityAnimal animal;
            Entity entity = this.field_145850_b.func_73045_a(this.entitiesToCull.remove(0).intValue());
            if (!(entity instanceof EntityAnimal) || !entity.func_70089_S() || (animal = (EntityAnimal)entity).func_70880_s() || animal.func_70874_b() < 0) continue;
            animal.captureDrops = true;
            animal.field_70720_be = 10;
            animal.func_70097_a(DamageSource.field_76377_j, animal.func_110143_aJ() + 1.0f);
            for (EntityItem item : animal.capturedDrops) {
                ItemStack stack = item.func_92059_d();
                if (stack == null) continue;
                if (fortune > 0) {
                    stack.field_77994_a += this.field_145850_b.field_73012_v.nextInt(fortune);
                }
                this.addStackToInventory(stack, BlockRotationHandler.RelativeSide.TOP);
            }
            animal.capturedDrops.clear();
            animal.captureDrops = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 26, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    private void pickupEggs() {
        List<EntityItem> items = this.getEntitiesWithinBounds(EntityItem.class);
        for (EntityItem item : items) {
            ItemStack stack = item.func_92059_d();
            if (!item.func_70089_S() || stack == null || stack.func_77973_b() != Items.field_151110_aK) continue;
            if ((stack = InventoryTools.mergeItemStack((IInventory)this.inventory, stack, this.inventory.getRawIndices(BlockRotationHandler.RelativeSide.TOP))) != null) {
                item.func_92058_a(stack);
                continue;
            }
            item.func_70106_y();
        }
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.FARMING;
    }

    @Override
    public void openAltGui(EntityPlayer player) {
        NetworkHandler.INSTANCE.openGui(player, 14, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("maxChickens")) {
            this.maxChickenCount = tag.func_74762_e("maxChickens");
        }
        if (tag.func_74764_b("maxCows")) {
            this.maxCowCount = tag.func_74762_e("maxCows");
        }
        if (tag.func_74764_b("maxPigs")) {
            this.maxPigCount = tag.func_74762_e("maxPigs");
        }
        if (tag.func_74764_b("maxSheep")) {
            this.maxSheepCount = tag.func_74762_e("maxSheep");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("maxChickens", this.maxChickenCount);
        tag.func_74768_a("maxCows", this.maxCowCount);
        tag.func_74768_a("maxPigs", this.maxPigCount);
        tag.func_74768_a("maxSheep", this.maxSheepCount);
    }

    private static class EntityPair {
        final int idA;
        final int idB;

        private EntityPair(Entity a, Entity b) {
            this.idA = a.func_145782_y();
            this.idB = b.func_145782_y();
        }

        public Entity getEntityA(World world) {
            return world.func_73045_a(this.idA);
        }

        public Entity getEntityB(World world) {
            return world.func_73045_a(this.idB);
        }
    }
}

