/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.FishingHooks;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBoundedInventory;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class WorkSiteFishFarm
extends TileWorksiteBoundedInventory {
    private static final int TOP_LENGTH = 27;
    private static final int MAX_WATER = 1280;
    private boolean harvestFish = true;
    private boolean harvestInk = true;
    private int waterBlockCount = 0;
    private int waterRescanDelay = 0;

    public WorkSiteFishFarm() {
        this.inventory = new BlockRotationHandler.InventorySided(this, BlockRotationHandler.RotationType.FOUR_WAY, 27);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.TOP, BlockRotationHandler.RelativeSide.TOP, InventoryTools.getIndiceArrayForSpread(27));
    }

    @Override
    public boolean userAdjustableBlocks() {
        return false;
    }

    @Override
    protected void onBoundsSet() {
        super.onBoundsSet();
        BlockPosition pos = this.getWorkBoundsMax();
        this.setWorkBoundsMax(pos.moveUp(this.field_145848_d - 1 - pos.y));
        pos = this.getWorkBoundsMin();
        this.setWorkBoundsMin(pos.moveUp(this.field_145848_d - 5 - pos.y));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onBoundsAdjusted() {
        super.onBoundsAdjusted();
        BlockPosition pos = this.getWorkBoundsMax();
        this.setWorkBoundsMax(pos.moveUp(this.field_145848_d - 1 - pos.y));
        pos = this.getWorkBoundsMin();
        this.setWorkBoundsMin(pos.moveUp(this.field_145848_d - 5 - pos.y));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public int getBoundsMaxHeight() {
        return 4;
    }

    public boolean harvestFish() {
        return this.harvestFish;
    }

    public boolean harvestInk() {
        return this.harvestInk;
    }

    public void setHarvest(boolean fish, boolean ink) {
        if (this.harvestFish != fish || this.harvestInk != ink) {
            this.harvestFish = fish;
            this.harvestInk = ink;
            this.func_70296_d();
        }
    }

    @Override
    protected boolean processWork() {
        if (this.waterBlockCount > 0) {
            float percentOfMax = (float)this.waterBlockCount / 1280.0f;
            float check = this.field_145850_b.field_73012_v.nextFloat();
            if (check <= percentOfMax) {
                ItemStack fishStack;
                boolean fish = this.harvestFish;
                boolean ink = this.harvestInk;
                if (fish && ink) {
                    fish = this.field_145850_b.field_73012_v.nextBoolean();
                    boolean bl = ink = !fish;
                }
                if (fish && (fishStack = FishingHooks.getRandomFishable((Random)this.field_145850_b.field_73012_v, (float)1.0f)) != null) {
                    int fortune = this.getFortune();
                    if (fortune > 0) {
                        fishStack.field_77994_a += this.field_145850_b.field_73012_v.nextInt(fortune + 1);
                    }
                    this.addStackToInventory(fishStack, BlockRotationHandler.RelativeSide.TOP);
                    return true;
                }
                if (ink) {
                    ItemStack inkItem = new ItemStack(Items.field_151100_aR, 1, 0);
                    int fortune = this.getFortune();
                    if (fortune > 0) {
                        inkItem.field_77994_a += this.field_145850_b.field_73012_v.nextInt(fortune + 1);
                    }
                    this.addStackToInventory(inkItem, BlockRotationHandler.RelativeSide.TOP);
                    return true;
                }
            }
        }
        return false;
    }

    private void countWater() {
        this.waterBlockCount = 0;
        BlockPosition min = this.getWorkBoundsMin();
        BlockPosition max = this.getWorkBoundsMax();
        for (int x = min.x; x <= max.x; ++x) {
            for (int z = min.z; z <= max.z; ++z) {
                for (int y = max.y; y >= min.y && this.field_145850_b.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h; --y) {
                    ++this.waterBlockCount;
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.harvestFish = tag.func_74767_n("fish");
        this.harvestInk = tag.func_74767_n("ink");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("fish", this.harvestFish);
        tag.func_74757_a("ink", this.harvestInk);
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.FARMING;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 29, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public void openAltGui(EntityPlayer player) {
        NetworkHandler.INSTANCE.openGui(player, 16, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    protected boolean hasWorksiteWork() {
        return this.waterBlockCount > 0;
    }

    @Override
    protected void updateWorksite() {
        this.field_145850_b.field_72984_F.func_76320_a("WaterCount");
        if (this.waterRescanDelay-- <= 0) {
            this.countWater();
            this.waterRescanDelay = 200;
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }
}

