/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.TreeFinder;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteUserBlocks;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.inventory.ItemSlotFilter;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class WorkSiteTreeFarm
extends TileWorksiteUserBlocks {
    private static final TreeFinder TREE = new TreeFinder(17);
    private static final TreeFinder LEAF = new TreeFinder(4);
    private boolean hasShears;
    private int saplingCount;
    private int bonemealCount;
    private final Set<BlockPosition> blocksToShear;
    private final Set<BlockPosition> blocksToChop = new HashSet<BlockPosition>();
    private final Set<BlockPosition> blocksToPlant = new HashSet<BlockPosition>();
    private final Set<BlockPosition> blocksToFertilize = new HashSet<BlockPosition>();

    public WorkSiteTreeFarm() {
        this.blocksToShear = new HashSet<BlockPosition>();
        InventoryTools.IndexHelper helper = new InventoryTools.IndexHelper();
        int[] topIndices = helper.getIndiceArrayForSpread(27);
        int[] frontIndices = helper.getIndiceArrayForSpread(3);
        int[] bottomIndices = helper.getIndiceArrayForSpread(3);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.TOP, BlockRotationHandler.RelativeSide.TOP, topIndices);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.FRONT, frontIndices);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.BOTTOM, BlockRotationHandler.RelativeSide.BOTTOM, bottomIndices);
        ItemSlotFilter filter = new ItemSlotFilter(){

            public boolean apply(ItemStack stack) {
                return stack == null || WorkSiteTreeFarm.this.isSapling(stack);
            }
        };
        this.inventory.setFilterForSlots(filter, frontIndices);
        filter = new ItemSlotFilter(){

            public boolean apply(ItemStack stack) {
                return stack == null || WorkSiteTreeFarm.this.isBonemeal(stack) || stack.func_77973_b() instanceof ItemShears;
            }
        };
        this.inventory.setFilterForSlots(filter, bottomIndices);
    }

    private boolean isSapling(ItemStack stack) {
        return this.isFarmable(Block.func_149634_a((Item)stack.func_77973_b()));
    }

    @Override
    protected boolean isFarmable(Block block, int x, int y, int z) {
        if (super.isFarmable(block, x, y, z)) {
            if (block instanceof BlockSapling) {
                return true;
            }
            if (!(block instanceof IShearable) && !(block instanceof BlockFlower)) {
                return ((IPlantable)block).getPlantType((IBlockAccess)this.field_145850_b, x, y, z) == EnumPlantType.Plains;
            }
        }
        return false;
    }

    @Override
    public void onBoundsAdjusted() {
        this.validateCollection(this.blocksToFertilize);
        int chops = this.blocksToChop.size();
        this.validateCollection(this.blocksToChop);
        if (this.blocksToChop.size() != chops) {
            this.func_70296_d();
        }
        this.validateCollection(this.blocksToPlant);
        if (!this.hasShears) {
            this.blocksToShear.clear();
        }
    }

    @Override
    protected void countResources() {
        this.hasShears = false;
        this.saplingCount = 0;
        this.bonemealCount = 0;
        for (int i = 27; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            if (i < 30) {
                if (!this.isSapling(stack)) continue;
                this.saplingCount += stack.field_77994_a;
                continue;
            }
            if (this.isBonemeal(stack)) {
                this.bonemealCount += stack.field_77994_a;
                continue;
            }
            if (!(stack.func_77973_b() instanceof ItemShears)) continue;
            this.hasShears = true;
        }
    }

    @Override
    protected boolean processWork() {
        block15: {
            block17: {
                BlockPosition position;
                block16: {
                    BlockPosition position2;
                    block14: {
                        BlockPosition position3;
                        if (!this.hasShears || this.blocksToShear.isEmpty()) break block14;
                        Iterator<BlockPosition> it = this.blocksToShear.iterator();
                        while (it.hasNext() && (position3 = it.next()) != null) {
                            it.remove();
                            Block block = this.field_145850_b.func_147439_a(position3.x, position3.y, position3.z);
                            if (!(block instanceof IShearable)) continue;
                            for (int i = 30; i < this.func_70302_i_(); ++i) {
                                ItemStack stack = this.func_70301_a(i);
                                if (stack == null || !(stack.func_77973_b() instanceof ItemShears) || !((IShearable)block).isShearable(stack, (IBlockAccess)this.field_145850_b, position3.x, position3.y, position3.z)) continue;
                                ArrayList drops = ((IShearable)block).onSheared(stack, (IBlockAccess)this.field_145850_b, position3.x, position3.y, position3.z, this.getFortune());
                                int[] combinedIndices = this.inventory.getRawIndicesCombined(BlockRotationHandler.RelativeSide.TOP, BlockRotationHandler.RelativeSide.FRONT);
                                for (ItemStack drop : drops) {
                                    if (drop == null) continue;
                                    drop = InventoryTools.mergeItemStack((IInventory)this.inventory, drop, combinedIndices);
                                    InventoryTools.dropItemInWorld(this.field_145850_b, drop, position3.x, position3.y, position3.z);
                                }
                                this.field_145850_b.func_147468_f(position3.x, position3.y, position3.z);
                                return true;
                            }
                        }
                        break block15;
                    }
                    if (this.blocksToChop.isEmpty()) break block16;
                    Iterator<BlockPosition> it = this.blocksToChop.iterator();
                    while (it.hasNext() && (position2 = it.next()) != null) {
                        it.remove();
                        if (!this.harvestBlock(position2.x, position2.y, position2.z, BlockRotationHandler.RelativeSide.TOP)) continue;
                        this.addLeavesAround(position2);
                        return true;
                    }
                    break block15;
                }
                if (this.saplingCount <= 0 || this.blocksToPlant.isEmpty()) break block17;
                ItemStack stack = null;
                for (int i = 27; !(i >= 30 || (stack = this.func_70301_a(i)) != null && this.isSapling(stack)); ++i) {
                    stack = null;
                }
                if (stack == null) break block15;
                Iterator<BlockPosition> it = this.blocksToPlant.iterator();
                while (it.hasNext() && (position = it.next()) != null) {
                    it.remove();
                    if (!this.canReplace(position.x, position.y, position.z) || !this.tryPlace(stack, position.x, position.y, position.z, ForgeDirection.UP)) continue;
                    --this.saplingCount;
                    return true;
                }
                break block15;
            }
            if (this.bonemealCount > 0 && !this.blocksToFertilize.isEmpty()) {
                BlockPosition position;
                Iterator<BlockPosition> it = this.blocksToFertilize.iterator();
                while (it.hasNext() && (position = it.next()) != null) {
                    it.remove();
                    Block block = this.field_145850_b.func_147439_a(position.x, position.y, position.z);
                    if (!this.isFarmable(block, position.x, position.y, position.z)) continue;
                    for (int i = 30; i < this.func_70302_i_(); ++i) {
                        ItemStack stack = this.func_70301_a(i);
                        if (stack == null || !this.isBonemeal(stack)) continue;
                        if (ItemDye.applyBonemeal((ItemStack)stack, (World)this.field_145850_b, (int)position.x, (int)position.y, (int)position.z, (EntityPlayer)this.getOwnerAsPlayer())) {
                            --this.bonemealCount;
                            if (stack.field_77994_a <= 0) {
                                this.func_70299_a(i, null);
                            }
                        }
                        if (this.isFarmable(block = this.field_145850_b.func_147439_a(position.x, position.y, position.z), position.x, position.y, position.z)) {
                            this.blocksToFertilize.add(position);
                        } else if (block.func_149688_o() == Material.field_151575_d) {
                            this.addTreeBlocks(block, position);
                        }
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    protected int[] getIndicesForPickup() {
        return this.inventory.getRawIndicesCombined(BlockRotationHandler.RelativeSide.BOTTOM, BlockRotationHandler.RelativeSide.FRONT, BlockRotationHandler.RelativeSide.TOP);
    }

    private void addTreeBlocks(Block block, BlockPosition base) {
        this.field_145850_b.field_72984_F.func_76320_a("TreeFinder");
        int chops = this.blocksToChop.size();
        TREE.findAttachedTreeBlocks(block, this.field_145850_b, base, this.blocksToChop);
        if (this.blocksToChop.size() != chops) {
            this.addLeavesAround(base);
            this.func_70296_d();
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    private void addLeavesAround(BlockPosition base) {
        if (this.hasShears) {
            this.addLeaves(base, -1, (byte)0);
            this.addLeaves(base, 1, (byte)1);
            this.addLeaves(base, -1, (byte)2);
        }
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.FORESTRY;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 25, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (!this.blocksToChop.isEmpty()) {
            NBTTagList chopList = new NBTTagList();
            for (BlockPosition position : this.blocksToChop) {
                chopList.func_74742_a((NBTBase)position.writeToNBT(new NBTTagCompound()));
            }
            tag.func_74782_a("targetList", (NBTBase)chopList);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.blocksToChop.clear();
        if (tag.func_74764_b("targetList")) {
            NBTTagList chopList = tag.func_150295_c("targetList", 10);
            for (int i = 0; i < chopList.func_74745_c(); ++i) {
                this.blocksToChop.add(new BlockPosition(chopList.func_150305_b(i)));
            }
        }
    }

    @Override
    protected void scanBlockPosition(BlockPosition pos) {
        if (this.canReplace(pos.x, pos.y, pos.z)) {
            Block block = this.field_145850_b.func_147439_a(pos.x, pos.y - 1, pos.z);
            if (block == Blocks.field_150346_d || block == Blocks.field_150349_c) {
                this.blocksToPlant.add(pos.copy());
            }
        } else {
            Block block = this.field_145850_b.func_147439_a(pos.x, pos.y, pos.z);
            if (this.isFarmable(block, pos.x, pos.y, pos.z)) {
                this.blocksToFertilize.add(pos.copy());
            } else if (block.func_149688_o() == Material.field_151575_d) {
                this.addTreeBlocks(block, pos);
            }
        }
    }

    private void addLeaves(BlockPosition position, int offset, byte xOrYOrZ) {
        BlockPosition pos = position;
        if (xOrYOrZ == 0) {
            pos = pos.offset(offset, 0, 0);
        } else if (xOrYOrZ == 1) {
            pos = pos.offset(0, offset, 0);
        } else if (xOrYOrZ == 2) {
            pos = pos.offset(0, 0, offset);
        }
        Block block = this.field_145850_b.func_147439_a(pos.x, pos.y, pos.z);
        if (block instanceof IShearable) {
            LEAF.findAttachedTreeBlocks(block, this.field_145850_b, pos, this.blocksToShear);
        }
        if (offset < 0) {
            this.addLeaves(position, -offset, xOrYOrZ);
        }
    }

    @Override
    protected boolean hasWorksiteWork() {
        return this.hasShears && !this.blocksToShear.isEmpty() || !this.blocksToChop.isEmpty() || this.bonemealCount > 0 && !this.blocksToFertilize.isEmpty() || this.saplingCount > 0 && !this.blocksToPlant.isEmpty();
    }
}

