/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.block.AWCoreBlockLoader;
import net.shadowmage.ancientwarfare.core.block.BlockIconMap;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.tile.TileResearchStation;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class BlockResearchStation
extends Block
implements BlockRotationHandler.IRotatableBlock {
    BlockIconMap iconMap = new BlockIconMap();

    public BlockResearchStation() {
        super(Material.field_151576_e);
        this.func_149647_a(AWCoreBlockLoader.coreTab);
        this.iconMap.setIconTexture(0, 0, "ancientwarfare:core/research_station_bottom");
        this.iconMap.setIconTexture(1, 0, "ancientwarfare:core/research_station_top");
        this.iconMap.setIconTexture(2, 0, "ancientwarfare:core/research_station_front");
        this.iconMap.setIconTexture(3, 0, "ancientwarfare:core/research_station_front");
        this.iconMap.setIconTexture(4, 0, "ancientwarfare:core/research_station_side");
        this.iconMap.setIconTexture(5, 0, "ancientwarfare:core/research_station_side");
        this.func_149711_c(2.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return this.iconMap.getIconFor(p_149691_1_, p_149691_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.iconMap.registerIcons(p_149651_1_);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileResearchStation();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int sideHit, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof IInteractableTile && ((IInteractableTile)te).onBlockClicked(player);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            InventoryTools.dropInventoryInWorld(world, (IInventory)tile, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    @Override
    public BlockRotationHandler.RotationType getRotationType() {
        return BlockRotationHandler.RotationType.FOUR_WAY;
    }

    @Override
    public boolean invertFacing() {
        return true;
    }

    @Override
    public Block setIcon(BlockRotationHandler.RelativeSide side, String texName) {
        return this;
    }
}

