/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.block;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.core.interfaces.INBTSerialable;
import net.shadowmage.ancientwarfare.core.inventory.ItemSlotFilter;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class BlockRotationHandler {
    public static int getRotatedMeta(IRotatableBlock block, int meta, ForgeDirection axis) {
        RotationType t = block.getRotationType();
        if (t == RotationType.NONE) {
            return meta;
        }
        ForgeDirection rotator = t == RotationType.FOUR_WAY ? ForgeDirection.DOWN : axis;
        ForgeDirection face = ForgeDirection.getOrientation((int)meta);
        face = face.getRotation(rotator);
        return face.ordinal();
    }

    public static int getMetaForPlacement(EntityLivingBase entity, IRotatableBlock block, int sideHit) {
        return BlockRotationHandler.getFaceForPlacement(entity, block, sideHit).ordinal();
    }

    public static ForgeDirection getFaceForPlacement(EntityLivingBase entity, IRotatableBlock block, int sideHit) {
        if (block.getRotationType() == RotationType.NONE) {
            return ForgeDirection.NORTH;
        }
        int f = BlockTools.getPlayerFacingFromYaw(entity.field_70177_z);
        ForgeDirection face = BlockTools.getForgeDirectionFromFacing(f);
        if (block.getRotationType() == RotationType.SIX_WAY && (sideHit == 0 || sideHit == 1)) {
            face = ForgeDirection.getOrientation((int)sideHit).getOpposite();
        }
        if (block.invertFacing()) {
            face = face.getOpposite();
        }
        return face;
    }

    public static class InventorySided
    implements ISidedInventory,
    INBTSerialable {
        private EnumSet<RelativeSide> validSides = EnumSet.of(RelativeSide.NONE);
        private HashMap<RelativeSide, RelativeSide> accessMap = new HashMap();
        private HashMap<RelativeSide, int[]> slotsByInventorySide = new HashMap();
        private HashMap<RelativeSide, boolean[]> extractInsertFlags = new HashMap();
        public final IRotatableTile te;
        public final RotationType rType;
        private ItemStack[] inventorySlots;
        private ItemSlotFilter[] filtersByInventorySlot;

        public InventorySided(IRotatableTile te, RotationType rType, int inventorySize) {
            if (te == null || rType == null || inventorySize <= 0) {
                throw new IllegalArgumentException("te and rotation type may not be null, inventory size must be greater than 0");
            }
            this.te = te;
            this.rType = rType;
            this.inventorySlots = new ItemStack[inventorySize];
            this.filtersByInventorySlot = new ItemSlotFilter[inventorySize];
            for (RelativeSide rSide : rType.getValidSides()) {
                this.setAccessibleSideDefault(rSide, RelativeSide.NONE, new int[0]);
            }
        }

        public void setAccessibleSideDefault(RelativeSide rSide, RelativeSide iSide, int[] indices) {
            if (rSide == null || iSide == null || indices == null) {
                throw new IllegalArgumentException("sides or indices may not be null!");
            }
            if (rSide == RelativeSide.NONE) {
                throw new IllegalArgumentException("base side may not be NONE");
            }
            this.addValidSide(iSide);
            this.accessMap.put(rSide, iSide);
            this.setInventoryIndices(iSide, indices);
        }

        public int[] getRawIndices(RelativeSide side) {
            return this.slotsByInventorySide.get((Object)side);
        }

        public int[] getRawIndicesCombined() {
            return this.getRawIndicesCombined(this.validSides.toArray(new RelativeSide[this.validSides.size()]));
        }

        public int[] getRawIndicesCombined(RelativeSide ... sides) {
            int[] indices;
            int len = 0;
            for (RelativeSide side : sides) {
                indices = this.getRawIndices(side);
                if (indices == null) continue;
                len += indices.length;
            }
            int[] combindedIndices = new int[len];
            int index = 0;
            for (RelativeSide side : sides) {
                indices = this.getRawIndices(side);
                if (indices == null) continue;
                int[] nArray = indices;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int i2;
                    combindedIndices[index] = i2 = nArray[i];
                    ++index;
                }
            }
            return combindedIndices;
        }

        private void addValidSide(RelativeSide side) {
            this.validSides.add(side);
        }

        public void remapSideAccess(RelativeSide baseSide, RelativeSide remappedSide) {
            boolean remapValid;
            boolean baseValid = this.rType.getValidSides().contains((Object)baseSide);
            boolean bl = remapValid = baseValid && this.getValidSides().contains((Object)remappedSide);
            if (!baseValid || !remapValid) {
                throw new IllegalArgumentException("could not remap: " + (Object)((Object)baseSide) + " to: " + (Object)((Object)remappedSide));
            }
            this.accessMap.put(baseSide, remappedSide);
            this.func_70296_d();
        }

        public RelativeSide getRemappedSide(RelativeSide accessSide) {
            if (!this.accessMap.containsKey((Object)accessSide)) {
                throw new IllegalArgumentException("no mapping exists for: " + (Object)((Object)accessSide));
            }
            return this.accessMap.get((Object)accessSide);
        }

        private void setInventoryIndices(RelativeSide inventorySide, int[] indices) {
            this.slotsByInventorySide.put(inventorySide, indices);
            this.func_70296_d();
        }

        public void setFilterForSlots(ItemSlotFilter filter, int[] indices) {
            for (int i : indices) {
                this.filtersByInventorySlot[i] = filter;
            }
        }

        public void setExtractInsertFlags(RelativeSide inventorySide, boolean[] flags) {
            if (inventorySide == null || inventorySide == RelativeSide.NONE || flags == null) {
                throw new IllegalArgumentException("inventory side must not be null or NONE, flags must not be null");
            }
            this.extractInsertFlags.put(inventorySide, flags);
        }

        public RelativeSide getInventorySide(int mcSide) {
            int meta = this.te.getPrimaryFacing().ordinal();
            RelativeSide rSide = RelativeSide.getSideViewed(this.rType, meta, mcSide);
            rSide = this.accessMap.get((Object)rSide);
            return rSide;
        }

        public ItemSlotFilter getFilterForSlot(int slot) {
            return this.filtersByInventorySlot[slot];
        }

        public int[] func_94128_d(int var1) {
            RelativeSide iSide = this.getInventorySide(var1);
            int[] slots = this.slotsByInventorySide.get((Object)iSide);
            return slots == null ? new int[]{} : slots;
        }

        public boolean func_102007_a(int slot, ItemStack var2, int mcSide) {
            RelativeSide iSide = this.getInventorySide(mcSide);
            if (iSide == null) {
                return false;
            }
            boolean[] flags = this.extractInsertFlags.get((Object)iSide);
            if (flags != null && !flags[1]) {
                return false;
            }
            return this.func_94041_b(slot, var2);
        }

        public boolean func_102008_b(int slot, ItemStack var2, int mcSide) {
            RelativeSide iSide = this.getInventorySide(mcSide);
            if (iSide == null) {
                return false;
            }
            boolean[] flags = this.extractInsertFlags.get((Object)iSide);
            return flags == null || flags[0];
        }

        public int func_70302_i_() {
            return this.inventorySlots.length;
        }

        public ItemStack func_70301_a(int var1) {
            return this.inventorySlots[var1];
        }

        public ItemStack func_70298_a(int var1, int var2) {
            ItemStack stack = this.inventorySlots[var1];
            if (stack != null) {
                int qty = var2 > stack.field_77994_a ? stack.field_77994_a : var2;
                stack.field_77994_a -= qty;
                ItemStack returnStack = stack.func_77946_l();
                returnStack.field_77994_a = qty;
                if (stack.field_77994_a <= 0) {
                    this.inventorySlots[var1] = null;
                }
                if (returnStack.field_77994_a <= 0) {
                    returnStack = null;
                }
                this.func_70296_d();
                return returnStack;
            }
            return null;
        }

        public ItemStack func_70304_b(int var1) {
            ItemStack stack = this.inventorySlots[var1];
            this.inventorySlots[var1] = null;
            this.func_70296_d();
            return stack;
        }

        public void func_70299_a(int var1, ItemStack var2) {
            this.inventorySlots[var1] = var2;
            this.func_70296_d();
        }

        public String func_145825_b() {
            return "aw_inventory_sided";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            ((TileEntity)this.te).func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer var1) {
            return true;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int var1, ItemStack var2) {
            ItemSlotFilter filter = this.filtersByInventorySlot[var1];
            return filter == null || filter.apply(var2);
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            InventoryTools.readInventoryFromNBT((IInventory)this, tag);
            NBTTagCompound accessTag = tag.func_74775_l("accessTag");
            int[] rMap = accessTag.func_74759_k("rMap");
            int[] rMap2 = accessTag.func_74759_k("iMap");
            for (int i = 0; i < rMap.length && i < rMap2.length; ++i) {
                RelativeSide rSide = RelativeSide.values()[rMap[i]];
                RelativeSide iSide = RelativeSide.values()[rMap2[i]];
                this.accessMap.put(rSide, iSide);
            }
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            InventoryTools.writeInventoryToNBT((IInventory)this, tag);
            int l = this.accessMap.size();
            int[] rMap = new int[l];
            int[] iMap = new int[l];
            int index = 0;
            for (RelativeSide rSide : this.accessMap.keySet()) {
                RelativeSide iSide = this.accessMap.get((Object)rSide);
                rMap[index] = rSide.ordinal();
                iMap[index] = iSide.ordinal();
                ++index;
            }
            NBTTagCompound accessTag = new NBTTagCompound();
            accessTag.func_74783_a("rMap", rMap);
            accessTag.func_74783_a("iMap", iMap);
            tag.func_74782_a("accessTag", (NBTBase)accessTag);
            return tag;
        }

        public int getAccessDirectionFor(RelativeSide blockSide) {
            return RelativeSide.getMCSideToAccess(this.rType, this.te.getPrimaryFacing().ordinal(), blockSide);
        }

        public EnumSet<RelativeSide> getValidSides() {
            return this.validSides;
        }
    }

    public static enum RelativeSide {
        TOP("guistrings.inventory.side.top"),
        BOTTOM("guistrings.inventory.side.bottom"),
        FRONT("guistrings.inventory.side.front"),
        REAR("guistrings.inventory.side.rear"),
        LEFT("guistrings.inventory.side.left"),
        RIGHT("guistrings.inventory.side.right"),
        ANY_SIDE("guistrings.inventory.side.all_sides"),
        NONE("guistrings.inventory.side.none");

        private static final int DOWN = 0;
        private static final int UP = 1;
        private static final int NORTH = 2;
        private static final int SOUTH = 3;
        private static final int WEST = 4;
        private static final int EAST = 5;
        public static final RelativeSide[][] sixWayMap;
        public static final RelativeSide[][] fourWayMap;
        public static final int[][] accessMapFourWay;
        private String key;

        private RelativeSide(String key) {
            this.key = key;
        }

        public String getTranslationKey() {
            return this.key;
        }

        public static RelativeSide getSideViewed(RotationType t, int meta, int side) {
            if (t == RotationType.FOUR_WAY) {
                return fourWayMap[side][meta];
            }
            if (t == RotationType.SIX_WAY) {
                return sixWayMap[side][meta];
            }
            return ANY_SIDE;
        }

        public static int getMCSideToAccess(RotationType t, int meta, RelativeSide access) {
            RelativeSide[][] map = t == RotationType.FOUR_WAY ? fourWayMap : sixWayMap;
            for (int x = 0; x < map.length; ++x) {
                if (map[x][meta] != access) continue;
                return x;
            }
            return -1;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            sixWayMap = new RelativeSide[6][6];
            fourWayMap = new RelativeSide[6][6];
            accessMapFourWay = new int[6][6];
            RelativeSide.sixWayMap[0][0] = TOP;
            RelativeSide.sixWayMap[0][1] = BOTTOM;
            RelativeSide.sixWayMap[0][2] = ANY_SIDE;
            RelativeSide.sixWayMap[0][3] = ANY_SIDE;
            RelativeSide.sixWayMap[0][4] = ANY_SIDE;
            RelativeSide.sixWayMap[0][5] = ANY_SIDE;
            RelativeSide.sixWayMap[1][0] = BOTTOM;
            RelativeSide.sixWayMap[1][1] = TOP;
            RelativeSide.sixWayMap[1][2] = ANY_SIDE;
            RelativeSide.sixWayMap[1][3] = ANY_SIDE;
            RelativeSide.sixWayMap[1][4] = ANY_SIDE;
            RelativeSide.sixWayMap[1][5] = ANY_SIDE;
            RelativeSide.sixWayMap[2][0] = ANY_SIDE;
            RelativeSide.sixWayMap[2][1] = ANY_SIDE;
            RelativeSide.sixWayMap[2][2] = TOP;
            RelativeSide.sixWayMap[2][3] = BOTTOM;
            RelativeSide.sixWayMap[2][4] = ANY_SIDE;
            RelativeSide.sixWayMap[2][5] = ANY_SIDE;
            RelativeSide.sixWayMap[3][0] = ANY_SIDE;
            RelativeSide.sixWayMap[3][1] = ANY_SIDE;
            RelativeSide.sixWayMap[3][2] = BOTTOM;
            RelativeSide.sixWayMap[3][3] = TOP;
            RelativeSide.sixWayMap[3][4] = ANY_SIDE;
            RelativeSide.sixWayMap[3][5] = ANY_SIDE;
            RelativeSide.sixWayMap[4][0] = ANY_SIDE;
            RelativeSide.sixWayMap[4][1] = ANY_SIDE;
            RelativeSide.sixWayMap[4][2] = ANY_SIDE;
            RelativeSide.sixWayMap[4][3] = ANY_SIDE;
            RelativeSide.sixWayMap[4][4] = TOP;
            RelativeSide.sixWayMap[4][5] = BOTTOM;
            RelativeSide.sixWayMap[5][0] = ANY_SIDE;
            RelativeSide.sixWayMap[5][1] = ANY_SIDE;
            RelativeSide.sixWayMap[5][2] = ANY_SIDE;
            RelativeSide.sixWayMap[5][3] = ANY_SIDE;
            RelativeSide.sixWayMap[5][4] = BOTTOM;
            RelativeSide.sixWayMap[5][5] = TOP;
            RelativeSide.fourWayMap[0][0] = ANY_SIDE;
            RelativeSide.fourWayMap[0][1] = ANY_SIDE;
            RelativeSide.fourWayMap[0][2] = BOTTOM;
            RelativeSide.fourWayMap[0][3] = BOTTOM;
            RelativeSide.fourWayMap[0][4] = BOTTOM;
            RelativeSide.fourWayMap[0][5] = BOTTOM;
            RelativeSide.fourWayMap[1][0] = ANY_SIDE;
            RelativeSide.fourWayMap[1][1] = ANY_SIDE;
            RelativeSide.fourWayMap[1][2] = TOP;
            RelativeSide.fourWayMap[1][3] = TOP;
            RelativeSide.fourWayMap[1][4] = TOP;
            RelativeSide.fourWayMap[1][5] = TOP;
            RelativeSide.fourWayMap[2][0] = ANY_SIDE;
            RelativeSide.fourWayMap[2][1] = ANY_SIDE;
            RelativeSide.fourWayMap[2][2] = FRONT;
            RelativeSide.fourWayMap[2][3] = REAR;
            RelativeSide.fourWayMap[2][4] = RIGHT;
            RelativeSide.fourWayMap[2][5] = LEFT;
            RelativeSide.fourWayMap[3][0] = ANY_SIDE;
            RelativeSide.fourWayMap[3][1] = ANY_SIDE;
            RelativeSide.fourWayMap[3][2] = REAR;
            RelativeSide.fourWayMap[3][3] = FRONT;
            RelativeSide.fourWayMap[3][4] = LEFT;
            RelativeSide.fourWayMap[3][5] = RIGHT;
            RelativeSide.fourWayMap[4][0] = ANY_SIDE;
            RelativeSide.fourWayMap[4][1] = ANY_SIDE;
            RelativeSide.fourWayMap[4][2] = LEFT;
            RelativeSide.fourWayMap[4][3] = RIGHT;
            RelativeSide.fourWayMap[4][4] = FRONT;
            RelativeSide.fourWayMap[4][5] = REAR;
            RelativeSide.fourWayMap[5][0] = ANY_SIDE;
            RelativeSide.fourWayMap[5][1] = ANY_SIDE;
            RelativeSide.fourWayMap[5][2] = RIGHT;
            RelativeSide.fourWayMap[5][3] = LEFT;
            RelativeSide.fourWayMap[5][4] = REAR;
            RelativeSide.fourWayMap[5][5] = FRONT;
        }
    }

    public static enum RotationType {
        FOUR_WAY(EnumSet.of(RelativeSide.TOP, new RelativeSide[]{RelativeSide.BOTTOM, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.REAR})),
        SIX_WAY(EnumSet.of(RelativeSide.TOP, RelativeSide.BOTTOM, RelativeSide.ANY_SIDE)),
        NONE(EnumSet.of(RelativeSide.TOP, new RelativeSide[]{RelativeSide.BOTTOM, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.FRONT, RelativeSide.REAR}));

        EnumSet<RelativeSide> validSides;

        private RotationType(EnumSet<RelativeSide> sides) {
            this.validSides = sides;
        }

        public EnumSet<RelativeSide> getValidSides() {
            return this.validSides;
        }
    }

    public static interface IRotatableTile {
        public ForgeDirection getPrimaryFacing();

        public void setPrimaryFacing(ForgeDirection var1);
    }

    public static interface IRotatableBlock {
        public RotationType getRotationType();

        public boolean invertFacing();

        public Block setIcon(RelativeSide var1, String var2);
    }
}

